/*
 * Decompiled with CFR 0.152.
 */
package com.paneedah.weaponlib.debug;

import java.io.FileDescriptor;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;

public class SysOutController {
    private static final OutputStream CONSOLE_OUT_STREAM = new FileOutputStream(FileDescriptor.out);

    private static void setOutputStream(OutputStream out) {
        System.setOut(new PrintStream(out));
    }

    public static void reset() {
        SysOutController.setOutputStream(CONSOLE_OUT_STREAM);
    }

    public static void blockAllSysOut() {
        SysOutController.setOutputStream(new OutputStream(){

            @Override
            public void write(int b) throws IOException {
            }
        });
    }

    public static void revealCallLocations() {
        SysOutController.setOutputStream(new OutputStream(){

            @Override
            public void write(int b) throws IOException {
                CONSOLE_OUT_STREAM.write(b);
                if (b == 10) {
                    StackTraceElement stackTrace = new Throwable().getStackTrace()[9];
                    String pathData = "(" + stackTrace.getFileName() + " : " + stackTrace.getLineNumber() + ") [" + stackTrace + "]\n";
                    CONSOLE_OUT_STREAM.write(pathData.getBytes());
                }
            }
        });
    }
}

