/*
 * Decompiled with CFR 0.152.
 */
package com.paneedah.weaponlib.crafting.base;

import com.paneedah.mwc.MWC;
import com.paneedah.mwc.network.messages.WorkbenchServerMessage;
import com.paneedah.mwc.proxies.ClientProxy;
import com.paneedah.mwc.utils.ModReference;
import com.paneedah.weaponlib.ModContext;
import com.paneedah.weaponlib.animation.gui.GuiRenderUtil;
import com.paneedah.weaponlib.crafting.CraftingEntry;
import com.paneedah.weaponlib.crafting.IModernCraftingRecipe;
import com.paneedah.weaponlib.crafting.base.ContainerStation;
import com.paneedah.weaponlib.crafting.base.TileEntityStation;
import com.paneedah.weaponlib.crafting.workbench.CustomSearchTextField;
import com.paneedah.weaponlib.crafting.workbench.GUIButtonCustom;
import com.paneedah.weaponlib.render.gui.GUIRenderHelper;
import com.paneedah.weaponlib.vehicle.jimphysics.InterpolationKit;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.concurrent.TimeUnit;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.block.model.ItemCameraTransforms;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.inventory.Container;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.oredict.OreDictionary;
import org.lwjgl.input.Mouse;

public abstract class GUIContainerStation<T extends TileEntityStation>
extends GuiContainer {
    protected static final ResourceLocation GUI_TEX = new ResourceLocation("mwc:textures/gui/workshop_sheet.png");
    protected static final ResourceLocation GUI_INV_TEX = new ResourceLocation("mwc:textures/gui/workbench_inv_sheet.png");
    private static final int GUI_TEXTURE_WIDTH = 402;
    private static final int GUI_TEXTURE_HEIGHT = 240;
    protected static final int GRAY = 0x7B7B7B;
    protected static final int RED = 11099743;
    protected static final int GOLD = 16642428;
    protected static final int BLUE = 9422307;
    protected static final int GREEN = 9954196;
    protected static final int LIGHT_GREY = 0xDADADA;
    protected GUIButtonCustom craftButton;
    protected GUIButtonCustom leftArrow;
    protected GUIButtonCustom rightArrow;
    protected GUIButtonCustom dismantleButton;
    protected CustomSearchTextField searchBox;
    protected T tileEntity;
    private final ArrayList<String> tooltipRenderItem = new ArrayList();
    protected static ModContext modContext;
    private IModernCraftingRecipe selectedCraftingPiece = null;
    private boolean hasRequiredItems = false;
    protected HashMap<Item, Boolean> hasAvailableMaterials = new HashMap();
    private int craftingMode = 1;
    protected ArrayList<IModernCraftingRecipe> filteredCraftingList = new ArrayList();
    private int page = 1;
    private int minPage;
    private int maxPage;
    private boolean scrollBarGrabbed = false;
    private double scrollBarProgress;
    private int scrollOffsetAtGrab;
    private int grabY;
    private int scrollBarOffset = 0;

    public GUIContainerStation(T tileEntity, Container c) {
        super(c);
        this.field_146999_f = 402;
        this.field_147000_g = 240;
        this.setPageRange(1, 2);
        this.tileEntity = tileEntity;
    }

    public void func_73866_w_() {
        super.func_73866_w_();
        this.searchBox = new CustomSearchTextField(GUI_TEX, "Search Items...", 0, 0, this.field_146289_q, this.field_147003_i + 15, this.field_147009_r + 32, 84, 13);
        this.searchBox.func_146203_f(50);
        this.searchBox.func_146185_a(true);
        this.searchBox.func_146189_e(true);
        this.searchBox.func_146193_g(0xFFFFFF);
        this.craftButton = new GUIButtonCustom(GUI_TEX, 0, this.field_147003_i + 211, this.field_147009_r + 179, 53, 17, 480, 370, "CRAFT").withStandardState(0x7B7B7B, 0, 240).withHoveredState(16642428, 0, 257).withErroredState(11099743, 0, 274).withPageRestriction(2);
        this.leftArrow = new GUIButtonCustom(GUI_TEX, 1, this.field_147003_i + 318, this.field_147009_r, 42, 20, 480, 370, "").withStandardState(0xFFFFFF, 99, 304).withHoveredState(0xFFFFFF, 141, 304).withDisabledState(0xFFFFFF, 57, 304).withDisabledCheck(() -> this.getPage() == 1);
        this.rightArrow = new GUIButtonCustom(GUI_TEX, 2, this.field_147003_i + 360, this.field_147009_r, 42, 20, 480, 370, "").withStandardState(0xFFFFFF, 99, 284).withHoveredState(0xFFFFFF, 141, 284).withDisabledState(0xFFFFFF, 57, 284).withDisabledCheck(() -> this.getPage() == 2);
        this.dismantleButton = new GUIButtonCustom(GUI_INV_TEX, 6, this.field_147003_i + 286, this.field_147009_r + 70, 73, 17, 480, 370, "DISMANTLE").withStandardState(0x7B7B7B, 0, 283).withHoveredState(16642428, 0, 300).withErroredState(11099743, 0, 317).withPageRestriction(1);
        this.craftButton.setErrored(true);
        this.func_189646_b(this.craftButton);
        this.func_189646_b(this.leftArrow);
        this.func_189646_b(this.rightArrow);
        this.func_189646_b(this.dismantleButton);
        this.setPage(1);
        this.fillFilteredList();
    }

    protected void func_146284_a(GuiButton button) throws IOException {
        super.func_146284_a(button);
        if (button == this.dismantleButton) {
            MWC.CHANNEL.sendToServer((IMessage)new WorkbenchServerMessage(2, this.tileEntity.func_174877_v(), 0, -1, null, ""));
        } else if (button == this.leftArrow) {
            this.setPage(this.getPage() - 1);
        } else if (button == this.rightArrow) {
            this.setPage(this.getPage() + 1);
            if (this.getPage() == 2) {
                ((TileEntityStation)((Object)this.tileEntity)).pushInventoryRefresh = true;
            }
        }
    }

    public abstract boolean requiresMaterialsToSubmitCraftRequest();

    public abstract void fillFilteredList();

    public int getCraftingMode() {
        return this.craftingMode;
    }

    public void setCraftingMode(int mode) {
        this.craftButton.setErrored(true);
        this.craftingMode = mode;
    }

    public IModernCraftingRecipe getSelectedCraftingPiece() {
        return this.selectedCraftingPiece;
    }

    public void setSelectedCraftingPiece(IModernCraftingRecipe modernCrafting) {
        this.selectedCraftingPiece = modernCrafting;
    }

    public boolean hasSelectedCraftingPiece() {
        return this.getSelectedCraftingPiece() != null;
    }

    public void onSelectNewCrafting(IModernCraftingRecipe crafting) {
        CraftingEntry[] modernRecipe = crafting.getModernRecipe();
        HashMap<Item, Integer> counter = new HashMap<Item, Integer>();
        for (int i = 22; i < ((TileEntityStation)((Object)this.tileEntity)).mainInventory.getSlots(); ++i) {
            ItemStack stack = ((TileEntityStation)((Object)this.tileEntity)).mainInventory.getStackInSlot(i);
            if (stack.func_190926_b()) continue;
            Item item = stack.func_77973_b();
            if (!counter.containsKey(item)) {
                counter.put(item, stack.func_190916_E());
                continue;
            }
            counter.put(item, (Integer)counter.get(item) + stack.func_190916_E());
        }
        this.hasRequiredItems = true;
        for (CraftingEntry is : modernRecipe) {
            if (is.isOreDictionary()) {
                NonNullList list = OreDictionary.getOres((String)is.getOreDictionaryEntry());
                boolean foundSomething = false;
                for (ItemStack toTest : list) {
                    if (counter.containsKey(toTest.func_77973_b()) && toTest.func_190916_E() <= (Integer)counter.get(toTest.func_77973_b())) {
                        foundSomething = true;
                        this.hasAvailableMaterials.put(is.getItem(), true);
                        break;
                    }
                    this.hasRequiredItems = false;
                }
                if (foundSomething && is.getCount() <= (Integer)counter.get(is.getItem())) continue;
                this.hasRequiredItems = false;
                this.hasAvailableMaterials.put(is.getItem(), false);
                continue;
            }
            if (!counter.containsKey(is.getItem())) {
                this.hasRequiredItems = false;
                this.hasAvailableMaterials.put(is.getItem(), false);
                continue;
            }
            if (is.getCount() > (Integer)counter.get(is.getItem())) {
                this.hasRequiredItems = false;
                this.hasAvailableMaterials.put(is.getItem(), false);
                continue;
            }
            this.hasAvailableMaterials.put(is.getItem(), true);
        }
        if (this.requiresMaterialsToSubmitCraftRequest()) {
            this.craftButton.setErrored(!this.hasRequiredItems);
        } else {
            this.craftButton.setErrored(false);
        }
    }

    public static void setModContext(ModContext context) {
        modContext = context;
    }

    public void setPageRange(int min, int max) {
        this.minPage = min;
        this.maxPage = max;
    }

    public int getPage() {
        return this.page;
    }

    public String format(String unloc) {
        return I18n.func_135052_a((String)(unloc + ".name"), (Object[])new Object[0]);
    }

    public boolean hasRequiredItems() {
        return this.hasRequiredItems;
    }

    public void func_73876_c() {
        super.func_73876_c();
        this.tooltipRenderItem.clear();
        if (((TileEntityStation)((Object)this.tileEntity)).pushInventoryRefresh) {
            ((TileEntityStation)((Object)this.tileEntity)).pushInventoryRefresh = false;
            if (this.selectedCraftingPiece != null) {
                this.onSelectNewCrafting(this.selectedCraftingPiece);
            }
        }
    }

    public void addCustomTooltipInformation(int mouseX, int mouseY, ArrayList<String> tooltip) {
    }

    public abstract void addCraftingInformationToTooltip(ArrayList<String> var1);

    public void drawTooltips(int mouseX, int mouseY, float partialTicks) {
        this.func_191948_b(mouseX, mouseY);
        if (this.tooltipRenderItem != null && !this.tooltipRenderItem.isEmpty()) {
            this.func_146283_a(this.tooltipRenderItem, mouseX, mouseY);
        }
        ArrayList<String> strings = new ArrayList<String>();
        this.addCustomTooltipInformation(mouseX, mouseY, strings);
        if (GUIRenderHelper.checkInBox(mouseX, mouseY, this.field_147003_i + 304, this.field_147009_r + 185, 81.0, 11.0) && ((TileEntityStation)((Object)this.tileEntity)).craftingTimer != -1) {
            this.addCraftingInformationToTooltip(strings);
        }
        if (GUIRenderHelper.checkInBox(mouseX, mouseY, this.field_147003_i + 261, this.field_147009_r + 57, 122.0, 7.0)) {
            for (int i = 0; i < 4; ++i) {
                if (((TileEntityStation)((Object)this.tileEntity)).dismantleStatus[i] == -1 || ((TileEntityStation)((Object)this.tileEntity)).dismantleDuration[i] == -1 || !GUIRenderHelper.checkInBox(mouseX, mouseY, this.field_147003_i + 261 + i * 31, this.field_147009_r + 57, 29.0, 7.0)) continue;
                ItemStack stack = ((TileEntityStation)((Object)this.tileEntity)).mainInventory.getStackInSlot(i + 9);
                Item item = stack.func_77973_b();
                if (stack.func_190926_b()) continue;
                int seconds = (((TileEntityStation)((Object)this.tileEntity)).dismantleDuration[i] - ((TileEntityStation)((Object)this.tileEntity)).dismantleStatus[i]) / 20;
                strings.add(TextFormatting.BLUE + "Dismantling: " + TextFormatting.WHITE + I18n.func_135052_a((String)(((TileEntityStation)((Object)this.tileEntity)).mainInventory.getStackInSlot(i + 9).func_77973_b().func_77658_a() + ".name"), (Object[])new Object[0]));
                strings.add(TextFormatting.BLUE + "Time remaining: " + TextFormatting.WHITE + GUIRenderHelper.formatTimeString(seconds, TimeUnit.SECONDS));
                strings.add(TextFormatting.BLUE + "Products:");
                for (CraftingEntry s : ((IModernCraftingRecipe)item).getModernRecipe()) {
                    strings.add(TextFormatting.GOLD + String.valueOf((int)Math.round((double)s.getCount() * s.getYield())) + "x " + TextFormatting.WHITE + this.format(s.getItem().func_77658_a()));
                }
            }
        }
        if (!strings.isEmpty()) {
            this.func_146283_a(strings, mouseX, mouseY);
        }
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
        super.func_73863_a(mouseX, mouseY, partialTicks);
        if (this.getPage() == 2) {
            this.searchBox.func_146194_f();
        }
    }

    protected void func_73864_a(int mouseX, int mouseY, int mouseButton) throws IOException {
        super.func_73864_a(mouseX, mouseY, mouseButton);
        this.searchBox.func_146192_a(mouseX, mouseY, mouseButton);
        if (GUIRenderHelper.checkInBox(mouseX, mouseY, this.field_147003_i + 40, this.field_147009_r + 219, 176.0, 20.0)) {
            int boxId = (mouseX - (this.field_147003_i + 40)) / 20;
            MWC.CHANNEL.sendToServer((IMessage)new WorkbenchServerMessage(3, this.tileEntity.func_174877_v(), ClientProxy.MC.field_71439_g.func_145782_y(), boxId));
        }
        int c = (int)Math.floor((double)this.filteredCraftingList.size() * this.scrollBarProgress / 7.0) * 7;
        for (int y = 0; y < 6; ++y) {
            for (int x = 0; x < 7 && c != this.filteredCraftingList.size(); ++c, ++x) {
                boolean selected = GUIRenderHelper.checkInBox(mouseX, mouseY, this.field_147003_i + 12 + x * 23, this.field_147009_r + 52 + y * 23, 22.0, 22.0);
                if (!selected) continue;
                this.onSelectNewCrafting(this.filteredCraftingList.get(c));
                this.setSelectedCraftingPiece(this.filteredCraftingList.get(c));
            }
        }
    }

    protected void func_73869_a(char typedChar, int keyCode) throws IOException {
        boolean cancellationFlag;
        boolean bl = cancellationFlag = this.searchBox.func_146179_b().length() == 0 && keyCode == 14;
        if (!ClientProxy.MC.field_71474_y.field_151445_Q.isActiveAndMatches(keyCode) || !this.searchBox.func_146206_l()) {
            super.func_73869_a(typedChar, keyCode);
        }
        this.searchBox.func_146201_a(typedChar, keyCode);
        if (!cancellationFlag) {
            if (keyCode == 14) {
                this.fillFilteredList();
            }
            if (!this.searchBox.func_146179_b().isEmpty()) {
                this.filteredCraftingList.removeIf(a -> !I18n.func_135052_a((String)(a.getItemStack().func_77977_a() + ".name"), (Object[])new Object[0]).toLowerCase().contains(this.searchBox.func_146179_b().toLowerCase()));
            }
        }
    }

    public void setItemRenderTooltip(ItemStack stack, String ... strings) {
        if (stack.func_190926_b()) {
            return;
        }
        this.tooltipRenderItem.clear();
        this.tooltipRenderItem.add(this.format(stack.func_77973_b().func_77658_a()));
        ITooltipFlag.TooltipFlags flag = ClientProxy.MC.field_71474_y.field_82882_x ? ITooltipFlag.TooltipFlags.ADVANCED : ITooltipFlag.TooltipFlags.NORMAL;
        stack.func_77973_b().func_77624_a(stack, this.tileEntity.func_145831_w(), this.tooltipRenderItem, (ITooltipFlag)flag);
        if (strings.length > 0) {
            this.tooltipRenderItem.addAll(Arrays.asList(strings));
        }
    }

    protected void setPage(int id) {
        if (id < this.minPage) {
            id = this.minPage;
        }
        if (id > this.maxPage) {
            id = this.maxPage;
        }
        this.scrollBarProgress = 0.0;
        this.scrollBarOffset = 0;
        this.page = id;
        ((ContainerStation)this.field_147002_h).page = id;
        for (GuiButton b : this.field_146292_n) {
            if (!(b instanceof GUIButtonCustom) || ((GUIButtonCustom)b).getPageID() == -1) continue;
            b.field_146125_m = ((GUIButtonCustom)b).getPageID() == id;
        }
    }

    public void render3DItemInGUI(Item item, int x, int y, int mouseX, int mouseY) {
        GlStateManager.func_179094_E();
        GlStateManager.func_179109_b((float)x, (float)y, (float)100.0f);
        GlStateManager.func_179109_b((float)8.0f, (float)8.0f, (float)0.0f);
        GlStateManager.func_179152_a((float)1.0f, (float)-1.0f, (float)1.0f);
        GlStateManager.func_179152_a((float)20.0f, (float)20.0f, (float)20.0f);
        GlStateManager.func_179114_b((float)(15.0f + (float)mouseY * 0.01f), (float)1.0f, (float)0.0f, (float)0.0f);
        GlStateManager.func_179114_b((float)(120.0f + (float)mouseX * 0.01f), (float)0.0f, (float)1.0f, (float)0.0f);
        GlStateManager.func_179114_b((float)0.0f, (float)0.0f, (float)0.0f, (float)1.0f);
        GlStateManager.func_179152_a((float)4.0f, (float)4.0f, (float)4.0f);
        GlStateManager.func_179145_e();
        RenderHelper.func_74519_b();
        ClientProxy.MC.func_175599_af().func_181564_a(new ItemStack(item), ItemCameraTransforms.TransformType.THIRD_PERSON_LEFT_HAND);
        RenderHelper.func_74518_a();
        GlStateManager.func_179140_f();
        GlStateManager.func_179121_F();
    }

    public boolean shouldOverrideCraftingModeOneRender() {
        return false;
    }

    public void doCraftingModeOneRender(float partialTicks, int mouseX, int mouseY) {
    }

    protected void func_146976_a(float partialTicks, int mouseX, int mouseY) {
        this.func_146276_q_();
        GlStateManager.func_179147_l();
        if (this.getPage() == 1) {
            ClientProxy.MC.func_110434_K().func_110577_a(GUI_INV_TEX);
            GUIContainerStation.func_146110_a((int)this.field_147003_i, (int)this.field_147009_r, (float)0.0f, (float)0.0f, (int)402, (int)232, (float)480.0f, (float)370.0f);
            for (int i = 0; i < 4; ++i) {
                if (((TileEntityStation)((Object)this.tileEntity)).dismantleStatus[i] == -1 || ((TileEntityStation)((Object)this.tileEntity)).dismantleDuration[i] == -1) continue;
                double progress = InterpolationKit.interpolateValue(((TileEntityStation)((Object)this.tileEntity)).previousDismantleStatus[i], ((TileEntityStation)((Object)this.tileEntity)).dismantleStatus[i], ClientProxy.MC.func_184121_ak()) / (double)((TileEntityStation)((Object)this.tileEntity)).dismantleDuration[i];
                GUIContainerStation.func_146110_a((int)(this.field_147003_i + 261 + i * 31), (int)(this.field_147009_r + 57), (float)81.0f, (float)232.0f, (int)29, (int)7, (float)480.0f, (float)370.0f);
                GUIContainerStation.func_146110_a((int)(this.field_147003_i + 261 + i * 31), (int)(this.field_147009_r + 57), (float)81.0f, (float)239.0f, (int)((int)(29.0 * progress)), (int)7, (float)480.0f, (float)370.0f);
            }
            GUIRenderHelper.drawScaledString("INVENTORY", this.field_147003_i + 10, this.field_147009_r + 5, 1.2, 9422307);
            GUIRenderHelper.drawScaledString("Player Inventory", this.field_147003_i + 21, this.field_147009_r + 115, 1.0, 0xDADADA);
        } else if (this.getPage() == 2) {
            int i;
            boolean playerInventoryFull;
            IModernCraftingRecipe weapon;
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            GlStateManager.func_179094_E();
            ClientProxy.MC.func_110434_K().func_110577_a(GUI_TEX);
            GlStateManager.func_179147_l();
            GUIContainerStation.func_146110_a((int)this.field_147003_i, (int)this.field_147009_r, (float)0.0f, (float)0.0f, (int)192, (int)210, (float)480.0f, (float)370.0f);
            GUIContainerStation.func_146110_a((int)(200 + this.field_147003_i), (int)(20 + this.field_147009_r), (float)200.0f, (float)20.0f, (int)202, (int)190, (float)480.0f, (float)370.0f);
            GUIContainerStation.func_146110_a((int)this.field_147003_i, (int)(213 + this.field_147009_r), (float)0.0f, (float)213.0f, (int)241, (int)27, (float)480.0f, (float)370.0f);
            double prevProgress = (double)Math.max(((TileEntityStation)((Object)this.tileEntity)).prevCraftingTimer, 0) / (double)((TileEntityStation)((Object)this.tileEntity)).craftingDuration;
            double currProgress = (double)Math.max(((TileEntityStation)((Object)this.tileEntity)).craftingTimer, 0) / (double)((TileEntityStation)((Object)this.tileEntity)).craftingDuration;
            double intpProgress = InterpolationKit.interpolateValue(prevProgress, currProgress, ClientProxy.MC.func_184121_ak());
            double progress = 0.025 * (double)Math.round(intpProgress / 0.025);
            GUIContainerStation.func_146110_a((int)(this.field_147003_i + 304), (int)(this.field_147009_r + 185), (float)53.0f, (float)240.0f, (int)81, (int)11, (float)480.0f, (float)370.0f);
            GUIContainerStation.func_146110_a((int)(this.field_147003_i + 304), (int)(this.field_147009_r + 185), (float)53.0f, (float)251.0f, (int)((int)(81.0 * progress)), (int)11, (float)480.0f, (float)370.0f);
            if (!Mouse.isButtonDown((int)0)) {
                this.scrollBarGrabbed = false;
            }
            int scrollBarVertical = this.field_147009_r + 54 + this.scrollBarOffset;
            int scrollBarHeight = (int)(138.0 * Math.min(1.0, 42.0 / (double)this.filteredCraftingList.size()));
            GUIContainerStation.func_146110_a((int)(this.field_147003_i + 176), (int)scrollBarVertical, (float)412.0f, (float)54.0f, (int)6, (int)scrollBarHeight, (float)480.0f, (float)370.0f);
            if (Mouse.isButtonDown((int)0) && GUIRenderHelper.checkInBox(mouseX, mouseY, this.field_147003_i + 176, scrollBarVertical, 6.0, scrollBarHeight) && !this.scrollBarGrabbed) {
                this.scrollBarGrabbed = true;
                this.scrollOffsetAtGrab = this.scrollBarOffset;
                this.grabY = mouseY;
            }
            if (this.scrollBarGrabbed) {
                this.scrollBarOffset = this.scrollOffsetAtGrab + (mouseY - this.grabY);
                if (this.scrollBarOffset + scrollBarHeight > 138) {
                    this.scrollBarOffset = 138 - scrollBarHeight;
                } else if (this.scrollBarOffset < 0) {
                    this.scrollBarOffset = 0;
                }
            }
            this.scrollBarProgress = (double)this.scrollBarOffset / (138.0 - (double)scrollBarHeight);
            if (Double.isNaN(this.scrollBarProgress)) {
                this.scrollBarProgress = 0.0;
            }
            if (!this.filteredCraftingList.isEmpty()) {
                int c = (int)Math.floor((double)this.filteredCraftingList.size() * this.scrollBarProgress / 7.0) * 7;
                for (int y = 0; y < 6; ++y) {
                    for (int x = 0; x < 7 && c < this.filteredCraftingList.size(); ++c, ++x) {
                        if (this.filteredCraftingList.get(c) == this.getSelectedCraftingPiece()) {
                            GUIContainerStation.func_146110_a((int)(this.field_147003_i + 12 + x * 23), (int)(this.field_147009_r + 52 + y * 23), (float)53.0f, (float)262.0f, (int)22, (int)22, (float)480.0f, (float)370.0f);
                        } else {
                            boolean selected = GUIRenderHelper.checkInBox(mouseX, mouseY, this.field_147003_i + 12 + x * 23, this.field_147009_r + 52 + y * 23, 22.0, 22.0);
                            if (!selected) {
                                GUIContainerStation.func_146110_a((int)(this.field_147003_i + 12 + x * 23), (int)(this.field_147009_r + 52 + y * 23), (float)75.0f, (float)262.0f, (int)22, (int)22, (float)480.0f, (float)370.0f);
                            } else {
                                this.setItemRenderTooltip(this.filteredCraftingList.get(c).getItemStack(), new String[0]);
                                GUIContainerStation.func_146110_a((int)(this.field_147003_i + 12 + x * 23), (int)(this.field_147009_r + 52 + y * 23), (float)97.0f, (float)262.0f, (int)22, (int)22, (float)480.0f, (float)370.0f);
                            }
                        }
                        RenderHelper.func_74520_c();
                        ClientProxy.MC.func_175599_af().func_175042_a(this.filteredCraftingList.get(c).getItemStack(), this.field_147003_i + 15 + x * 23, this.field_147009_r + 55 + y * 23);
                        ClientProxy.MC.func_110434_K().func_110577_a(GUI_TEX);
                        RenderHelper.func_74518_a();
                    }
                }
            }
            if (this.getCraftingMode() == 1 && this.hasSelectedCraftingPiece() && this.shouldOverrideCraftingModeOneRender()) {
                this.doCraftingModeOneRender(partialTicks, mouseX, mouseY);
            } else if (this.hasSelectedCraftingPiece()) {
                GuiRenderUtil.drawScaledString(this.field_146289_q, this.format(this.getSelectedCraftingPiece().getItemStack().func_77977_a()), this.field_147003_i + 214, this.field_147009_r + 31, 0.9, 16642428);
                GlStateManager.func_179094_E();
                RenderHelper.func_74520_c();
                GlStateManager.func_179109_b((float)(this.field_147003_i + 275), (float)(this.field_147009_r + 45), (float)0.0f);
                GlStateManager.func_179152_a((float)3.0f, (float)3.0f, (float)3.0f);
                ClientProxy.MC.func_175599_af().func_175042_a(this.getSelectedCraftingPiece().getItemStack(), 0, 0);
                GlStateManager.func_179121_F();
            }
            GlStateManager.func_179147_l();
            GuiRenderUtil.drawScaledString(this.field_146289_q, "CRAFTING", this.field_147003_i + 11, this.field_147009_r + 5, 1.2, 9422307);
            GuiRenderUtil.drawScaledString(this.field_146289_q, "Progress", this.field_147003_i + 326, this.field_147009_r + 175, 0.8, 0xFFFFFF);
            GuiRenderUtil.drawScaledString(this.field_146289_q, "Output", this.field_147003_i + 7, this.field_147009_r + 223, 0.9, 0xFFFFFF);
            GuiRenderUtil.drawScaledString(this.field_146289_q, "CRAFT", this.field_147003_i + 222, this.field_147009_r + 184, 1.0, 11559009);
            GuiRenderUtil.drawScaledString(this.field_146289_q, "Results: " + TextFormatting.YELLOW + "" + this.filteredCraftingList.size(), this.field_147003_i + 12, this.field_147009_r + 191, 0.8, 0xFFFFFF);
            if (this.hasSelectedCraftingPiece() && (weapon = this.getSelectedCraftingPiece()).getModernRecipe() != null && weapon.getModernRecipe().length != 0) {
                int c = 0;
                for (CraftingEntry stack : weapon.getModernRecipe()) {
                    if (stack.getItem() == null) {
                        ModReference.LOG.warn("Skipped resource");
                        continue;
                    }
                    ItemStack itemStack = new ItemStack(stack.getItem());
                    boolean hasItem = this.hasAvailableMaterials.get(stack.getItem());
                    int x = this.field_147003_i + 210 + c * 20;
                    int y = this.field_147009_r + 122;
                    ClientProxy.MC.func_110434_K().func_110577_a(GUI_TEX);
                    if (GUIRenderHelper.checkInBox(mouseX, mouseY, x, y, 15.0, 15.0)) {
                        Item item = stack.getItem();
                        int percentage = (int)Math.round(stack.getYield() * 100.0);
                        TextFormatting formatColor = percentage <= 25 ? TextFormatting.RED : (percentage <= 50 ? TextFormatting.GOLD : (percentage <= 75 ? TextFormatting.YELLOW : TextFormatting.GREEN));
                        this.setItemRenderTooltip(itemStack, formatColor + "" + percentage + "% Yield");
                        GlStateManager.func_179098_w();
                        ClientProxy.MC.func_110434_K().func_110577_a(GUI_TEX);
                        GlStateManager.func_179147_l();
                    }
                    GlStateManager.func_179094_E();
                    GlStateManager.func_179124_c((float)1.0f, (float)1.0f, (float)1.0f);
                    GlStateManager.func_179137_b((double)((double)x + 0.5), (double)((double)y + 0.5), (double)0.0);
                    GlStateManager.func_179139_a((double)0.125, (double)0.125, (double)0.125);
                    if (hasItem) {
                        GUIContainerStation.func_146110_a((int)0, (int)0, (float)242.0f, (float)215.0f, (int)113, (int)114, (float)480.0f, (float)370.0f);
                    } else {
                        GUIContainerStation.func_146110_a((int)0, (int)0, (float)358.0f, (float)215.0f, (int)113, (int)114, (float)480.0f, (float)370.0f);
                    }
                    GlStateManager.func_179121_F();
                    ClientProxy.MC.func_175599_af().func_175042_a(itemStack, x, y);
                    GUIRenderHelper.drawScaledString("x" + stack.getCount(), x + 8, y + 12, 0.6, hasItem ? 9954196 : 11099743);
                    ++c;
                }
            }
            GlStateManager.func_179121_F();
            boolean bl = playerInventoryFull = ClientProxy.MC.field_71439_g.field_71071_by.func_70447_i() == -1;
            if (playerInventoryFull) {
                GUIRenderHelper.drawAlignedString("Inventory Full!", GUIRenderHelper.StringAlignment.LEFT, false, this.field_147003_i + 245, this.field_147009_r + 214, 1.0, 11099743);
            }
            for (i = 0; i < 9; ++i) {
                ItemStack stack = ((TileEntityStation)((Object)this.tileEntity)).mainInventory.getStackInSlot(i);
                ClientProxy.MC.func_110434_K().func_110577_a(GUI_TEX);
                if (GUIRenderHelper.checkInBox(mouseX, mouseY, this.field_147003_i + 40 + i * 22, this.field_147009_r + 219, 20.0, 20.0)) {
                    GUIRenderHelper.drawTexturedRect(this.field_147003_i + 39 + i * 22, this.field_147009_r + 218, playerInventoryFull ? 18.0f : 0.0f, 351.0f, 18.0, 18.0, 480.0, 370.0);
                    this.setItemRenderTooltip(stack, new String[0]);
                }
                RenderHelper.func_74520_c();
                ClientProxy.MC.func_175599_af().func_175042_a(stack, this.field_147003_i + 40 + i * 22, this.field_147009_r + 219);
                RenderHelper.func_74518_a();
            }
            GlStateManager.func_179094_E();
            GlStateManager.func_179109_b((float)0.0f, (float)0.0f, (float)100.0f);
            for (i = 0; i < 9; ++i) {
                ItemStack stack = ((TileEntityStation)((Object)this.tileEntity)).mainInventory.getStackInSlot(i);
                if (stack.func_190926_b()) continue;
                GUIRenderHelper.drawScaledString(((TileEntityStation)((Object)this.tileEntity)).mainInventory.getStackInSlot(i).func_190916_E() + "", this.field_147003_i + 50 + i * 22, this.field_147009_r + 230, 1.0, 0xFFFFFF);
            }
            GlStateManager.func_179121_F();
        }
    }
}

