/*
 * Decompiled with CFR 0.152.
 */
package com.paneedah.weaponlib.compatibility.sound;

import io.redstudioragnarok.redcore.vectors.Vector3D;
import java.util.function.Supplier;
import net.minecraft.client.audio.MovingSound;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class AdvCompatibleMovingSound
extends MovingSound {
    private Supplier<Vector3D> positionProvider;
    private Supplier<Boolean> donePlayingProvider;
    public boolean shouldFade;
    private int type = -1;
    private int fadeOutTime = 40;
    private int fadeInTime = 40;
    private int fadeTimer = 0;
    private boolean isFadeIn = false;
    private boolean isFade = false;

    public AdvCompatibleMovingSound(SoundEvent sound, Supplier<Vector3D> positionProvider, Supplier<Boolean> donePlayingProvider, boolean fade) {
        super(sound, SoundCategory.BLOCKS);
        this.field_147659_g = true;
        this.field_147662_b = 1.5f;
        this.shouldFade = fade;
        this.positionProvider = positionProvider;
        this.donePlayingProvider = donePlayingProvider;
    }

    public void fadeIn() {
        this.field_147662_b = 0.0f;
        this.fadeTimer = 0;
        this.isFadeIn = true;
        this.isFade = true;
    }

    public void fadeOut() {
        this.fadeTimer = 0;
        this.isFadeIn = false;
        this.isFade = true;
    }

    public void updateFade() {
        if (!this.isFade) {
            return;
        }
        if (this.isFadeIn) {
            ++this.fadeTimer;
            this.field_147662_b = (float)((double)this.fadeTimer / (double)this.fadeInTime) * 1.5f;
            if (this.fadeTimer >= this.fadeInTime) {
                this.isFade = false;
                this.fadeTimer = 0;
                this.isFadeIn = false;
            }
        } else {
            ++this.fadeTimer;
            this.field_147662_b = 1.5f - (float)((double)this.fadeTimer / (double)this.fadeOutTime) * 1.5f;
            if (this.fadeTimer >= this.fadeOutTime) {
                this.field_147668_j = true;
            }
        }
    }

    public boolean func_147657_c() {
        return true;
    }

    public void func_73660_a() {
        if (this.func_147667_k()) {
            return;
        }
        if (this.shouldFade) {
            if (this.type == -1) {
                this.type = 1;
                this.fadeIn();
            }
            this.updateFade();
            if (!this.isFade && this.donePlayingProvider.get().booleanValue()) {
                this.fadeOutTime = 20;
                this.fadeOut();
            }
        }
        if (!this.field_147668_j) {
            Vector3D position = this.positionProvider.get();
            this.field_147660_d = (float)position.x;
            this.field_147661_e = (float)position.y;
            this.field_147658_f = (float)position.z;
        }
    }
}

