/*
 * Decompiled with CFR 0.152.
 */
package com.paneedah.weaponlib.animation.gui;

import com.paneedah.mwc.proxies.ClientProxy;
import com.paneedah.weaponlib.animation.MatrixHelper;
import com.paneedah.weaponlib.animation.gui.AnimationGUI;
import com.paneedah.weaponlib.animation.gui.IElement;
import java.awt.Color;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.TextFormatting;
import org.lwjgl.input.Mouse;

public class Slider
implements IElement {
    private String name;
    private double mapStart;
    private double mapEnd;
    private boolean centered;
    private double progress;
    private double verticalOffset = 0.0;
    private boolean hovered;
    private boolean grabbingSlider;

    public Slider(String name, boolean centered, double start, double end) {
        this.name = name;
        this.mapStart = start;
        this.mapEnd = end;
        this.centered = centered;
        if (centered) {
            this.progress = 0.5;
        }
    }

    @Override
    public void push(double vertical) {
        this.verticalOffset += vertical;
    }

    @Override
    public double getPush() {
        return this.verticalOffset;
    }

    @Override
    public void render(double panelX, double panelY, int mouseX, int mouseY) {
        double offsetX = 5.0 + panelX;
        double offsetY = 20.0 + panelY + this.verticalOffset;
        double width = 80.0;
        double sliderBarOffset = width * this.progress;
        this.hovered = AnimationGUI.getInstance().checkIn2DBox(mouseX, mouseY, offsetX + sliderBarOffset, offsetY - 1.75, 2.5, 5.0);
        if (this.hovered && Mouse.isButtonDown((int)0)) {
            this.grabbingSlider = true;
        }
        if (!Mouse.isButtonDown((int)0)) {
            this.grabbingSlider = false;
        }
        if (this.grabbingSlider) {
            this.progress = ((double)mouseX - offsetX) / width;
            this.progress = MathHelper.func_151237_a((double)this.progress, (double)0.0, (double)1.0);
        }
        AnimationGUI.renderRect(Color.yellow, offsetX, offsetY, width, 1.5);
        if (!this.centered) {
            AnimationGUI.renderRect(Color.green, offsetX, offsetY, width * this.progress, 1.5);
        } else {
            AnimationGUI.renderRect(Color.green, offsetX + width * 0.5, offsetY, width * (this.progress - 0.5), 1.5);
        }
        Color sliderColor = Color.white;
        if (this.hovered) {
            sliderColor = sliderColor.darker();
        }
        AnimationGUI.renderRect(sliderColor, offsetX + sliderBarOffset, offsetY - 1.75, 2.5, 5.0);
        double cleanValue = this.getValue() * Math.pow(10.0, 2.0);
        cleanValue = Math.floor(cleanValue);
        String proText = TextFormatting.GOLD + "" + (cleanValue /= Math.pow(10.0, 2.0));
        GlStateManager.func_179098_w();
        AnimationGUI.renderScaledString(this.name, offsetX, offsetY - 6.0, 0.5);
        AnimationGUI.renderScaledString(proText, offsetX + width - (double)ClientProxy.MC.field_71466_p.func_78256_a(proText) * 0.5, offsetY - 6.0, 0.5);
        GlStateManager.func_179090_x();
    }

    public double getValue() {
        if (this.centered) {
            return MatrixHelper.solveLerp(this.mapStart, this.mapEnd, this.progress - 0.5);
        }
        return MatrixHelper.solveLerp(this.mapStart, this.mapEnd, this.progress);
    }

    public void setProgress(double progress) {
        this.progress = progress;
    }

    public void setValue(double value) {
        this.progress = value / (this.mapEnd - this.mapStart);
    }

    public double getProgress() {
        return this.progress;
    }

    @Override
    public boolean cancelGrab(int mouseX, int mouseY) {
        return this.hovered || this.grabbingSlider;
    }
}

