/*
 * Decompiled with CFR 0.152.
 */
package com.paneedah.weaponlib.animation;

import com.paneedah.mwc.asm.Interceptors;
import com.paneedah.mwc.proxies.ClientProxy;
import com.paneedah.mwc.utils.ModReference;
import com.paneedah.weaponlib.DefaultPart;
import com.paneedah.weaponlib.RenderContext;
import com.paneedah.weaponlib.RenderableState;
import com.paneedah.weaponlib.animation.AnimationModeProcessor;
import com.paneedah.weaponlib.animation.ContinousPositioning2;
import com.paneedah.weaponlib.animation.Interpolation;
import com.paneedah.weaponlib.animation.MatrixHelper;
import com.paneedah.weaponlib.animation.MultipartPositioning;
import com.paneedah.weaponlib.animation.MultipartRenderStateManager;
import com.paneedah.weaponlib.animation.MultipartTransition;
import com.paneedah.weaponlib.animation.MultipartTransitionProvider;
import com.paneedah.weaponlib.animation.PartPositionProvider;
import com.paneedah.weaponlib.animation.Randomizer;
import com.paneedah.weaponlib.animation.StaticPositioning;
import java.nio.FloatBuffer;
import java.util.ArrayList;
import java.util.Deque;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.WeakHashMap;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.client.audio.ISound;
import net.minecraft.client.audio.PositionedSoundRecord;
import net.minecraft.client.renderer.GLAllocation;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.Vec3d;
import org.lwjgl.BufferUtils;
import org.lwjgl.opengl.GL11;
import org.lwjgl.util.vector.Matrix4f;
import org.lwjgl.util.vector.Quaternion;
import org.lwjgl.util.vector.Vector3f;

public class MultipartRenderStateManager<State, Part, Context extends PartPositionProvider> {
    Randomizer randomizer;
    private Supplier<Long> currentTimeProvider;
    private Function<Context, Float> currentProgressProvider;
    WeakHashMap<Part, Matrix4f> lastApplied = new WeakHashMap();
    private String name;
    private StateContainer<State> currentStateContainer;
    MultipartTransitionProvider<State, Part, Context> transitionProvider;
    private Deque<MultipartPositioning<Part, Context>> positioningQueue;

    public MultipartRenderStateManager(State initialState, MultipartTransitionProvider<State, Part, Context> transitionProvider) {
        this(initialState, transitionProvider, System::currentTimeMillis);
    }

    public MultipartRenderStateManager(State initialState, MultipartTransitionProvider<State, Part, Context> transitionProvider, Supplier<Long> currentTimeProvider) {
        this("anonymous", initialState, transitionProvider, currentTimeProvider, null);
    }

    public MultipartRenderStateManager(String name, State initialState, MultipartTransitionProvider<State, Part, Context> transitionProvider, Supplier<Long> currentTimeProvider, Function<Context, Float> currentProgressProvider) {
        this.name = name;
        this.transitionProvider = transitionProvider;
        this.positioningQueue = new LinkedList<MultipartPositioning<Part, Context>>();
        this.randomizer = new Randomizer();
        this.currentTimeProvider = currentTimeProvider;
        this.currentProgressProvider = currentProgressProvider;
        this.setState(initialState, false, true);
    }

    public void setCycleState(State cycleState, boolean immediate) {
        if (cycleState == null) {
            throw new IllegalArgumentException("State cannot be null");
        }
        if (immediate) {
            this.positioningQueue.clear();
        }
        if (this.positioningQueue.size() <= 1) {
            StateContainer<State> addedState;
            if (cycleState.equals(this.currentStateContainer.state) && !this.currentStateContainer.isEndOfLoop) {
                addedState = new StateContainer<State>(cycleState, true);
            } else {
                addedState = new StateContainer<State>(cycleState, false);
                this.positioningQueue.add(new TransitionedPositioning(this.currentStateContainer.state, addedState.state, false));
                this.positioningQueue.add(new StaticPositioning<State, Part, Context>(this.transitionProvider, this.randomizer, addedState.state, this.lastApplied));
            }
            this.currentStateContainer = addedState;
        }
    }

    public void setState(State newState, boolean animated, boolean immediate) {
        this.setState(newState, animated, immediate, false);
    }

    public void setState(State newState, boolean animated, boolean immediate, boolean fromAnchored) {
        if (newState == null) {
            throw new IllegalArgumentException("State cannot be null");
        }
        if (this.currentStateContainer != null && newState.equals(this.currentStateContainer.state)) {
            return;
        }
        if (immediate) {
            this.positioningQueue.clear();
        }
        if (animated) {
            this.positioningQueue.add(new TransitionedPositioning(this.currentStateContainer != null ? (Object)this.currentStateContainer.state : null, newState, fromAnchored));
        }
        this.positioningQueue.add(new StaticPositioning<State, Part, Context>(this.transitionProvider, this.randomizer, newState, this.lastApplied));
        this.currentStateContainer = new StateContainer<State>(newState);
    }

    public void setContinousState(State newState, boolean animated, boolean immediate, boolean fromAnchored) {
        if (newState == null) {
            throw new IllegalArgumentException("State cannot be null");
        }
        if (this.currentStateContainer != null && newState.equals(this.currentStateContainer.state)) {
            return;
        }
        if (immediate) {
            this.positioningQueue.clear();
        }
        if (animated) {
            this.positioningQueue.add(new ContinousPositioning2<Object, Part, Context>(this.transitionProvider, this.currentProgressProvider, this.randomizer, (this.currentStateContainer != null ? (Object)this.currentStateContainer.state : null), newState, fromAnchored, this.lastApplied));
        }
        this.positioningQueue.add(new StaticPositioning<State, Part, Context>(this.transitionProvider, this.randomizer, newState, this.lastApplied));
        this.currentStateContainer = new StateContainer<State>(newState);
    }

    public State getLastState() {
        return this.currentStateContainer != null ? (State)this.currentStateContainer.state : null;
    }

    public MultipartPositioning<Part, Context> nextPositioning() {
        MultipartPositioning<Part, Context> result = null;
        while (!this.positioningQueue.isEmpty()) {
            MultipartPositioning<Part, Context> p = this.positioningQueue.poll();
            if (p.isExpired(this.positioningQueue)) continue;
            this.positioningQueue.addFirst(p);
            result = p;
            break;
        }
        if (result == null) {
            throw new IllegalStateException("Position cannot be null");
        }
        return result;
    }

    private static class StateContainer<State> {
        State state;
        boolean isEndOfLoop;

        StateContainer(State state, boolean isEndOfLoop) {
            this.state = state;
            this.isEndOfLoop = isEndOfLoop;
        }

        StateContainer(State state) {
            this(state, false);
        }
    }

    private class TransitionedPositioning
    implements MultipartPositioning<Part, Context> {
        private Map<Part, com.paneedah.weaponlib.animation.MultipartRenderStateManager$TransitionedPositioning.PartData> partDataMap = new HashMap();
        private Long startTime;
        private long totalDuration;
        private int previousIndex = -1;
        private int currentIndex;
        private long currentStartTime;
        private boolean expired;
        private int segmentCount;
        private List<MultipartTransition<Part, Context>> fromPositioning;
        private List<MultipartTransition<Part, Context>> toPositioning;
        private State fromState;
        private State toState;
        private boolean fromAnchored;

        TransitionedPositioning(State fromState, State toState, boolean fromAnchored) {
            this.fromState = fromState;
            this.toState = toState;
            this.fromAnchored = fromAnchored;
            this.fromPositioning = MultipartRenderStateManager.this.transitionProvider.getTransitions(fromState);
            this.toPositioning = MultipartRenderStateManager.this.transitionProvider.getTransitions(toState);
            this.segmentCount = this.toPositioning.size();
            for (MultipartTransition t : this.toPositioning) {
                this.totalDuration += t.getDuration() + t.getPause();
            }
        }

        @Override
        public float getProgress() {
            return this.startTime != null ? (float)((Long)MultipartRenderStateManager.this.currentTimeProvider.get() - this.startTime) / (float)this.totalDuration : 0.0f;
        }

        @Override
        public boolean isExpired(Queue<MultipartPositioning<Part, Context>> positioningQueue) {
            return this.expired;
        }

        @Override
        public <T> T getFromState(Class<T> stateClass) {
            return stateClass.cast(this.fromState);
        }

        @Override
        public <T> T getToState(Class<T> stateClass) {
            return stateClass.cast(this.toState);
        }

        private Matrix4f adjustToAttached(Matrix4f matrix, Part fromAttached, Part toAttached, Context context) {
            if (fromAttached == toAttached) {
                return matrix;
            }
            Matrix4f fromMatrix = context.getPartPosition(fromAttached);
            if (fromMatrix == null) {
                return matrix;
            }
            Matrix4f toMatrix = context.getPartPosition(toAttached);
            if (toMatrix == null) {
                return matrix;
            }
            Matrix4f invertedToMatrix = Matrix4f.invert((Matrix4f)toMatrix, null);
            if (invertedToMatrix == null) {
                return matrix;
            }
            Matrix4f correctionMatrix = Matrix4f.mul((Matrix4f)invertedToMatrix, (Matrix4f)fromMatrix, null);
            return Matrix4f.mul((Matrix4f)correctionMatrix, (Matrix4f)matrix, null);
        }

        private com.paneedah.weaponlib.animation.MultipartRenderStateManager$TransitionedPositioning.PartData getPartData(Part part, Context context) {
            try {
                return this.partDataMap.computeIfAbsent(part, p -> {
                    PartData pd = new PartData();
                    Matrix4f fromMatrix = null;
                    if (this.fromAnchored) {
                        fromMatrix = MultipartRenderStateManager.this.lastApplied.get(p);
                    }
                    if (fromMatrix == null && this.fromPositioning != null) {
                        MultipartTransition fromMultipart = this.fromPositioning.get(this.fromPositioning.size() - 1);
                        if (fromMultipart.getPositioning(part) == MultipartTransition.anchoredPosition()) {
                            fromMatrix = MultipartRenderStateManager.this.lastApplied.get(p);
                            if (fromMatrix == null) {
                                fromMatrix = new Matrix4f();
                                fromMatrix.setIdentity();
                            }
                        } else {
                            ModReference.LOG.trace("Getting part data for {}", part);
                            fromMatrix = this.getMatrixForPositioning(fromMultipart, p, context);
                        }
                        fromMatrix = this.adjustToAttached(fromMatrix, fromMultipart.getAttachedTo(p), this.toPositioning.get(0).getAttachedTo(p), context);
                    }
                    if (fromMatrix == null) {
                        fromMatrix = new Matrix4f();
                        fromMatrix.setIdentity();
                    }
                    pd.matrices.add(fromMatrix);
                    pd.attachedTo = this.toPositioning.get(0).getAttachedTo(p);
                    Matrix4f previous = fromMatrix;
                    for (MultipartTransition multipartTransition : this.toPositioning) {
                        Matrix4f current = multipartTransition.getPositioning(part) == MultipartTransition.anchoredPosition() ? previous : this.getMatrixForPositioning(multipartTransition, p, context);
                        pd.matrices.add(current);
                        previous = current;
                    }
                    return pd;
                });
            }
            catch (Exception e) {
                System.err.println("Failed to get data for part " + part + " for transition from [" + this.fromState + "] to [" + this.toState + "]");
                throw e;
            }
        }

        @Override
        public MultipartPositioning.Positioner<Part, Context> getPositioner() {
            long currentTime = (Long)MultipartRenderStateManager.this.currentTimeProvider.get();
            final MultipartTransition targetState = this.toPositioning.get(this.currentIndex);
            if (this.previousIndex != this.currentIndex && targetState.sound != null) {
                PositionedSoundRecord psr = new PositionedSoundRecord(targetState.sound, SoundCategory.PLAYERS, 1.0f, 1.0f, ClientProxy.MC.field_71439_g.func_180425_c().func_177981_b(5));
                ClientProxy.MC.func_147118_V().func_147682_a((ISound)psr);
            }
            this.previousIndex = this.currentIndex;
            long currentDuration = targetState.getDuration();
            long currentPause = targetState.getPause();
            if (this.currentIndex == 0 && this.startTime == null) {
                ModReference.LOG.debug("Starting transition {}, duration {}ms, pause {}ms", (Object)this.currentIndex, (Object)currentDuration, (Object)currentPause);
                this.startTime = currentTime;
            }
            if (currentTime - this.currentStartTime < 10L) {
                // empty if block
            }
            if (this.currentStartTime == 0L) {
                this.currentStartTime = currentTime;
            } else if (currentTime > this.currentStartTime + currentDuration + currentPause) {
                ModReference.LOG.debug("Completed transition {}, duration {}ms, pause {}ms", (Object)this.currentIndex, (Object)currentDuration, (Object)currentPause);
                ++this.currentIndex;
                if (ModReference.LOG.isDebugEnabled() && this.currentIndex < this.toPositioning.size()) {
                    MultipartTransition multipartTransition = this.toPositioning.get(this.currentIndex);
                    ModReference.LOG.debug("Starting transition {}, duration {}ms, pause {}ms", (Object)this.currentIndex, (Object)multipartTransition.getDuration(), (Object)multipartTransition.getPause());
                }
                this.currentStartTime = currentTime;
            }
            long currentOffset = currentTime - this.currentStartTime;
            float currentProgress = (float)currentOffset / (float)currentDuration;
            if (currentProgress > 1.0f) {
                currentProgress = 1.0f;
            }
            final float finalCurrentProgress = currentProgress;
            final Interpolation interpolation = targetState.getInterpolationType();
            if (this.currentIndex >= this.segmentCount) {
                this.expired = true;
                return new MultipartPositioning.Positioner<Part, Context>(){

                    @Override
                    public void position(Part part, Context context) {
                        boolean revertFlag;
                        PartData partData = TransitionedPositioning.this.getPartData(part, context);
                        boolean bl = revertFlag = TransitionedPositioning.this.toState == RenderableState.NORMAL && TransitionedPositioning.this.fromState == RenderableState.ZOOMING;
                        if (ClientProxy.MC.field_71474_y.field_74320_O == 0 && part.toString().contains("MAIN_ITEM") && (TransitionedPositioning.this.toState == RenderableState.ZOOMING && TransitionedPositioning.this.fromState == RenderableState.NORMAL || TransitionedPositioning.this.toState == RenderableState.NORMAL && TransitionedPositioning.this.fromState == RenderableState.ZOOMING)) {
                            Vec3d beizer = Vec3d.field_186680_a;
                            if (targetState != null && targetState.beizer != null) {
                                beizer = revertFlag ? targetState.beizer.func_186678_a(1.25) : targetState.beizer;
                            }
                            TransitionedPositioning.this.applyOnceNewBeizer(part, context, partData.matrices.get(TransitionedPositioning.this.currentIndex - 1), partData.matrices.get(TransitionedPositioning.this.currentIndex), partData.attachedTo, 1.0f, beizer, revertFlag, interpolation);
                        } else {
                            TransitionedPositioning.this.applyOnce2(part, context, partData.matrices.get(TransitionedPositioning.this.currentIndex - 1), partData.matrices.get(TransitionedPositioning.this.currentIndex), partData.attachedTo, 1.0f, interpolation);
                        }
                    }

                    @Override
                    public void randomize(float rate, float amplitude) {
                        MultipartRenderStateManager.this.randomizer.update(0.0f, 0.0f);
                    }
                };
            }
            return new MultipartPositioning.Positioner<Part, Context>(){

                @Override
                public void position(Part part, Context context) {
                    boolean cancelBeizer;
                    PartData partData = TransitionedPositioning.this.getPartData(part, context);
                    if (part == DefaultPart.MAIN_ITEM) {
                        Interceptors.nc.addToMatrixStack(partData.matrices.get(TransitionedPositioning.this.currentIndex + 1));
                    }
                    boolean revertFlag = TransitionedPositioning.this.toState == RenderableState.NORMAL && TransitionedPositioning.this.fromState == RenderableState.ZOOMING;
                    boolean bl = cancelBeizer = context instanceof RenderContext && ((RenderContext)context).getCancelBeizer();
                    if (!cancelBeizer && ClientProxy.MC.field_71474_y.field_74320_O == 0 && part.toString().contains("MAIN_ITEM") && (TransitionedPositioning.this.toState == RenderableState.ZOOMING && TransitionedPositioning.this.fromState == RenderableState.NORMAL || TransitionedPositioning.this.toState == RenderableState.NORMAL && TransitionedPositioning.this.fromState == RenderableState.ZOOMING)) {
                        Vec3d beizer = Vec3d.field_186680_a;
                        if (targetState != null && targetState.beizer != null) {
                            beizer = revertFlag ? targetState.beizer.func_186678_a(1.25) : targetState.beizer;
                        }
                        TransitionedPositioning.this.applyOnceNewBeizer(part, context, partData.matrices.get(TransitionedPositioning.this.currentIndex), partData.matrices.get(TransitionedPositioning.this.currentIndex + 1), partData.attachedTo, finalCurrentProgress, beizer, revertFlag, interpolation);
                    } else {
                        TransitionedPositioning.this.applyOnce2(part, context, partData.matrices.get(TransitionedPositioning.this.currentIndex), partData.matrices.get(TransitionedPositioning.this.currentIndex + 1), partData.attachedTo, finalCurrentProgress, interpolation);
                    }
                }

                @Override
                public void randomize(float rate, float amplitude) {
                    MultipartRenderStateManager.this.randomizer.update(0.0f, 0.0f);
                }
            };
        }

        private void applyOnce(Part part, Context context, Matrix4f beforeMatrix, Matrix4f afterMatrix, Part attachedTo, float progress, Interpolation interp) {
            ModReference.LOG.trace("Applying position for part {}", part);
            Matrix4f currentMatrix = null;
            if (attachedTo != null) {
                currentMatrix = context.getPartPosition(attachedTo);
            }
            if (currentMatrix == null) {
                currentMatrix = MatrixHelper.captureMatrix();
            }
            Matrix4f m1 = MatrixHelper.interpolateMatrix(beforeMatrix, 1.0f - progress, interp);
            Matrix4f m2 = MatrixHelper.interpolateMatrix(afterMatrix, progress, interp);
            Matrix4f deltaMatrix = Matrix4f.add((Matrix4f)m1, (Matrix4f)m2, null);
            MultipartRenderStateManager.this.lastApplied.put(part, deltaMatrix);
            Matrix4f composite = Matrix4f.mul((Matrix4f)currentMatrix, (Matrix4f)deltaMatrix, null);
            MatrixHelper.loadMatrix(composite);
        }

        private void applyOnceCom(Part part, Context context, Matrix4f beforeMatrix, Matrix4f afterMatrix, Part attachedTo, float progress, Vec3d beizer, boolean accel, Interpolation interp) {
            ModReference.LOG.trace("Applying position for part {}", part);
            Matrix4f currentMatrix = null;
            if (attachedTo != null) {
                currentMatrix = context.getPartPosition(attachedTo);
            }
            if (currentMatrix == null) {
                currentMatrix = MatrixHelper.captureMatrix();
            }
            FloatBuffer auxGLMatrix = GLAllocation.func_74529_h((int)16);
            auxGLMatrix.rewind();
            Vec3d beezer = new Vec3d(0.0, 3.5, -1.0);
            float fastProgress = 0.0f;
            fastProgress = !accel ? 1.0f - (1.0f - progress) * (1.0f - progress) : 1.0f - (1.0f - progress) * (1.0f - progress);
            float newX = MatrixHelper.solveBeizer(beforeMatrix.m30, (float)beizer.field_72450_a, afterMatrix.m30, fastProgress);
            float newY = MatrixHelper.solveBeizer(beforeMatrix.m31, (float)beizer.field_72448_b, afterMatrix.m31, fastProgress);
            float newZ = MatrixHelper.solveBeizer(beforeMatrix.m32, (float)beizer.field_72449_c, afterMatrix.m32, fastProgress);
            Vec3d trans = new Vec3d((double)newX, (double)newY, (double)newZ);
            Vec3d scaleBefore = MatrixHelper.extractScale(beforeMatrix);
            Vec3d scaleAfter = MatrixHelper.extractScale(afterMatrix);
            Quaternion q = new Quaternion();
            Quaternion.setFromMatrix((Matrix4f)beforeMatrix, (Quaternion)q);
            Quaternion q2 = new Quaternion();
            Quaternion.setFromMatrix((Matrix4f)afterMatrix, (Quaternion)q2);
            MatrixHelper.restoreScale(beforeMatrix, scaleBefore);
            MatrixHelper.restoreScale(afterMatrix, scaleAfter);
            GlStateManager.func_187418_a((FloatBuffer)auxGLMatrix, (Quaternion)MatrixHelper.slerp(q, q2, progress));
            MatrixHelper.scaleFloatBuffer(auxGLMatrix, MatrixHelper.lerpVectors(scaleBefore, scaleAfter, progress));
            auxGLMatrix.put(12, (float)trans.field_72450_a);
            auxGLMatrix.put(13, (float)trans.field_72448_b);
            auxGLMatrix.put(14, (float)trans.field_72449_c);
            Matrix4f deltaMatrix = new Matrix4f();
            deltaMatrix.load(auxGLMatrix);
            deltaMatrix = deltaMatrix.rotate((float)Math.toRadians(90.0), new Vector3f(0.0f, 1.0f, 0.0f));
            Matrix4f m1 = MatrixHelper.interpolateMatrix(beforeMatrix, 1.0f - progress, interp);
            Matrix4f m2 = MatrixHelper.interpolateMatrix(afterMatrix, progress, interp);
            deltaMatrix = Matrix4f.add((Matrix4f)m1, (Matrix4f)m2, null);
            deltaMatrix.m30 = (float)trans.field_72450_a;
            deltaMatrix.m31 = (float)trans.field_72448_b;
            deltaMatrix.m32 = (float)trans.field_72449_c;
            MultipartRenderStateManager.this.lastApplied.put(part, deltaMatrix);
            Matrix4f composite = Matrix4f.mul((Matrix4f)currentMatrix, (Matrix4f)deltaMatrix, null);
            MatrixHelper.loadMatrix(composite);
        }

        private void applyOnceNewBeizer(Part part, Context context, Matrix4f beforeMatrix, Matrix4f afterMatrix, Part attachedTo, float progress, Vec3d beizer, boolean accel, Interpolation interp) {
            ModReference.LOG.trace("Applying position for part {}", part);
            progress = (float)interp.interpolate(progress);
            Matrix4f currentMatrix = null;
            if (attachedTo != null) {
                currentMatrix = context.getPartPosition(attachedTo);
            }
            if (currentMatrix == null) {
                currentMatrix = MatrixHelper.captureMatrix();
            }
            Matrix4f copiedBefore = new Matrix4f(beforeMatrix);
            Matrix4f copiedAfter = new Matrix4f(afterMatrix);
            FloatBuffer AUXGLBRUHFER = BufferUtils.createFloatBuffer((int)16);
            float newX = MatrixHelper.solveBeizer(copiedBefore.m30, (float)beizer.field_72450_a, copiedAfter.m30, progress);
            float newY = MatrixHelper.solveBeizer(copiedBefore.m31, (float)beizer.field_72448_b, copiedAfter.m31, progress);
            float newZ = MatrixHelper.solveBeizer(copiedBefore.m32, (float)beizer.field_72449_c, copiedAfter.m32, progress);
            Vec3d iT = new Vec3d((double)newX, (double)newY, (double)newZ);
            Quaternion q4 = new Quaternion();
            Quaternion q5 = new Quaternion();
            Matrix4f matty = new Matrix4f();
            Vec3d scaleBefore = MatrixHelper.extractScale(copiedBefore);
            Vec3d scaleAfter = MatrixHelper.extractScale(copiedAfter);
            Vec3d iS = MatrixHelper.lerpVectors(scaleBefore, scaleAfter, progress);
            Quaternion.setFromMatrix((Matrix4f)copiedBefore, (Quaternion)q4);
            Quaternion.setFromMatrix((Matrix4f)copiedAfter, (Quaternion)q5);
            Quaternion q6 = MatrixHelper.slerp(q4, q5, progress);
            GlStateManager.func_187418_a((FloatBuffer)AUXGLBRUHFER, (Quaternion)q6);
            AUXGLBRUHFER.rewind();
            matty.load(AUXGLBRUHFER);
            AUXGLBRUHFER.rewind();
            matty.scale(new Vector3f((float)iS.field_72450_a, (float)iS.field_72448_b, (float)iS.field_72449_c));
            matty.transpose();
            matty.m30 = (float)iT.field_72450_a;
            matty.m31 = (float)iT.field_72448_b;
            matty.m32 = (float)iT.field_72449_c;
            MultipartRenderStateManager.this.lastApplied.put(part, matty);
            Matrix4f composite = Matrix4f.mul((Matrix4f)currentMatrix, (Matrix4f)matty, null);
            MatrixHelper.loadMatrix(composite);
        }

        private void applyOnce2(Part part, Context context, Matrix4f beforeMatrix, Matrix4f afterMatrix, Part attachedTo, float progress, Interpolation interp) {
            ModReference.LOG.trace("Applying position for part {}", part);
            Matrix4f currentMatrix = null;
            if (attachedTo != null) {
                currentMatrix = context.getPartPosition(attachedTo);
            }
            if (currentMatrix == null) {
                currentMatrix = MatrixHelper.captureMatrix();
            }
            Matrix4f copiedBefore = new Matrix4f(beforeMatrix);
            Matrix4f copiedAfter = new Matrix4f(afterMatrix);
            FloatBuffer AUXGLBRUHFER = BufferUtils.createFloatBuffer((int)16);
            Vec3d beforeTranslation = new Vec3d((double)copiedBefore.m30, (double)copiedBefore.m31, (double)copiedBefore.m32);
            Vec3d afterTranslation = new Vec3d((double)copiedAfter.m30, (double)copiedAfter.m31, (double)copiedAfter.m32);
            Vec3d iT = MatrixHelper.lerpVectors(beforeTranslation, afterTranslation, progress);
            Quaternion q4 = new Quaternion();
            Quaternion q5 = new Quaternion();
            Matrix4f matty = new Matrix4f();
            Vec3d scaleBefore = null;
            scaleBefore = AnimationModeProcessor.getInstance().isLegacyMode() ? MatrixHelper.extractScaleOld(copiedBefore) : MatrixHelper.extractScale(copiedBefore);
            Vec3d scaleAfter = null;
            scaleAfter = AnimationModeProcessor.getInstance().isLegacyMode() ? MatrixHelper.extractScaleOld(copiedAfter) : MatrixHelper.extractScale(copiedAfter);
            Vec3d iS = MatrixHelper.lerpVectors(scaleBefore, scaleAfter, progress);
            Quaternion.setFromMatrix((Matrix4f)copiedBefore, (Quaternion)q4);
            Quaternion.setFromMatrix((Matrix4f)copiedAfter, (Quaternion)q5);
            Quaternion q6 = MatrixHelper.slerp(q4, q5, progress);
            GlStateManager.func_187418_a((FloatBuffer)AUXGLBRUHFER, (Quaternion)q6);
            AUXGLBRUHFER.rewind();
            matty.load(AUXGLBRUHFER);
            AUXGLBRUHFER.rewind();
            if (AnimationModeProcessor.getInstance().isLegacyMode()) {
                matty.scale(new Vector3f((float)iS.field_72450_a, (float)iS.field_72448_b, (float)iS.field_72449_c));
                matty.transpose();
            } else {
                matty.transpose();
                matty.scale(new Vector3f((float)iS.field_72450_a, (float)iS.field_72448_b, (float)iS.field_72449_c));
            }
            matty.m30 = (float)iT.field_72450_a;
            matty.m31 = (float)iT.field_72448_b;
            matty.m32 = (float)iT.field_72449_c;
            MultipartRenderStateManager.this.lastApplied.put(part, matty);
            Matrix4f composite = Matrix4f.mul((Matrix4f)currentMatrix, (Matrix4f)matty, null);
            MatrixHelper.loadMatrix(composite);
        }

        private Matrix4f getMatrixForPositioning(MultipartTransition<Part, Context> transition, Part part, Context context) {
            GL11.glPushMatrix();
            GL11.glMatrixMode((int)5888);
            GL11.glLoadIdentity();
            FloatBuffer buf = BufferUtils.createFloatBuffer((int)16);
            transition.position(part, context);
            GL11.glGetFloat((int)2982, (FloatBuffer)buf);
            buf.rewind();
            Matrix4f matrix = new Matrix4f();
            matrix.load(buf);
            GL11.glPopMatrix();
            return matrix;
        }

        private class PartData {
            List<Matrix4f> matrices = new ArrayList<Matrix4f>();
            Part attachedTo;

            private PartData() {
            }
        }
    }
}

