/*
 * Decompiled with CFR 0.152.
 */
package com.paneedah.weaponlib.animation;

import com.paneedah.weaponlib.animation.MultipartPositioning;
import com.paneedah.weaponlib.animation.MultipartTransition;
import com.paneedah.weaponlib.animation.MultipartTransitionProvider;
import com.paneedah.weaponlib.animation.PartPositionProvider;
import com.paneedah.weaponlib.animation.Randomizer;
import com.paneedah.weaponlib.animation.StaticPositioning;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.function.Consumer;
import java.util.function.Function;
import org.lwjgl.util.vector.Matrix4f;

class ContinousPositioning2<State, Part, Context extends PartPositionProvider>
implements MultipartPositioning<Part, Context> {
    private Function<Context, Float> currentProgressProvider;
    private Randomizer randomizer;
    private long totalDuration;
    private List<MultipartTransition<Part, Context>> toPositioning;
    private State fromState;
    private State toState;
    private boolean fromAnchored;

    ContinousPositioning2(MultipartTransitionProvider<State, Part, Context> transitionProvider, Function<Context, Float> currentProgressProvider, Randomizer randomizer, State fromState, State toState, boolean fromAnchored, Map<Part, Matrix4f> lastApplied) {
        this.currentProgressProvider = currentProgressProvider;
        this.randomizer = randomizer;
        this.fromState = fromState;
        this.toState = toState;
        this.fromAnchored = fromAnchored;
        this.toPositioning = transitionProvider.getTransitions(toState);
        for (MultipartTransition<Part, Context> t : this.toPositioning) {
            this.totalDuration += t.getDuration() + t.getPause();
        }
    }

    @Override
    public float getProgress() {
        return 0.0f;
    }

    @Override
    public boolean isExpired(Queue<MultipartPositioning<Part, Context>> positioningQueue) {
        return positioningQueue.stream().anyMatch(p -> !(p instanceof StaticPositioning));
    }

    @Override
    public <T> T getFromState(Class<T> stateClass) {
        return stateClass.cast(this.fromState);
    }

    @Override
    public <T> T getToState(Class<T> stateClass) {
        return stateClass.cast(this.toState);
    }

    @Override
    public MultipartPositioning.Positioner<Part, Context> getPositioner() {
        return new PositionerImpl();
    }

    private class PartData {
        List<Matrix4f> matrices = new ArrayList<Matrix4f>();
        Part attachedTo;

        private PartData() {
        }
    }

    private final class PositionerImpl
    implements MultipartPositioning.Positioner<Part, Context> {
        private PositionerImpl() {
        }

        @Override
        public void position(Part part, Context context) {
            float currentProgress = context.getProgress();
            if (currentProgress > 1.0f) {
                currentProgress = 1.0f;
            } else if (currentProgress < 0.0f) {
                currentProgress = 0.0f;
            }
            float mark = (float)ContinousPositioning2.this.totalDuration * currentProgress;
            long endOfSegment = 0L;
            long startOfSegment = 0L;
            int segmentIndex = -1;
            MultipartTransition targetTransition = null;
            for (int i = 0; i < ContinousPositioning2.this.toPositioning.size(); ++i) {
                MultipartTransition transition = (MultipartTransition)ContinousPositioning2.this.toPositioning.get(i);
                if (mark <= (float)(endOfSegment += transition.getDuration() + transition.getPause())) {
                    segmentIndex = i;
                    targetTransition = transition;
                    break;
                }
                startOfSegment = endOfSegment;
            }
            if (targetTransition == null) {
                System.err.println("Cannot determine target transition");
                return;
            }
            float activePartOfSegmentProgress = (mark - (float)startOfSegment) / (float)targetTransition.getDuration();
            if (activePartOfSegmentProgress > 1.0f) {
                activePartOfSegmentProgress = 1.0f;
            }
            Consumer positioning = targetTransition.getPositioning(part);
            positioning.accept(context);
        }

        @Override
        public void randomize(float rate, float amplitude) {
            ContinousPositioning2.this.randomizer.update(0.0f, 0.0f);
        }
    }
}

