/*
 * Decompiled with CFR 0.152.
 */
package com.paneedah.weaponlib;

import com.paneedah.mwc.network.TypeRegistry;
import com.paneedah.weaponlib.PlayerItemInstance;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.util.UUID;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;

public final class Tags {
    private static final String AMMO_TAG = "Ammo";
    private static final String DEFAULT_TIMER_TAG = "DefaultTimer";
    private static final String INSTANCE_TAG = "Instance";
    private static final String ATTACHMENT_ID_TAG = "AtId";
    private static final String INSTANCE_UUID_TAG = "IUuid";

    public static int getAmmo(ItemStack itemStack) {
        if (itemStack == null || itemStack.func_77978_p() == null) {
            return 0;
        }
        return itemStack.func_77978_p().func_74762_e(AMMO_TAG);
    }

    public static void setAmmo(ItemStack itemStack, int ammo) {
        if (itemStack == null) {
            return;
        }
        if (itemStack.func_77978_p() == null) {
            itemStack.func_77982_d(new NBTTagCompound());
        }
        itemStack.func_77978_p().func_74768_a(AMMO_TAG, ammo);
    }

    public static int[] getAttachmentIds(ItemStack itemStack) {
        if (itemStack == null || itemStack.func_77978_p() == null) {
            return new int[0];
        }
        return itemStack.func_77978_p().func_74759_k(ATTACHMENT_ID_TAG);
    }

    public static void setAttachmentIds(ItemStack itemStack, int[] attachmentIds) {
        if (itemStack == null) {
            return;
        }
        if (itemStack.func_77978_p() == null) {
            itemStack.func_77982_d(new NBTTagCompound());
        }
        itemStack.func_77978_p().func_74783_a(ATTACHMENT_ID_TAG, attachmentIds);
    }

    public static long getDefaultTimer(ItemStack itemStack) {
        if (itemStack == null || itemStack.func_77978_p() == null) {
            return 0L;
        }
        return itemStack.func_77978_p().func_74763_f(DEFAULT_TIMER_TAG);
    }

    public static void setDefaultTimer(ItemStack itemStack, long ammo) {
        if (itemStack == null || itemStack.func_77978_p() == null) {
            return;
        }
        itemStack.func_77978_p().func_74772_a(DEFAULT_TIMER_TAG, ammo);
    }

    public static PlayerItemInstance<?> getInstance(ItemStack itemStack) {
        if (itemStack == null || itemStack.func_77978_p() == null) {
            return null;
        }
        byte[] bytes = itemStack.func_77978_p().func_74770_j(INSTANCE_TAG);
        if (bytes != null && bytes.length > 0) {
            return (PlayerItemInstance)TypeRegistry.getINSTANCE().fromBytes(Unpooled.wrappedBuffer((byte[])bytes));
        }
        return null;
    }

    public static <T extends PlayerItemInstance<?>> T getInstance(ItemStack itemStack, Class<T> targetClass) {
        if (itemStack == null || itemStack.func_77978_p() == null) {
            return null;
        }
        byte[] bytes = itemStack.func_77978_p().func_74770_j(INSTANCE_TAG);
        if (bytes != null && bytes.length > 0) {
            try {
                return (T)((PlayerItemInstance)targetClass.cast(TypeRegistry.getINSTANCE().fromBytes(Unpooled.wrappedBuffer((byte[])bytes))));
            }
            catch (RuntimeException e) {
                return null;
            }
        }
        return null;
    }

    public static void setInstance(ItemStack itemStack, PlayerItemInstance<?> instance) {
        if (itemStack == null) {
            return;
        }
        if (itemStack.func_77978_p() == null) {
            itemStack.func_77982_d(new NBTTagCompound());
        }
        ByteBuf buf = Unpooled.buffer();
        if (instance != null) {
            TypeRegistry.getINSTANCE().toBytes(instance, buf);
            NBTTagCompound tagCompound = itemStack.func_77978_p();
            tagCompound.func_74773_a(INSTANCE_TAG, buf.array());
            UUID uuid = instance.getUuid();
            tagCompound.func_74772_a("IUuidMost", uuid.getMostSignificantBits());
            tagCompound.func_74772_a("IUuidLeast", uuid.getLeastSignificantBits());
        } else {
            NBTTagCompound tagCompound = itemStack.func_77978_p();
            tagCompound.func_82580_o(INSTANCE_TAG);
            tagCompound.func_82580_o(INSTANCE_UUID_TAG);
        }
    }

    public static UUID getInstanceUuid(ItemStack itemStack) {
        if (itemStack == null) {
            return null;
        }
        NBTTagCompound tagCompound = itemStack.func_77978_p();
        if (tagCompound == null) {
            return null;
        }
        UUID uuid = new UUID(tagCompound.func_74763_f("IUuidMost"), tagCompound.func_74763_f("IUuidLeast"));
        if (uuid.getMostSignificantBits() == 0L && uuid.getLeastSignificantBits() == 0L) {
            return null;
        }
        return uuid;
    }

    public static void setInstanceUuid(ItemStack itemStack, UUID uuid) {
        if (itemStack == null) {
            return;
        }
        if (itemStack.func_77978_p() == null) {
            itemStack.func_77982_d(new NBTTagCompound());
        }
        NBTTagCompound tagCompound = itemStack.func_77978_p();
        tagCompound.func_74772_a("IUuidMost", uuid.getMostSignificantBits());
        tagCompound.func_74772_a("IUuidLeast", uuid.getLeastSignificantBits());
    }

    public static byte[] getInstanceBytes(ItemStack itemStack) {
        if (itemStack == null || itemStack.func_77978_p() == null) {
            return null;
        }
        return itemStack.func_77978_p().func_74770_j(INSTANCE_TAG);
    }
}

