/*
 * Decompiled with CFR 0.152.
 */
package com.paneedah.weaponlib;

import com.paneedah.mwc.network.NetworkPermitManager;
import com.paneedah.mwc.utils.ModReference;
import com.paneedah.weaponlib.PlayerItemInstance;
import com.paneedah.weaponlib.Tags;
import com.paneedah.weaponlib.state.ManagedState;
import com.paneedah.weaponlib.state.Permit;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import net.minecraft.item.ItemStack;

public class SyncManager<S extends ManagedState<S>> {
    private final NetworkPermitManager permitManager;
    private final Map<PlayerItemInstance<?>, Long> watchables = new LinkedHashMap();
    private final long syncTimeout = 10000L;

    public SyncManager(NetworkPermitManager permitManager) {
        this.permitManager = permitManager;
        this.permitManager.registerEvaluator(Permit.class, PlayerItemInstance.class, this::syncOnServer);
    }

    private void syncOnServer(Permit<S> permit, PlayerItemInstance<S> instance) {
        ModReference.LOG.debug("Syncing {} in state {} on server", instance, instance.getState());
        ItemStack itemStack = instance.getItemStack();
        if (itemStack != null) {
            if (instance.getItem() == itemStack.func_77973_b()) {
                ModReference.LOG.debug("Stored instance {} of {} in stack {}", instance, (Object)instance.getItem(), (Object)itemStack);
                instance.reconcile();
                if (instance.shouldHaveInstanceTags()) {
                    Tags.setInstance(itemStack, instance);
                }
            } else {
                ModReference.LOG.debug("Item mismatch, expected: {}, actual: {}", (Object)instance.getItem().func_77658_a(), (Object)itemStack.func_77973_b().func_77658_a());
            }
        }
    }

    public void watch(PlayerItemInstance<?> watchableInstance) {
        this.watchables.put(watchableInstance, watchableInstance.getUpdateId());
    }

    public void unwatch(PlayerItemInstance<?> watchableInstance) {
        this.watchables.remove(watchableInstance);
    }

    public void run() {
        List<PlayerItemInstance> instancesToUpdate = this.watchables.entrySet().stream().filter(e -> ((PlayerItemInstance)e.getKey()).getUpdateId() != ((Long)e.getValue()).longValue() && ((PlayerItemInstance)e.getKey()).getSyncStartTimestamp() + 10000L < System.currentTimeMillis()).map(Map.Entry::getKey).collect(Collectors.toList());
        instancesToUpdate.forEach(this::sync);
    }

    private void sync(PlayerItemInstance<?> watchable) {
        ModReference.LOG.debug("Syncing {} in state {} with update id {} to server", watchable, watchable.getState(), (Object)watchable.getUpdateId());
        long updateId = watchable.getUpdateId();
        watchable.setSyncStartTimestamp(System.currentTimeMillis());
        this.permitManager.request(new Permit(watchable.getState()), watchable, (p, e) -> {
            this.watchables.put(watchable, updateId);
            watchable.setSyncStartTimestamp(0L);
            ModReference.LOG.debug("Completed syncing {} with update id {}", (Object)watchable, (Object)updateId);
        });
    }
}

