/*
 * Decompiled with CFR 0.152.
 */
package com.paneedah.weaponlib;

import com.paneedah.mwc.proxies.ClientProxy;
import com.paneedah.weaponlib.AttachmentCategory;
import com.paneedah.weaponlib.CustomArmor;
import com.paneedah.weaponlib.ItemMagazine;
import com.paneedah.weaponlib.KeyBindings;
import com.paneedah.weaponlib.ModContext;
import com.paneedah.weaponlib.PlayerWeaponInstance;
import com.paneedah.weaponlib.Tags;
import com.paneedah.weaponlib.Weapon;
import com.paneedah.weaponlib.WeaponAttachmentAspect;
import com.paneedah.weaponlib.WeaponState;
import com.paneedah.weaponlib.animation.AnimationModeProcessor;
import com.paneedah.weaponlib.animation.gui.AnimationGUI;
import com.paneedah.weaponlib.config.BalancePackManager;
import com.paneedah.weaponlib.config.ModernConfigManager;
import com.paneedah.weaponlib.debug.DebugRenderer;
import com.paneedah.weaponlib.jim.util.LangTools;
import com.paneedah.weaponlib.render.ModificationGUI;
import com.paneedah.weaponlib.render.gui.GUIRenderHelper;
import com.paneedah.weaponlib.vehicle.EntityVehicle;
import com.paneedah.weaponlib.vehicle.VehicleCustomGUI;
import net.minecraft.block.BlockDoor;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.shader.Framebuffer;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import org.lwjgl.opengl.GL11;

public class CustomGui
extends Gui {
    private static final int STATUS_BAR_BOTTOM_OFFSET = 15;
    private static final int STATUS_BAR_TOP_OFFSET = 10;
    private final WeaponAttachmentAspect attachmentAspect;
    private final ModContext modContext;
    private final String statusBarPosition;
    public static VehicleCustomGUI vehicleGUIOverlay = new VehicleCustomGUI();
    public static final ResourceLocation AMMO_COUNTER_TEXTURES = new ResourceLocation("mwc:textures/hud/ammoiconsheet.png");
    private static FontRenderer FONT_RENDERER = null;
    public static final int AMMO_COUNTER_WIDTH = 256;
    public static final int AMMO_COUNTER_HEIGHT = 52;
    public static final int AMMO_COUNTER_WEAPON_NAME_DOWNSCALE_THRESHOLD = 13;
    public static final double WEAPON_NAME_DOWNSCALE_MULTIPLIER = 8.5;
    public static final int WEAPON_STRING_X_OFFSET = 126;
    public static final double WEAPON_STRING_SCALE = 2.0;
    public static final int FIREMODE_INDICATOR_U_OFFSET = 147;
    public static final int FIREMODE_INDICATOR_U_WIDTH = 39;
    public static final int FIREMODE_INDICATOR_V_HEIGHT = 54;
    public static final int FIREMODE_INDICATOR_X_OFFSET = 90;
    public static final int FIREMODE_INDICATOR_Y_OFFSET = 60;
    public static final double FIREMODE_INDICATOR_SCALE = 0.7;
    public static final int DISABLED_STRING_X_OFFSET = 100;
    public static final int DISABLED_STRING_Y_OFFSET = 13;
    public static final double DISABLED_STRING_SCALE = 3.0;
    public static final int FIREMODE_KEY_X_STRING_OFFSET = 105;
    public static final int FIREMODE_KEY_Y_STRING_OFFSET = 30;
    public static final double FIREMODE_KEY_SCALE = 2.0;
    public static final double CURRENT_AMMO_STRING_SCALE = 3.5;
    public static final double AMMO_TOTAL_STRING_SCALE = 3.0;
    public static final double CURRENT_AMMO_STRING_Y_OFFSET = 5.5;
    public static final int CURRENT_AMMO_COUNT_STRING_X_OFFSET = 64;
    public static final int TOTAL_AMMO_COUNT_STRING_X_OFFSET = 84;
    public static final double KEY_NAME_OFFSET_FIREMODE_INDICATOR_MULTIPLIER = 1.75;
    public static final double CURRENT_AMMO_WIDTH_MULTIPLIER = 2.0;
    public static final double TOTAL_AMMO_STRING_SCALE = 6.625;
    public Vec3d cachedPlayerPosition = Vec3d.field_186680_a;
    public double cachedPlayerEyeHeight;
    public Vec3d cachedLookVector = Vec3d.field_186680_a;
    public boolean shouldRenderDoorOverlay = false;
    public static final double OPEN_DOOR_PERCENT_WIDTH_POS = 0.4;
    public static final double OPEN_DOOR_PERCENT_HEIGHT_POS = 0.6;
    public static final String OPENDOOR_TEXT_LANG_KEY = "overlay.opendoor";
    public static final int OPEN_DOOR_KEY_Y_OFFSET = 10;
    public static final int OPENDOOR_REACH_OVERLAY_DISTANCE = 5;
    public static final String BRACKET_FORMATTER = "[%s]";

    public CustomGui(Minecraft MC, ModContext modContext, WeaponAttachmentAspect attachmentAspect) {
        this.modContext = modContext;
        this.attachmentAspect = attachmentAspect;
        this.statusBarPosition = ModernConfigManager.statusBarPosition;
    }

    public static FontRenderer getFontRenderer() {
        if (FONT_RENDERER == null) {
            FONT_RENDERER = ClientProxy.MC.field_71466_p;
        }
        return FONT_RENDERER;
    }

    @SubscribeEvent
    public final void onRenderHud(RenderGameOverlayEvent.Pre event) {
        this.handleAnimationModeHUD(event);
        this.handleVehicleHUD(event);
        this.handleHelmetHUD(event);
        if (this.modContext.getMainHeldWeapon() != null) {
            ScaledResolution scaledResolution = new ScaledResolution(ClientProxy.MC);
            double width = scaledResolution.func_78327_c();
            double d = scaledResolution.func_78324_d();
        }
    }

    public void handleAnimationModeHUD(RenderGameOverlayEvent.Pre event) {
        if (AnimationModeProcessor.getInstance().getFPSMode()) {
            event.setCanceled(true);
            GlStateManager.func_179090_x();
            AnimationGUI.getInstance().render();
            if (AnimationGUI.getInstance().titleSafe.isState()) {
                DebugRenderer.setupBasicRender();
                ScaledResolution sr = new ScaledResolution(ClientProxy.MC);
                DebugRenderer.renderPoint(new Vec3d(sr.func_78327_c() / 2.0, sr.func_78324_d() / 2.0, 0.0), new Vec3d(1.0, 0.0, 0.0));
                DebugRenderer.destructBasicRender();
            }
        }
    }

    public void handleVehicleHUD(RenderGameOverlayEvent.Pre event) {
        EntityVehicle v;
        RenderGameOverlayEvent.ElementType eventType = event.getType();
        if (ClientProxy.MC.field_71439_g.func_184218_aH() && ClientProxy.MC.field_71439_g.func_184187_bx() instanceof EntityVehicle && !Double.isNaN((v = (EntityVehicle)ClientProxy.MC.field_71439_g.func_184187_bx()).getSolver().getVelocityVector().func_189985_c()) && v.getSolver().getVelocityVector().func_189985_c() != 0.0 && (eventType == RenderGameOverlayEvent.ElementType.CROSSHAIRS || eventType == RenderGameOverlayEvent.ElementType.HOTBAR || eventType == RenderGameOverlayEvent.ElementType.HEALTH || eventType == RenderGameOverlayEvent.ElementType.EXPERIENCE || eventType == RenderGameOverlayEvent.ElementType.ARMOR)) {
            event.setCanceled(true);
        }
        if (event.getType() == RenderGameOverlayEvent.ElementType.HELMET && ClientProxy.MC.field_71439_g.func_184218_aH() && ClientProxy.MC.field_71439_g.func_184187_bx() instanceof EntityVehicle) {
            EntityVehicle vehicle = (EntityVehicle)ClientProxy.MC.field_71439_g.func_184187_bx();
            vehicleGUIOverlay.renderGUI(vehicle);
        }
    }

    public void handleHelmetHUD(RenderGameOverlayEvent.Pre event) {
        String hudTexture;
        ItemStack helmetStack;
        if (event.getType() == RenderGameOverlayEvent.ElementType.HELMET && (helmetStack = ClientProxy.MC.field_71439_g.func_184582_a(EntityEquipmentSlot.HEAD)) != null && ClientProxy.MC.field_71474_y.field_74320_O == 0 && helmetStack.func_77973_b() instanceof CustomArmor && (hudTexture = ((CustomArmor)helmetStack.func_77973_b()).getHudTexture()) != null) {
            CustomArmor armor;
            double maxShieldCapacity;
            ScaledResolution scaledResolution = event.getResolution();
            int screenWidth = scaledResolution.func_78326_a();
            int screenHeight = scaledResolution.func_78328_b();
            ItemStack chestStack = ClientProxy.MC.field_71439_g.func_184582_a(EntityEquipmentSlot.CHEST);
            ItemStack feetStack = ClientProxy.MC.field_71439_g.func_184582_a(EntityEquipmentSlot.FEET);
            if (chestStack != null && helmetStack != null && feetStack != null && chestStack.func_77973_b() instanceof CustomArmor && helmetStack.func_77973_b() instanceof CustomArmor && feetStack.func_77973_b() instanceof CustomArmor && ((CustomArmor)chestStack.func_77973_b()).getUnlocalizedArmorSetName().equals(((CustomArmor)helmetStack.func_77973_b()).getUnlocalizedArmorSetName()) && ((CustomArmor)chestStack.func_77973_b()).getUnlocalizedArmorSetName().equals(((CustomArmor)feetStack.func_77973_b()).getUnlocalizedArmorSetName()) && (maxShieldCapacity = (armor = (CustomArmor)chestStack.func_77973_b()).getMaxShieldCapacity()) > 0.0) {
                double currentShieldCapacity = armor.getShieldCapacity(chestStack);
                this.drawShieldIndicator(armor, MathHelper.func_151237_a((double)(currentShieldCapacity / maxShieldCapacity), (double)0.0, (double)1.0), screenWidth, screenHeight);
            }
            GL11.glPushAttrib((int)1048575);
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            GL11.glDisable((int)2896);
            GL11.glBlendFunc((int)770, (int)771);
            GL11.glEnable((int)3042);
            ClientProxy.MC.field_71446_o.func_110577_a(new ResourceLocation(hudTexture));
            CustomGui.drawTexturedQuadFit(0.0, 0.0, screenWidth, screenHeight, -100.0);
            GL11.glPopAttrib();
        }
    }

    public void handleModificationHUD(RenderGameOverlayEvent.Pre event, PlayerWeaponInstance weaponInstance, double scaledWidth, double scaledHeight) {
        if (CustomGui.isInAltModifyingState(weaponInstance) || CustomGui.isInModifyingState(weaponInstance)) {
            ModificationGUI.getInstance().render(this.modContext);
        } else {
            ModernConfigManager.enableOpenDoorDisplay = ModernConfigManager.enableAmmoCounter;
            if (ModernConfigManager.enableAmmoCounter) {
                this.handleAmmoCounter(event, weaponInstance, scaledWidth, scaledHeight);
            }
            event.setCanceled(true);
        }
    }

    public void handleAmmoCounter(RenderGameOverlayEvent.Pre event, PlayerWeaponInstance weaponInstance, double scaledWidth, double scaledHeight) {
        String currentAmmo;
        String totalCapaString;
        int AMMO_COUNTER_X_POS = 256 + ModernConfigManager.ammoCounterX;
        int AMMO_COUNTER_Y_POS = 128 + ModernConfigManager.ammoCounterY;
        double AMMO_COUNTER_SIZE = ModernConfigManager.ammoCounterSize;
        GlStateManager.func_179147_l();
        GlStateManager.func_179094_E();
        GlStateManager.func_179137_b((double)(scaledWidth - (double)AMMO_COUNTER_X_POS * AMMO_COUNTER_SIZE), (double)(scaledHeight - (double)AMMO_COUNTER_Y_POS * AMMO_COUNTER_SIZE), (double)0.0);
        GlStateManager.func_179139_a((double)AMMO_COUNTER_SIZE, (double)AMMO_COUNTER_SIZE, (double)AMMO_COUNTER_SIZE);
        ClientProxy.MC.func_110434_K().func_110577_a(AMMO_COUNTER_TEXTURES);
        int firemode = 0;
        switch (weaponInstance.getMaxShots()) {
            case 0x7FFFFFFF: {
                firemode = 2;
                break;
            }
            case 1: {
                firemode = 0;
                break;
            }
            default: {
                firemode = 1;
            }
        }
        ItemMagazine magazine = (ItemMagazine)WeaponAttachmentAspect.getActiveAttachment(AttachmentCategory.MAGAZINE, weaponInstance);
        int totalCapacity = magazine != null ? magazine.getCapacity() : weaponInstance.getWeapon().getAmmoCapacity();
        if (weaponInstance.getWeapon().getAmmoCapacity() == 0 && totalCapacity == 0) {
            totalCapaString = "-";
            currentAmmo = "-";
        } else {
            currentAmmo = String.valueOf(weaponInstance.getAmmo());
            totalCapaString = String.valueOf(totalCapacity);
        }
        String keyNameString = String.format(BRACKET_FORMATTER, KeyBindings.fireModeKey.getDisplayName());
        double keyNameOffset = CustomGui.getFontRenderer().func_78256_a(keyNameString);
        if (ModernConfigManager.enableAmmoCounterBackground) {
            if (ModernConfigManager.ammoCounterBackgroundReverse) {
                GlStateManager.func_179147_l();
                GlStateManager.func_179094_E();
                GlStateManager.func_179152_a((float)-1.0f, (float)1.0f, (float)1.0f);
                this.func_73729_b(-90, 0, 0, 0, -256, 52);
                GlStateManager.func_179121_F();
            } else {
                this.func_73729_b(0, 0, 0, 0, 256, 52);
            }
        }
        GlStateManager.func_179094_E();
        GlStateManager.func_179137_b((double)(166.0 - keyNameOffset * 1.75), (double)60.0, (double)0.0);
        GlStateManager.func_179139_a((double)0.7, (double)0.7, (double)0.7);
        GlStateManager.func_179147_l();
        this.func_73729_b(0, 0, 147 + 39 * (2 - firemode), 54, 39, 39);
        GlStateManager.func_179121_F();
        String weaponName = new TextComponentTranslation(LangTools.formatName(weaponInstance.getWeapon().func_77658_a()), new Object[0]).func_150254_d();
        String bottomString = String.format("  %s  | %s%s", TextFormatting.GRAY, TextFormatting.WHITE, totalCapaString);
        double totalLength = 0.0;
        if (bottomString.length() > 13) {
            int adjLength = bottomString.length() - 13;
            totalLength = (double)adjLength * 8.5;
        }
        this.drawScaledString(FONT_RENDERER, weaponName, 126 - FONT_RENDERER.func_78256_a(weaponName), -CustomGui.FONT_RENDERER.field_78288_b, 2.0, 16632686);
        if (!BalancePackManager.isWeaponDisabled(weaponInstance.getWeapon())) {
            this.drawScaledString(FONT_RENDERER, currentAmmo, 84.0 - (double)FONT_RENDERER.func_78256_a(currentAmmo) * 2.0 - totalLength, 5.5, 3.5, 16632686);
            this.drawScaledString(FONT_RENDERER, bottomString, 64.0 - totalLength, 6.625, 3.0);
        } else {
            GUIRenderHelper.drawScaledString("Disabled", 100.0 - totalLength, 13.0, 3.0, 12597547);
        }
        this.drawScaledString(FONT_RENDERER, keyNameString, 105.0 - keyNameOffset, 30.0, 2.0, 16632686);
        GlStateManager.func_179121_F();
    }

    public void handleOpenDoorHUD(RenderGameOverlayEvent.Pre event, double scaledWidth, double scaledHeight) {
        if (ModernConfigManager.enableOpenDoorDisplay) {
            IBlockState state;
            EntityPlayerSP player = ClientProxy.MC.field_71439_g;
            if (this.shouldRenderDoorOverlay) {
                int openDoorX = (int)(scaledWidth * 0.4);
                int openDoorY = (int)(scaledHeight * 0.6);
                this.func_73732_a(FONT_RENDERER, String.format(BRACKET_FORMATTER, KeyBindings.openDoor.getDisplayName()), openDoorX, openDoorY, 15844367);
                this.func_73732_a(FONT_RENDERER, LangTools.formatName(OPENDOOR_TEXT_LANG_KEY), openDoorX, openDoorY + 10, 0xFFFFFF);
            }
            if (this.cachedPlayerPosition.equals((Object)player.func_174791_d()) && this.cachedPlayerEyeHeight == (double)player.func_70047_e() && this.cachedLookVector.equals((Object)player.func_70040_Z())) {
                return;
            }
            this.cachedPlayerPosition = player.func_174791_d();
            this.cachedLookVector = player.func_70040_Z();
            this.cachedPlayerEyeHeight = player.func_70047_e();
            this.shouldRenderDoorOverlay = false;
            Vec3d originVector = player.func_174791_d().func_72441_c(0.0, (double)player.func_70047_e(), 0.0);
            RayTraceResult rtr = player.field_70170_p.func_147447_a(originVector, originVector.func_178787_e(player.func_70040_Z().func_186678_a(5.0)), false, true, false);
            if (rtr != null && (state = player.field_70170_p.func_180495_p(rtr.func_178782_a())).func_177230_c() instanceof BlockDoor) {
                this.shouldRenderDoorOverlay = true;
            }
        }
    }

    @SubscribeEvent
    public final void onRenderCrosshair(RenderGameOverlayEvent.Pre event) {
        if (event.getType() != RenderGameOverlayEvent.ElementType.CROSSHAIRS || ClientProxy.MC.field_71439_g.func_175149_v()) {
            return;
        }
        ItemStack itemStack = ClientProxy.MC.field_71439_g.func_184614_ca();
        if (itemStack == null) {
            return;
        }
        ScaledResolution scaledResolution = event.getResolution();
        int width = scaledResolution.func_78326_a();
        int height = scaledResolution.func_78328_b();
        FontRenderer fontRender = ClientProxy.MC.field_71466_p;
        PlayerWeaponInstance weaponInstance = this.modContext.getMainHeldWeapon();
        if (weaponInstance != null) {
            String crosshair;
            Weapon weaponItem = (Weapon)itemStack.func_77973_b();
            String string = crosshair = weaponItem != null ? weaponItem.getCrosshair(weaponInstance) : null;
            if (crosshair != null) {
                ClientProxy.MC.field_71460_t.func_78478_c();
                GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                GlStateManager.func_179140_f();
                GlStateManager.func_187401_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
                GlStateManager.func_179084_k();
                ClientProxy.MC.field_71446_o.func_110577_a(new ResourceLocation(crosshair));
                this.handleModificationHUD(event, this.modContext.getMainHeldWeapon(), width, height);
                this.handleOpenDoorHUD(event, width, height);
            }
        } else if (itemStack.func_77973_b() instanceof ItemMagazine) {
            ClientProxy.MC.field_71460_t.func_78478_c();
            int color = 0xFFFFFF;
            String messageText = this.getDefaultMagazineMessage(itemStack);
            int x = this.getStatusBarXPosition(width, messageText, fontRender);
            int y = this.getStatusBarYPosition(height);
            fontRender.func_175063_a(messageText, (float)x, (float)y, color);
            event.setCanceled(true);
        }
    }

    public void drawScaledString(FontRenderer fr, String str, double x, double y, double scale, int color) {
        GlStateManager.func_179094_E();
        GlStateManager.func_179137_b((double)x, (double)y, (double)0.0);
        GlStateManager.func_179139_a((double)scale, (double)scale, (double)scale);
        fr.func_175063_a(str, (float)(x / scale), (float)(y / scale), color);
        GlStateManager.func_179121_F();
    }

    public void drawScaledString(FontRenderer fr, String str, double x, double y, double scale) {
        this.drawScaledString(fr, str, x, y, scale, 0xFFFFFF);
    }

    private void drawShieldIndicator(CustomArmor armor, double capacity, double screenWidth, double screenHeight) {
        Framebuffer framebuffer = ClientProxy.MC.func_147110_a();
        if (!framebuffer.isStencilEnabled()) {
            framebuffer.enableStencil();
        }
        GL11.glEnable((int)3008);
        GL11.glEnable((int)2960);
        GL11.glPushAttrib((int)8192);
        GL11.glStencilFunc((int)519, (int)1, (int)255);
        GL11.glStencilOp((int)7680, (int)7680, (int)7681);
        GL11.glStencilMask((int)255);
        GL11.glBlendFunc((int)770, (int)771);
        GL11.glEnable((int)3042);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glColorMask((boolean)false, (boolean)false, (boolean)false, (boolean)false);
        GL11.glDepthMask((boolean)false);
        GL11.glClear((int)1024);
        ClientProxy.MC.field_71446_o.func_110577_a(new ResourceLocation(armor.getShieldIndicatorMaskTextureName()));
        CustomGui.drawTexturedQuadFit((armor.getShieldIndicatorPositionX() - 1.0) * (screenWidth / 640.0), armor.getShieldIndicatorPositionY() * (screenHeight / 328.0), armor.getShieldIndicatorWidth() * (screenWidth / 640.0) + 2.0, (armor.getShieldIndicatorHeight() + 1.0) * (screenHeight / 328.0), -101.0);
        GL11.glStencilFunc((int)514, (int)1, (int)255);
        GL11.glStencilMask((int)0);
        GL11.glDepthMask((boolean)true);
        GL11.glColorMask((boolean)true, (boolean)true, (boolean)true, (boolean)true);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glDisable((int)2896);
        GL11.glBlendFunc((int)770, (int)771);
        GL11.glEnable((int)3042);
        ClientProxy.MC.field_71446_o.func_110577_a(new ResourceLocation(armor.getShieldIndicatorProgressBarTextureName()));
        CustomGui.drawTexturedQuadFit((armor.getShieldIndicatorPositionX() - 1.0) * (screenWidth / 640.0), armor.getShieldIndicatorPositionY() * (screenHeight / 328.0), (armor.getShieldIndicatorWidth() + 2.0) * (screenWidth / 640.0) * capacity, (armor.getShieldIndicatorHeight() + 1.0) * (screenHeight / 328.0), -101.0);
        GL11.glPopAttrib();
        GlStateManager.func_179118_c();
        GL11.glDisable((int)2960);
    }

    private int getStatusBarXPosition(int width, String text, FontRenderer fontRender) {
        int x;
        if (this.statusBarPosition.equals("BOTTOM_RIGHT") || this.statusBarPosition.equals("TOP_RIGHT")) {
            x = width - 80;
            int stringWidth = fontRender.func_78256_a(text);
            if (stringWidth > 80) {
                x = width - stringWidth - 5;
            }
        } else {
            x = 10;
        }
        return x;
    }

    private int getStatusBarYPosition(int height) {
        int yPos;
        switch (this.statusBarPosition) {
            case "TOP_RIGHT": 
            case "TOP_LEFT": {
                yPos = 10;
                break;
            }
            case "BOTTOM_RIGHT": 
            case "BOTTOM_LEFT": {
                yPos = height - 15;
                break;
            }
            default: {
                yPos = 10;
            }
        }
        return yPos;
    }

    private String getDefaultMagazineMessage(ItemStack itemStack) {
        ItemMagazine magazine = (ItemMagazine)itemStack.func_77973_b();
        String ammoCounterMessage = I18n.func_135052_a((String)"gui.ammoCounter", (Object[])new Object[]{Tags.getAmmo(itemStack) + "/" + magazine.getCapacity()});
        return ammoCounterMessage;
    }

    private String getDefaultWeaponMessage(PlayerWeaponInstance weaponInstance) {
        ItemMagazine magazine = (ItemMagazine)WeaponAttachmentAspect.getActiveAttachment(AttachmentCategory.MAGAZINE, weaponInstance);
        int totalCapacity = magazine != null ? magazine.getCapacity() : weaponInstance.getWeapon().getAmmoCapacity();
        String text = weaponInstance.getWeapon().getAmmoCapacity() == 0 && totalCapacity == 0 ? I18n.func_135052_a((String)"gui.noMagazine", (Object[])new Object[0]) : I18n.func_135052_a((String)"gui.ammoCounter", (Object[])new Object[]{weaponInstance.getWeapon().getCurrentAmmo((EntityPlayer)ClientProxy.MC.field_71439_g) + "/" + totalCapacity});
        return text;
    }

    public static boolean isInModifyingState(PlayerWeaponInstance weaponInstance) {
        return weaponInstance.getState() == WeaponState.MODIFYING && !weaponInstance.isAltMofificationModeEnabled() || weaponInstance.getState() == WeaponState.MODIFYING_REQUESTED || weaponInstance.getState() == WeaponState.NEXT_ATTACHMENT || weaponInstance.getState() == WeaponState.NEXT_ATTACHMENT_REQUESTED;
    }

    public static boolean isInAltModifyingState(PlayerWeaponInstance weaponInstance) {
        return weaponInstance.isAltMofificationModeEnabled() && (weaponInstance.getState() == WeaponState.MODIFYING || weaponInstance.getState() == WeaponState.MODIFYING_REQUESTED || weaponInstance.getState() == WeaponState.NEXT_ATTACHMENT || weaponInstance.getState() == WeaponState.NEXT_ATTACHMENT_REQUESTED);
    }

    private static void drawTexturedQuadFit(double x, double y, double width, double height, double zLevel) {
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder buffer = tessellator.func_178180_c();
        buffer.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        buffer.func_181662_b(x + 0.0, y + height, zLevel).func_187315_a(0.0, 1.0).func_181675_d();
        buffer.func_181662_b(x + width, y + height, zLevel).func_187315_a(1.0, 1.0).func_181675_d();
        buffer.func_181662_b(x + width, y + 0.0, zLevel).func_187315_a(1.0, 0.0).func_181675_d();
        buffer.func_181662_b(x + 0.0, y + 0.0, zLevel).func_187315_a(0.0, 0.0).func_181675_d();
        tessellator.func_78381_a();
    }
}

