/*
 * Decompiled with CFR 0.152.
 */
package com.paneedah.mwc.network.messages;

import com.paneedah.weaponlib.crafting.CraftingGroup;
import io.netty.buffer.ByteBuf;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public final class WorkbenchServerMessage
implements IMessage {
    public static final int CRAFT = 1;
    public static final int DISMANTLE = 2;
    public static final int MOVE_OUTPUT = 3;
    public static final int POP_FROM_QUEUE = 5;
    private int opCode;
    private BlockPos teLocation;
    private int craftingTimer;
    private int craftingDuration;
    private CraftingGroup craftingGroup;
    private String craftingName = "";
    private int playerID;
    private int slotToMove;
    private int quantity = -1;

    public WorkbenchServerMessage(int type, BlockPos location, int playerID, int slotToMove) {
        this.opCode = type;
        this.teLocation = location;
        this.playerID = playerID;
        this.slotToMove = slotToMove;
    }

    public WorkbenchServerMessage(int type, BlockPos location, String nameToCraft, CraftingGroup group, int quantity) {
        this.opCode = type;
        this.teLocation = location;
        this.craftingName = nameToCraft;
        this.craftingGroup = group;
        this.quantity = quantity;
    }

    public WorkbenchServerMessage(int type, BlockPos location, int craftingTimer, int craftingDuration, CraftingGroup group, String nameToCraft) {
        this.opCode = type;
        this.teLocation = location;
        this.craftingTimer = craftingTimer;
        this.craftingDuration = craftingDuration;
        this.craftingGroup = group;
        this.craftingName = nameToCraft;
    }

    public void fromBytes(ByteBuf byteBuf) {
        this.opCode = byteBuf.readInt();
        this.teLocation = BlockPos.func_177969_a((long)byteBuf.readLong());
        if (this.opCode == 1) {
            this.quantity = byteBuf.readInt();
            if (this.quantity == -1) {
                this.craftingTimer = byteBuf.readInt();
                this.craftingDuration = byteBuf.readInt();
            }
            this.craftingGroup = CraftingGroup.getValue(byteBuf.readInt());
            this.craftingName = ByteBufUtils.readUTF8String((ByteBuf)byteBuf);
        } else if (this.opCode == 3 || this.opCode == 5) {
            this.playerID = byteBuf.readInt();
            this.slotToMove = byteBuf.readInt();
        } else if (this.opCode == 2) {
            this.craftingDuration = byteBuf.readInt();
        }
    }

    public void toBytes(ByteBuf byteBuf) {
        byteBuf.writeInt(this.opCode);
        byteBuf.writeLong(this.teLocation.func_177986_g());
        if (this.opCode == 1) {
            byteBuf.writeInt(this.quantity);
            if (this.quantity == -1) {
                byteBuf.writeInt(this.craftingTimer);
                byteBuf.writeInt(this.craftingDuration);
            }
            byteBuf.writeInt(this.craftingGroup.getID());
            ByteBufUtils.writeUTF8String((ByteBuf)byteBuf, (String)this.craftingName);
        } else if (this.opCode == 3 || this.opCode == 5) {
            byteBuf.writeInt(this.playerID);
            byteBuf.writeInt(this.slotToMove);
        } else if (this.opCode == 2) {
            byteBuf.writeInt(this.craftingDuration);
        }
    }

    public int getOpCode() {
        return this.opCode;
    }

    public BlockPos getTeLocation() {
        return this.teLocation;
    }

    public int getCraftingTimer() {
        return this.craftingTimer;
    }

    public int getCraftingDuration() {
        return this.craftingDuration;
    }

    public CraftingGroup getCraftingGroup() {
        return this.craftingGroup;
    }

    public String getCraftingName() {
        return this.craftingName;
    }

    public int getPlayerID() {
        return this.playerID;
    }

    public int getSlotToMove() {
        return this.slotToMove;
    }

    public int getQuantity() {
        return this.quantity;
    }

    public WorkbenchServerMessage() {
    }
}

