/*
 * Decompiled with CFR 0.152.
 */
package com.paneedah.mwc.network.messages;

import com.paneedah.mwc.network.CompressionUtil;
import com.paneedah.weaponlib.tracking.LivingEntityTracker;
import io.netty.buffer.ByteBuf;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public final class LivingEntityTrackerMessage
implements IMessage {
    private LivingEntityTracker playerEntityTracker;
    private String statusMessage;

    public void fromBytes(ByteBuf byteBuf) {
        this.playerEntityTracker = LivingEntityTracker.read(byteBuf);
        if (!byteBuf.readBoolean()) {
            return;
        }
        byte[] bytes = new byte[byteBuf.readInt()];
        for (int i = 0; i < bytes.length; ++i) {
            bytes[i] = byteBuf.readByte();
        }
        this.statusMessage = CompressionUtil.decompressString(bytes);
    }

    public void toBytes(ByteBuf byteBuf) {
        this.playerEntityTracker.write(byteBuf);
        byteBuf.writeBoolean(this.statusMessage != null);
        if (this.statusMessage == null) {
            return;
        }
        byte[] bytes = CompressionUtil.compressString(this.statusMessage);
        byteBuf.writeInt(bytes.length);
        byteBuf.writeBytes(bytes);
    }

    public LivingEntityTracker getPlayerEntityTracker() {
        return this.playerEntityTracker;
    }

    public String getStatusMessage() {
        return this.statusMessage;
    }

    public LivingEntityTrackerMessage() {
    }

    public LivingEntityTrackerMessage(LivingEntityTracker playerEntityTracker, String statusMessage) {
        this.playerEntityTracker = playerEntityTracker;
        this.statusMessage = statusMessage;
    }
}

