/*
 * Decompiled with CFR 0.152.
 */
package com.paneedah.mwc.network;

import com.paneedah.mwc.network.ISerializable;
import com.paneedah.mwc.utils.ModReference;
import io.netty.buffer.ByteBuf;
import java.util.UUID;

public abstract class UniversalObject
implements ISerializable {
    private final UUID uuid = UUID.randomUUID();
    private UUID readUUID = null;

    protected int getSerialVersion() {
        return 0;
    }

    protected UniversalObject() {
    }

    public UUID getUuid() {
        if (this.readUUID == null) {
            return this.uuid;
        }
        return this.readUUID;
    }

    @Override
    public void read(ByteBuf byteBuf) {
        if (this.getSerialVersion() != byteBuf.readInt()) {
            ModReference.RED_LOG.printFramedError("Networking", "Serial version mismatch", "", new String[]{"Serial version: " + this.getSerialVersion(), "ByteBuf version: " + byteBuf.readInt()});
            throw new IndexOutOfBoundsException();
        }
        this.readUUID = new UUID(byteBuf.readLong(), byteBuf.readLong());
    }

    @Override
    public void write(ByteBuf byteBuf) {
        byteBuf.writeInt(this.getSerialVersion());
        UUID uuid = this.readUUID == null ? this.uuid : this.readUUID;
        byteBuf.writeLong(uuid.getMostSignificantBits());
        byteBuf.writeLong(uuid.getLeastSignificantBits());
    }

    public int hashCode() {
        UUID uuid = this.readUUID == null ? this.uuid : this.readUUID;
        return 31 + (uuid == null ? 0 : uuid.hashCode());
    }

    public boolean equals(Object obj) {
        UUID uuid;
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        UniversalObject other = (UniversalObject)obj;
        UUID uUID = uuid = this.readUUID == null ? this.uuid : this.readUUID;
        if (uuid == null) {
            return other.uuid == null;
        }
        return uuid.equals(other.uuid);
    }
}

