/*
 * Decompiled with CFR 0.152.
 */
package com.paneedah.mwc.equipment.inventory.carryable.backpack;

import com.paneedah.mwc.items.equipment.carryable.ItemBackpack;
import java.util.ArrayList;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.text.ITextComponent;

public class BackpackInventory
implements IInventory {
    private static final String TAG_SLOT_INDEX = "Slot";
    private static final String TAG_SIZE = "size";
    private final String name;
    private final ItemStack owner;
    private ItemStack[] inventory;

    public BackpackInventory(ItemStack owner) {
        this.owner = owner;
        this.name = null;
        int size = ((ItemBackpack)owner.func_77973_b()).getSize();
        this.inventory = new ItemStack[size];
        for (int i = 0; i < this.inventory.length; ++i) {
            this.inventory[i] = new ItemStack(Items.field_190931_a);
        }
        if (!owner.func_77942_o()) {
            NBTTagCompound storageCompound = new NBTTagCompound();
            storageCompound.func_74768_a(TAG_SIZE, size);
            owner.func_77982_d(storageCompound);
        }
        this.deserialize(owner.func_77978_p());
    }

    public ItemBackpack getOwner() {
        return (ItemBackpack)this.owner.func_77973_b();
    }

    public int func_70302_i_() {
        return this.inventory.length;
    }

    public ItemStack func_70301_a(int slot) {
        return this.inventory[slot];
    }

    public ItemStack func_70298_a(int slot, int amount) {
        ItemStack stack = this.func_70301_a(slot);
        if (stack.func_190916_E() > amount) {
            stack = stack.func_77979_a(amount);
            this.func_70296_d();
        } else {
            this.func_70299_a(slot, new ItemStack(Items.field_190931_a));
        }
        return stack;
    }

    public void func_70299_a(int slot, ItemStack stack) {
        this.inventory[slot] = stack;
        if (stack.func_190916_E() > this.func_70297_j_()) {
            stack.func_190920_e(this.func_70297_j_());
        }
        this.func_70296_d();
    }

    public String func_70005_c_() {
        return this.func_145818_k_() ? this.name : "Inventory Item";
    }

    public boolean func_145818_k_() {
        return this.name != null;
    }

    public int func_70297_j_() {
        return 64;
    }

    public void func_70296_d() {
        for (int i = 0; i < this.func_70302_i_(); ++i) {
            if (this.func_70301_a(i).func_190916_E() != 0) continue;
            this.inventory[i] = new ItemStack(Items.field_190931_a);
        }
        this.serialize(this.owner.func_77978_p());
    }

    public boolean func_70300_a(EntityPlayer entityPlayer) {
        return true;
    }

    public boolean func_94041_b(int slot, ItemStack itemStack) {
        return true;
    }

    private void deserialize(NBTTagCompound compound) {
        NBTTagList items = compound.func_150295_c("ItemInventory", 10);
        int size = compound.func_74762_e(TAG_SIZE);
        if (size >= 0 && items.func_74745_c() >= 0) {
            int i;
            this.inventory = new ItemStack[size];
            for (i = 0; i < size; ++i) {
                this.inventory[i] = new ItemStack(Items.field_190931_a);
            }
            for (i = 0; i < size && i < items.func_74745_c(); ++i) {
                NBTTagCompound item = items.func_150305_b(i);
                int slot = item.func_74762_e(TAG_SLOT_INDEX);
                if (slot < 0 || slot >= size) continue;
                this.inventory[slot] = new ItemStack(item);
            }
        }
    }

    private void serialize(NBTTagCompound tagcompound) {
        tagcompound.func_74768_a(TAG_SIZE, this.inventory.length);
        NBTTagList items = new NBTTagList();
        ArrayList<ItemStack> stackInSlots = new ArrayList<ItemStack>();
        for (int i = 0; i < this.func_70302_i_(); ++i) {
            ItemStack stackInSlot = this.func_70301_a(i);
            if (stackInSlot == null) continue;
            NBTTagCompound item = new NBTTagCompound();
            item.func_74768_a(TAG_SLOT_INDEX, i);
            stackInSlot.func_77955_b(item);
            items.func_74742_a((NBTBase)item);
            stackInSlots.add(stackInSlot);
        }
        tagcompound.func_74782_a("ItemInventory", (NBTBase)items);
    }

    public ITextComponent func_145748_c_() {
        return null;
    }

    public boolean func_191420_l() {
        return false;
    }

    public ItemStack func_70304_b(int index) {
        return null;
    }

    public void func_174889_b(EntityPlayer player) {
    }

    public void func_174886_c(EntityPlayer player) {
    }

    public int func_174887_a_(int id) {
        return 0;
    }

    public void func_174885_b(int id, int value) {
    }

    public int func_174890_g() {
        return 0;
    }

    public void func_174888_l() {
    }
}

