/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftools.setup;

import mcjty.lib.font.FontLoader;
import mcjty.lib.font.TrueTypeFont;
import mcjty.lib.setup.DefaultClientProxy;
import mcjty.rftools.ClientCommandHandler;
import mcjty.rftools.RenderGameOverlayEventHandler;
import mcjty.rftools.RenderWorldLastEventHandler;
import mcjty.rftools.blocks.ModBlocks;
import mcjty.rftools.blocks.screens.ScreenConfiguration;
import mcjty.rftools.blocks.screens.ScreenSetup;
import mcjty.rftools.blocks.shield.BakedModelLoader;
import mcjty.rftools.items.builder.GuiShapeCard;
import mcjty.rftools.keys.KeyBindings;
import mcjty.rftools.keys.KeyInputHandler;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraftforge.client.event.ColorHandlerEvent;
import net.minecraftforge.client.event.DrawBlockHighlightEvent;
import net.minecraftforge.client.event.GuiOpenEvent;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.client.event.RenderWorldLastEvent;
import net.minecraftforge.client.model.ICustomModelLoader;
import net.minecraftforge.client.model.ModelLoaderRegistry;
import net.minecraftforge.client.model.obj.OBJLoader;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public class ClientProxy
extends DefaultClientProxy {
    private static final ResourceLocation VILLAGER_TEXTURE = new ResourceLocation("rftools", "textures/entities/rftoolsvillager.png");
    public static TrueTypeFont font;

    public void preInit(FMLPreInitializationEvent e) {
        super.preInit(e);
        MinecraftForge.EVENT_BUS.register((Object)this);
        OBJLoader.INSTANCE.addDomain("rftools");
        ModelLoaderRegistry.registerLoader((ICustomModelLoader)new BakedModelLoader());
        ClientCommandHandler.registerCommands();
    }

    public void init(FMLInitializationEvent e) {
        super.init(e);
        ModBlocks.initClientPost();
        MinecraftForge.EVENT_BUS.register((Object)new KeyInputHandler());
        KeyBindings.init();
        font = FontLoader.createFont((ResourceLocation)new ResourceLocation((String)ScreenConfiguration.font.get()), (float)((float)ScreenConfiguration.fontSize.get()), (boolean)false, (int)0, (char[])((String)ScreenConfiguration.additionalCharacters.get()).toCharArray());
    }

    @SubscribeEvent
    public void colorHandlerEventBlock(ColorHandlerEvent.Block event) {
        ModBlocks.initColorHandlers(event.getBlockColors());
    }

    @SubscribeEvent
    public void renderGameOverlayEvent(RenderGameOverlayEvent evt) {
        RenderGameOverlayEventHandler.onRender(evt);
    }

    @SubscribeEvent
    public void renderWorldLastEvent(RenderWorldLastEvent evt) {
        RenderWorldLastEventHandler.tick(evt);
    }

    @SubscribeEvent
    public void onRenderBlockOutline(DrawBlockHighlightEvent evt) {
        RayTraceResult target = evt.getTarget();
        if (target != null && target.field_72313_a == RayTraceResult.Type.BLOCK) {
            BlockPos pos = target.func_178782_a();
            if (pos == null || evt.getPlayer() == null) {
                return;
            }
            Block block = evt.getPlayer().func_130014_f_().func_180495_p(pos).func_177230_c();
            if (block == ScreenSetup.screenBlock || block == ScreenSetup.creativeScreenBlock || block == ScreenSetup.screenHitBlock) {
                evt.setCanceled(true);
            }
        }
    }

    @SubscribeEvent
    public void onGuiOpen(GuiOpenEvent event) {
        GuiScreen old;
        if (event.getGui() == null && (old = Minecraft.func_71410_x().field_71462_r) instanceof GuiShapeCard && ((GuiShapeCard)old).fromTE) {
            event.setGui(GuiShapeCard.returnGui);
            GuiShapeCard.returnGui = null;
        }
    }
}

