/*
 * Decompiled with CFR 0.152.
 */
package org.dave.bonsaitrees.integration.mods;

import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockPlanks;
import net.minecraft.block.BlockSapling;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import org.dave.bonsaitrees.api.BonsaiDropChances;
import org.dave.bonsaitrees.api.BonsaiIntegration;
import org.dave.bonsaitrees.api.IBonsaiIntegration;
import org.dave.bonsaitrees.api.IBonsaiTreeType;
import org.dave.bonsaitrees.api.ITreeTypeRegistry;
import org.dave.bonsaitrees.api.TreeTypeSimple;

@BonsaiIntegration
public class Vanilla
implements IBonsaiIntegration {
    @Override
    public void registerTrees(ITreeTypeRegistry registry) {
        for (BlockPlanks.EnumType woodType : BlockPlanks.EnumType.values()) {
            int meta = woodType.func_176839_a();
            String type = woodType.func_176610_l();
            TreeTypeSimple vanillaType = new TreeTypeSimple("minecraft:" + type, new ItemStack(Blocks.field_150345_g, 1, meta));
            vanillaType.addDrop(new ItemStack(Blocks.field_150345_g, BonsaiDropChances.saplingAmount, meta), BonsaiDropChances.saplingChance);
            vanillaType.addDrop(new ItemStack(Items.field_151055_y, BonsaiDropChances.stickAmount), BonsaiDropChances.stickChance);
            if (type.equals("acacia")) {
                vanillaType.addDrop(new ItemStack(Blocks.field_150363_s, BonsaiDropChances.logAmount, 0), BonsaiDropChances.logChance);
                vanillaType.addDrop(new ItemStack((Block)Blocks.field_150361_u, BonsaiDropChances.leafAmount, 0), BonsaiDropChances.leafChance);
            } else if (type.equals("dark_oak")) {
                vanillaType.addDrop(new ItemStack(Blocks.field_150363_s, BonsaiDropChances.logAmount, 1), BonsaiDropChances.logChance);
                vanillaType.addDrop(new ItemStack((Block)Blocks.field_150361_u, BonsaiDropChances.leafAmount, 1), BonsaiDropChances.leafChance);
            } else {
                vanillaType.addDrop(new ItemStack(Blocks.field_150364_r, BonsaiDropChances.logAmount, meta), BonsaiDropChances.logChance);
                vanillaType.addDrop(new ItemStack((Block)Blocks.field_150362_t, BonsaiDropChances.leafAmount, meta), BonsaiDropChances.leafChance);
            }
            if (type.equals("oak")) {
                vanillaType.addDrop(new ItemStack(Items.field_151034_e, BonsaiDropChances.fruitAmount, 0), BonsaiDropChances.fruitChance);
            }
            if (type.equals("jungle")) {
                vanillaType.addDrop(new ItemStack(Items.field_151100_aR, BonsaiDropChances.fruitAmount, 3), BonsaiDropChances.fruitChance);
            }
            registry.registerTreeType(this, vanillaType);
        }
    }

    @Override
    public void generateTree(IBonsaiTreeType type, World world, BlockPos pos, Random rand) {
        int meta = type.getExampleStack().func_77960_j();
        IBlockState saplingState = Blocks.field_150345_g.func_176203_a(meta);
        if (type.getName().equals("minecraft:dark_oak")) {
            world.func_175656_a(pos.func_177976_e(), saplingState);
            world.func_175656_a(pos.func_177968_d(), saplingState);
            world.func_175656_a(pos.func_177976_e().func_177968_d(), saplingState);
        }
        world.func_175656_a(pos, saplingState);
        BlockSapling saplingBlock = (BlockSapling)Blocks.field_150345_g;
        saplingBlock.func_176476_e(world, pos, saplingState, rand);
    }
}

