/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.voicechat.gui;

import de.maxhenkel.voicechat.VoicechatClient;
import de.maxhenkel.voicechat.gui.VoiceChatScreenBase;
import de.maxhenkel.voicechat.gui.audiodevice.SelectMicrophoneScreen;
import de.maxhenkel.voicechat.gui.audiodevice.SelectSpeakerScreen;
import de.maxhenkel.voicechat.gui.volume.AdjustVolumesScreen;
import de.maxhenkel.voicechat.gui.widgets.ButtonBase;
import de.maxhenkel.voicechat.gui.widgets.DenoiserButton;
import de.maxhenkel.voicechat.gui.widgets.EnumButton;
import de.maxhenkel.voicechat.gui.widgets.KeybindButton;
import de.maxhenkel.voicechat.gui.widgets.MicActivationButton;
import de.maxhenkel.voicechat.gui.widgets.MicAmplificationSlider;
import de.maxhenkel.voicechat.gui.widgets.MicTestButton;
import de.maxhenkel.voicechat.gui.widgets.VoiceActivationSlider;
import de.maxhenkel.voicechat.gui.widgets.VoiceSoundSlider;
import de.maxhenkel.voicechat.voice.client.ClientManager;
import de.maxhenkel.voicechat.voice.client.ClientVoicechat;
import de.maxhenkel.voicechat.voice.client.KeyEvents;
import de.maxhenkel.voicechat.voice.client.MicrophoneActivationType;
import de.maxhenkel.voicechat.voice.client.speaker.AudioType;
import java.io.IOException;
import javax.annotation.Nullable;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;

public class VoiceChatSettingsScreen
extends VoiceChatScreenBase {
    private static final ResourceLocation TEXTURE = new ResourceLocation("voicechat", "textures/gui/gui_voicechat_settings.png");
    private static final ITextComponent TITLE = new TextComponentTranslation("gui.voicechat.voice_chat_settings.title", new Object[0]);
    private static final ITextComponent ASSIGN_TOOLTIP = new TextComponentTranslation("message.voicechat.press_to_reassign_key", new Object[0]);
    private static final ITextComponent PUSH_TO_TALK = new TextComponentTranslation("message.voicechat.activation_type.ptt", new Object[0]);
    private static final ITextComponent ADJUST_VOLUMES = new TextComponentTranslation("message.voicechat.adjust_volumes", new Object[0]);
    private static final ITextComponent SELECT_MICROPHONE = new TextComponentTranslation("message.voicechat.select_microphone", new Object[0]);
    private static final ITextComponent SELECT_SPEAKER = new TextComponentTranslation("message.voicechat.select_speaker", new Object[0]);
    private static final ITextComponent BACK = new TextComponentTranslation("message.voicechat.back", new Object[0]);
    @Nullable
    private final GuiScreen parent;
    private VoiceActivationSlider voiceActivationSlider;
    private MicTestButton micTestButton;
    private KeybindButton keybindButton;

    public VoiceChatSettingsScreen(@Nullable GuiScreen parent) {
        super(TITLE, 248, 219);
        this.parent = parent;
    }

    public VoiceChatSettingsScreen() {
        this((GuiScreen)null);
    }

    @Override
    public void func_73866_w_() {
        super.func_73866_w_();
        int y = this.guiTop + 20;
        this.func_189646_b(new VoiceSoundSlider(0, this.guiLeft + 10, y, this.xSize - 20, 20));
        this.func_189646_b(new MicAmplificationSlider(1, this.guiLeft + 10, y += 21, this.xSize - 20, 20));
        this.func_189646_b(new DenoiserButton(2, this.guiLeft + 10, y += 21, this.xSize - 20, 20));
        this.voiceActivationSlider = new VoiceActivationSlider(5, this.guiLeft + 10 + 20 + 1, (y += 21) + 21, this.xSize - 20 - 20 - 1, 20);
        this.micTestButton = new MicTestButton(4, this.guiLeft + 10, y + 21, this.voiceActivationSlider);
        this.keybindButton = new KeybindButton(6, KeyEvents.KEY_PTT, this.guiLeft + 10 + 20 + 1, y + 21, this.xSize - 20 - 20 - 1, 20, PUSH_TO_TALK);
        this.func_189646_b(new MicActivationButton(3, this.guiLeft + 10, y, this.xSize - 20, 20, type -> {
            this.voiceActivationSlider.field_146125_m = MicrophoneActivationType.VOICE.equals(type);
            this.keybindButton.field_146125_m = MicrophoneActivationType.PTT.equals(type);
        }));
        this.func_189646_b(this.micTestButton);
        this.func_189646_b(this.voiceActivationSlider);
        this.func_189646_b(this.keybindButton);
        this.func_189646_b(new EnumButton<AudioType>(7, this.guiLeft + 10, y += 42, this.xSize - 20, 20, VoicechatClient.CLIENT_CONFIG.audioType){

            @Override
            protected ITextComponent getText(AudioType type) {
                return new TextComponentTranslation("message.voicechat.audio_type", new Object[]{type.getText()});
            }

            @Override
            protected void onUpdate(AudioType type) {
                ClientVoicechat client = ClientManager.getClient();
                if (client != null) {
                    VoiceChatSettingsScreen.this.micTestButton.stop();
                    client.reloadAudio();
                }
            }
        });
        y += 21;
        if (this.isIngame()) {
            this.func_189646_b(new ButtonBase(8, this.guiLeft + 10, y, this.xSize - 20, 20, ADJUST_VOLUMES){

                @Override
                public void onPress() {
                    VoiceChatSettingsScreen.this.field_146297_k.func_147108_a((GuiScreen)new AdjustVolumesScreen());
                }
            });
            y += 21;
        }
        this.func_189646_b(new ButtonBase(9, this.guiLeft + 10, y, this.xSize / 2 - 15, 20, SELECT_MICROPHONE){

            @Override
            public void onPress() {
                VoiceChatSettingsScreen.this.field_146297_k.func_147108_a((GuiScreen)new SelectMicrophoneScreen(VoiceChatSettingsScreen.this));
            }
        });
        this.func_189646_b(new ButtonBase(10, this.guiLeft + this.xSize / 2 + 1, y, (this.xSize - 20) / 2 - 1, 20, SELECT_SPEAKER){

            @Override
            public void onPress() {
                VoiceChatSettingsScreen.this.field_146297_k.func_147108_a((GuiScreen)new SelectSpeakerScreen(VoiceChatSettingsScreen.this));
            }
        });
        y += 21;
        if (!this.isIngame() && this.parent != null) {
            this.func_189646_b(new ButtonBase(11, this.guiLeft + 10, y, this.xSize - 20, 20, BACK){

                @Override
                public void onPress() {
                    VoiceChatSettingsScreen.this.field_146297_k.func_147108_a(VoiceChatSettingsScreen.this.parent);
                }
            });
        }
    }

    @Override
    public void renderBackground(int mouseX, int mouseY, float delta) {
        this.field_146297_k.func_110434_K().func_110577_a(TEXTURE);
        if (this.isIngame()) {
            this.func_73729_b(this.guiLeft, this.guiTop, 0, 0, this.xSize, this.ySize);
        }
    }

    @Override
    public void renderForeground(int mouseX, int mouseY, float delta) {
        int titleWidth = this.field_146289_q.func_78256_a(TITLE.func_150261_e());
        this.field_146289_q.func_78276_b(TITLE.func_150254_d(), this.guiLeft + (this.xSize - titleWidth) / 2, this.guiTop + 7, this.getFontColor());
        if (this.voiceActivationSlider == null) {
            return;
        }
        ITextComponent sliderTooltip = this.voiceActivationSlider.getHoverText();
        if (this.voiceActivationSlider.isHovered() && sliderTooltip != null) {
            this.func_146279_a(sliderTooltip.func_150254_d(), mouseX, mouseY);
        } else if (this.micTestButton.isHovered()) {
            this.micTestButton.onTooltip(this.micTestButton, mouseX, mouseY);
        } else if (this.keybindButton.isHovered()) {
            this.func_146279_a(ASSIGN_TOOLTIP.func_150254_d(), mouseX, mouseY);
        }
    }

    protected void func_73869_a(char typedChar, int keyCode) throws IOException {
        if (this.keybindButton.keyPressed(keyCode)) {
            return;
        }
        super.func_73869_a(typedChar, keyCode);
    }

    protected void func_73864_a(int mouseX, int mouseY, int mouseButton) throws IOException {
        if (this.keybindButton.mousePressed(mouseButton)) {
            return;
        }
        super.func_73864_a(mouseX, mouseY, mouseButton);
    }
}

