/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.voicechat;

import com.sun.jna.Platform;
import de.maxhenkel.voicechat.Voicechat;
import de.maxhenkel.voicechat.config.ClientConfig;
import de.maxhenkel.voicechat.config.VolumeConfig;
import de.maxhenkel.voicechat.configbuilder.ConfigBuilder;
import de.maxhenkel.voicechat.intercompatibility.CommonCompatibilityManager;
import de.maxhenkel.voicechat.macos.VersionCheck;
import de.maxhenkel.voicechat.plugins.impl.opus.OpusManager;
import de.maxhenkel.voicechat.profile.UsernameCache;
import de.maxhenkel.voicechat.resourcepacks.VoiceChatResourcePack;
import de.maxhenkel.voicechat.voice.client.ClientManager;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;

public abstract class VoicechatClient {
    public static ClientConfig CLIENT_CONFIG;
    public static VolumeConfig VOLUME_CONFIG;
    public static UsernameCache USERNAME_CACHE;
    public static VoiceChatResourcePack CLASSIC_ICONS;
    public static VoiceChatResourcePack WHITE_ICONS;
    public static VoiceChatResourcePack BLACK_ICONS;

    public void initializeConfigs() {
        this.fixVolumeConfig();
        CLIENT_CONFIG = ConfigBuilder.builder(ClientConfig::new).path(Voicechat.getModConfigFolder().resolve("voicechat-client.properties")).build();
        VOLUME_CONFIG = new VolumeConfig(Voicechat.getModConfigFolder().resolve("voicechat-volumes.properties"));
        USERNAME_CACHE = new UsernameCache(Voicechat.getModConfigFolder().resolve("username-cache.json").toFile());
    }

    public void initializeClient() {
        this.initializeConfigs();
        ClientManager.instance();
        OpusManager.opusNativeCheck();
        if (Platform.isMac()) {
            if (!VersionCheck.isMacOSNativeCompatible()) {
                Voicechat.LOGGER.warn("Your MacOS version is incompatible with {}", CommonCompatibilityManager.INSTANCE.getModName());
            }
            if (!VoicechatClient.CLIENT_CONFIG.javaMicrophoneImplementation.get().booleanValue()) {
                VoicechatClient.CLIENT_CONFIG.javaMicrophoneImplementation.set(true).save();
            }
        }
    }

    private void fixVolumeConfig() {
        Path oldLocation = Voicechat.getConfigFolder().resolve("voicechat-volumes.properties");
        Path newLocation = Voicechat.getModConfigFolder().resolve("voicechat-volumes.properties");
        if (!newLocation.toFile().exists() && oldLocation.toFile().exists()) {
            try {
                Files.move(oldLocation, newLocation, StandardCopyOption.ATOMIC_MOVE);
            }
            catch (IOException e) {
                Voicechat.LOGGER.error("Failed to move volumes config", e);
            }
        }
    }

    static {
        CLASSIC_ICONS = new VoiceChatResourcePack("classic_icons", (ITextComponent)new TextComponentTranslation("resourcepack.voicechat.classic_icons", new Object[0]));
        WHITE_ICONS = new VoiceChatResourcePack("white_icons", (ITextComponent)new TextComponentTranslation("resourcepack.voicechat.white_icons", new Object[0]));
        BLACK_ICONS = new VoiceChatResourcePack("black_icons", (ITextComponent)new TextComponentTranslation("resourcepack.voicechat.black_icons", new Object[0]));
    }
}

