/*
 * Decompiled with CFR 0.152.
 */
package weather2.block;

import CoroUtil.util.CoroUtilPhysics;
import CoroUtil.util.Vec3;
import java.util.List;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ITickable;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import weather2.ClientTickHandler;
import weather2.CommonProxy;
import weather2.block.BlockTSiren;
import weather2.config.ConfigMisc;
import weather2.config.ConfigSand;
import weather2.util.WeatherUtilSound;
import weather2.weathersystem.storm.StormObject;
import weather2.weathersystem.storm.WeatherObjectSandstorm;

public class TileEntityTSiren
extends TileEntity
implements ITickable {
    public long lastPlayTime = 0L;

    public void func_73660_a() {
        int meta;
        if (this.field_145850_b.field_72995_K && BlockTSiren.isEnabled(meta = CommonProxy.blockTSiren.func_176201_c(this.field_145850_b.func_180495_p(this.func_174877_v())))) {
            this.tickClient();
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void tickClient() {
        if (this.lastPlayTime < System.currentTimeMillis()) {
            WeatherObjectSandstorm sandstorm;
            Vec3 pos = new Vec3((double)this.func_174877_v().func_177958_n(), (double)this.func_174877_v().func_177956_o(), (double)this.func_174877_v().func_177952_p());
            StormObject so = ClientTickHandler.weatherManager.getClosestStorm(pos, ConfigMisc.sirenActivateDistance, StormObject.STATE_FORMING);
            if (so != null) {
                this.lastPlayTime = System.currentTimeMillis() + 13000L;
                WeatherUtilSound.playNonMovingSound(pos, "streaming.siren", 1.0f, 1.0f, 120.0f);
            } else if (!ConfigSand.Sandstorm_Siren_PleaseNoDarude && (sandstorm = ClientTickHandler.weatherManager.getClosestSandstormByIntensity(pos)) != null) {
                List<Vec3> points = sandstorm.getSandstormAsShape();
                float distMax = 75.0f;
                boolean inStorm = CoroUtilPhysics.isInConvexShape((Vec3)pos, points);
                double dist = Math.min((double)distMax, CoroUtilPhysics.getDistanceToShape((Vec3)pos, points));
                if (inStorm || dist < (double)distMax) {
                    String soundToPlay = "siren_sandstorm_5_extra";
                    if (this.func_145831_w().field_73012_v.nextBoolean()) {
                        soundToPlay = "siren_sandstorm_6_extra";
                    }
                    float distScale = Math.max(0.1f, 1.0f - (float)(dist / (double)distMax));
                    if (inStorm) {
                        distScale = 1.0f;
                    }
                    this.lastPlayTime = System.currentTimeMillis() + 15000L;
                    WeatherUtilSound.playNonMovingSound(pos, "streaming." + soundToPlay, 1.0f, distScale, distMax);
                }
            }
        }
    }
}

