/*
 * Decompiled with CFR 0.152.
 */
package gcewing.sg;

import com.google.common.collect.ImmutableList;
import gcewing.sg.BaseBakedRenderTarget;
import gcewing.sg.BaseBlockUtils;
import gcewing.sg.BaseMod;
import gcewing.sg.BaseModClient;
import gcewing.sg.BaseModelRenderer;
import gcewing.sg.BaseTexture;
import gcewing.sg.BaseWorldRenderTarget;
import gcewing.sg.Trans3;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BlockModelShapes;
import net.minecraft.client.renderer.BlockRendererDispatcher;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.block.model.ItemCameraTransforms;
import net.minecraft.client.renderer.block.model.ItemOverrideList;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.renderer.block.statemap.DefaultStateMapper;
import net.minecraft.client.renderer.block.statemap.IStateMapper;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.client.MinecraftForgeClient;
import net.minecraftforge.client.event.ModelBakeEvent;
import net.minecraftforge.client.event.TextureStitchEvent;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public class BaseRenderingManager<MOD extends BaseMod<? extends BaseModClient>>
implements BaseModClient.IRenderingManager {
    public boolean debugRenderingManager = false;
    public boolean debugModelRegistration = false;
    protected BaseModClient<MOD> client;
    protected Map<Block, BaseModClient.ICustomRenderer> blockRenderers = new HashMap<Block, BaseModClient.ICustomRenderer>();
    protected Map<Item, BaseModClient.ICustomRenderer> itemRenderers = new HashMap<Item, BaseModClient.ICustomRenderer>();
    protected Map<IBlockState, BaseModClient.ICustomRenderer> stateRendererCache = new HashMap<IBlockState, BaseModClient.ICustomRenderer>();
    protected Map<ResourceLocation, BaseModClient.ITexture> textureCache = new HashMap<ResourceLocation, BaseModClient.ITexture>();
    protected boolean customRenderingRequired;
    protected CustomBlockStateMapper blockStateMapper = new CustomBlockStateMapper();
    protected List<CustomBakedModel> bakedModels = new ArrayList<CustomBakedModel>();
    protected static Trans3 itemTrans = Trans3.blockCenterSideTurn(0, 2);
    protected CustomItemBakedModel itemBakedModel;
    protected static String[] texturePrefixes = new String[]{"blocks/", "textures/"};
    protected BlockRendererDispatcher blockRendererDispatcher;

    public BaseRenderingManager(BaseModClient client) {
        if (this.debugRenderingManager) {
            System.out.printf("BaseRenderingManager: Creating\n", new Object[0]);
        }
        this.client = client;
        MinecraftForge.EVENT_BUS.register((Object)this);
        FMLCommonHandler.instance().bus().register((Object)this);
    }

    @Override
    public void preInit() {
        if (this.debugRenderingManager) {
            System.out.printf("BaseRenderingManager.preInit\n", new Object[0]);
        }
        this.registerDefaultRenderers();
        this.registerDefaultModelLocations();
    }

    @Override
    public void postInit() {
        if (this.debugRenderingManager) {
            System.out.printf("BaseRenderingManager.postInit: customRenderingRequired = %s\n", this.customRenderingRequired);
        }
        if (this.customRenderingRequired) {
            this.enableCustomRendering();
        }
    }

    protected void registerDefaultRenderers() {
        for (Block block : ((BaseMod)this.client.base).registeredBlocks) {
            String name;
            if (!(block instanceof BaseMod.IBlock) || this.blockRenderers.containsKey(block) || (name = ((BaseMod.IBlock)block).getQualifiedRendererClassName()) == null) continue;
            try {
                Class<?> cls = Class.forName(name);
                this.addBlockRenderer(block, (BaseModClient.ICustomRenderer)cls.newInstance());
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }

    @Override
    public void addBlockRenderer(Block block, BaseModClient.ICustomRenderer renderer) {
        this.blockRenderers.put(block, renderer);
        this.customRenderingRequired = true;
        Item item = Item.func_150898_a((Block)block);
        if (item != null) {
            this.addItemRenderer(item, renderer);
        }
    }

    @Override
    public void addItemRenderer(Item item, BaseModClient.ICustomRenderer renderer) {
        this.itemRenderers.put(item, renderer);
    }

    protected CustomItemBakedModel getItemBakedModel() {
        if (this.itemBakedModel == null) {
            this.itemBakedModel = new CustomItemBakedModel();
        }
        return this.itemBakedModel;
    }

    protected void registerDefaultModelLocations() {
        CustomItemBakedModel itemDisp = this.getItemBakedModel();
        for (Block block : ((BaseMod)this.client.base).registeredBlocks) {
            Item item = Item.func_150898_a((Block)block);
            if (this.blockNeedsCustomRendering(block)) {
                this.registerBakedModelsForBlock(block);
                if (item == null) continue;
                this.registerModelLocationForItem(item, itemDisp);
                continue;
            }
            this.registerInventoryLocationForItem(item, block.func_149739_a());
        }
        for (Item item : ((BaseMod)this.client.base).registeredItems) {
            if (this.itemNeedsCustomRendering(item)) {
                this.registerModelLocationForItem(item, itemDisp);
                continue;
            }
            this.registerInventoryLocationForItem(item, item.func_77658_a());
        }
    }

    protected void registerBakedModelsForBlock(Block block) {
        ModelLoader.setCustomStateMapper((Block)block, (IStateMapper)this.blockStateMapper);
        for (IBlockState state : block.func_176194_O().func_177619_a()) {
            ModelResourceLocation location = this.blockStateMapper.func_178132_a(state);
            BlockParticleModel model = new BlockParticleModel(state, location);
            if (this.debugModelRegistration) {
                System.out.printf("BaseModClient.registerBakedModelsForBlock: Squirrelling %s --> %s\n", location, model);
            }
            this.bakedModels.add(model);
        }
    }

    protected boolean blockNeedsCustomRendering(Block block) {
        return this.blockRenderers.containsKey(block) || this.specifiesTextures(block);
    }

    protected boolean itemNeedsCustomRendering(Item item) {
        return this.itemRenderers.containsKey(item) || this.specifiesTextures(item);
    }

    protected boolean specifiesTextures(Object obj) {
        return obj instanceof BaseMod.ITextureConsumer && ((BaseMod.ITextureConsumer)obj).getTextureNames() != null;
    }

    protected void registerModelLocationForItem(Item item, CustomItemBakedModel disp) {
        this.registerModelLocationForSubtypes(item, disp.location);
    }

    protected void registerInventoryLocationForItem(Item item, String extdName) {
        String name = extdName.substring(5);
        this.registerModelLocationForSubtypes(item, new ModelResourceLocation(name, "inventory"));
    }

    protected void registerModelLocationForSubtypes(Item item, ModelResourceLocation location) {
        int numVariants = this.getNumItemSubtypes(item);
        if (this.debugModelRegistration) {
            System.out.printf("BaseModClient: Registering model location %s for %d subtypes of %s\n", location, numVariants, item.func_77658_a());
        }
        for (int i = 0; i < numVariants; ++i) {
            ModelLoader.setCustomModelResourceLocation((Item)item, (int)i, (ModelResourceLocation)location);
        }
    }

    private int getNumBlockSubtypes(Block block) {
        if (block instanceof BaseMod.IBlock) {
            return ((BaseMod.IBlock)block).getNumSubtypes();
        }
        return 1;
    }

    private int getNumItemSubtypes(Item item) {
        if (item instanceof BaseMod.IItem) {
            return ((BaseMod.IItem)item).getNumSubtypes();
        }
        if (item instanceof ItemBlock) {
            return this.getNumBlockSubtypes(Block.func_149634_a((Item)item));
        }
        return 1;
    }

    protected BaseModClient.ICustomRenderer getCustomRenderer(IBlockAccess world, BlockPos pos, IBlockState state) {
        Block block = state.func_177230_c();
        BaseModClient.ICustomRenderer rend = this.blockRenderers.get(block);
        if (rend == null && block instanceof BaseMod.IBlock) {
            IBlockState astate = block.func_176221_a(state, world, pos);
            rend = this.getCustomRendererForState(astate);
        }
        return rend;
    }

    protected BaseModClient.ICustomRenderer getCustomRendererForSpec(int textureType, BaseMod.ModelSpec spec) {
        BaseModClient.IModel model = this.getModel(spec.modelName);
        BaseModClient.ITexture[] textures = new BaseModClient.ITexture[spec.textureNames.length];
        for (int i = 0; i < textures.length; ++i) {
            textures[i] = this.getTexture(textureType, spec.textureNames[i]);
        }
        return new BaseModelRenderer(model, spec.origin, textures);
    }

    protected BaseModClient.ICustomRenderer getCustomRendererForState(IBlockState astate) {
        BaseMod.ModelSpec spec;
        Block block;
        BaseModClient.ICustomRenderer rend = this.stateRendererCache.get(astate);
        if (rend == null && (block = astate.func_177230_c()) instanceof BaseMod.IBlock && (spec = ((BaseMod.IBlock)block).getModelSpec(astate)) != null) {
            rend = this.getCustomRendererForSpec(0, spec);
            this.stateRendererCache.put(astate, rend);
        }
        return rend;
    }

    public static void renderBlockUsingModelSpec(BaseModClient client, IBlockAccess world, BlockPos pos, IBlockState state, BaseModClient.IRenderTarget target, BlockRenderLayer layer, Trans3 t) {
        ((BaseRenderingManager)client.renderingManager).renderBlockUsingModelSpec(world, pos, state, target, layer, t);
    }

    public void renderBlockUsingModelSpec(IBlockAccess world, BlockPos pos, IBlockState state, BaseModClient.IRenderTarget target, BlockRenderLayer layer, Trans3 t) {
        BaseModClient.ICustomRenderer rend = this.getCustomRendererForState(state);
        if (rend != null) {
            rend.renderBlock(world, pos, state, target, layer, t);
        }
    }

    public static void renderItemStackUsingModelSpec(BaseModClient client, ItemStack stack, BaseModClient.IRenderTarget target, Trans3 t) {
        ((BaseRenderingManager)client.renderingManager).renderItemStackUsingModelSpec(stack, target, t);
    }

    public void renderItemStackUsingModelSpec(ItemStack stack, BaseModClient.IRenderTarget target, Trans3 t) {
        IBlockState state = BaseBlockUtils.getBlockStateFromItemStack(stack);
        BaseMod.IBlock block = (BaseMod.IBlock)state.func_177230_c();
        BaseMod.ModelSpec spec = block.getModelSpec(state);
        BaseModClient.ICustomRenderer rend = this.getCustomRendererForSpec(0, spec);
        rend.renderItemStack(stack, target, t);
    }

    @Override
    public BaseModClient.IModel getModel(String name) {
        return ((BaseMod)this.client.base).getModel(name);
    }

    public ResourceLocation textureResourceLocation(int type, String name) {
        return ((BaseMod)this.client.base).resourceLocation(texturePrefixes[type] + name);
    }

    public BaseModClient.ITexture getTexture(int type, String name) {
        ResourceLocation loc = this.textureResourceLocation(type, name);
        return this.textureCache.get(loc);
    }

    public TextureAtlasSprite getIcon(int type, String name) {
        return ((BaseTexture.Sprite)this.getTexture((int)type, (String)name)).icon;
    }

    @SubscribeEvent
    public void onTextureStitchEventPre(TextureStitchEvent.Pre e) {
        this.textureCache.clear();
        for (Block block : ((BaseMod)this.client.base).registeredBlocks) {
            this.registerSprites(0, e.getMap(), block);
        }
        for (Item item : ((BaseMod)this.client.base).registeredItems) {
            this.registerSprites(1, e.getMap(), item);
        }
    }

    protected void registerSprites(int textureType, TextureMap reg, Object obj) {
        if (this.debugModelRegistration) {
            System.out.printf("BaseModClient.registerSprites: for %s\n", obj);
        }
        if (obj instanceof BaseMod.ITextureConsumer) {
            String[] names = ((BaseMod.ITextureConsumer)obj).getTextureNames();
            if (this.debugModelRegistration) {
                System.out.printf("BaseModClient.registerSprites: texture names = %s\n", new Object[]{names});
            }
            if (names != null) {
                this.customRenderingRequired = true;
                for (String name : names) {
                    ResourceLocation loc = this.textureResourceLocation(textureType, name);
                    if (this.textureCache.get(loc) != null) continue;
                    TextureAtlasSprite icon = reg.func_174942_a(loc);
                    BaseTexture.Sprite texture = BaseTexture.fromSprite(icon);
                    this.textureCache.put(loc, texture);
                }
            }
        }
    }

    protected IBakedModel customRenderBlockToBakedModel(IBlockAccess world, BlockPos pos, IBlockState state, BaseModClient.ICustomRenderer rend) {
        BaseBakedRenderTarget target = new BaseBakedRenderTarget(pos);
        Trans3 t = Trans3.blockCenter;
        BlockRenderLayer layer = MinecraftForgeClient.getRenderLayer();
        BlockModelShapes shapes = this.blockRendererDispatcher.func_175023_a();
        TextureAtlasSprite particle = shapes.func_178122_a(this.getBlockParticleState(state, world, pos));
        rend.renderBlock(world, pos, state, target, layer, t);
        return target.getBakedModel(particle);
    }

    public IBlockState getBlockParticleState(IBlockState state, IBlockAccess world, BlockPos pos) {
        Block block = state.func_177230_c();
        if (block instanceof BaseMod.IBlock) {
            return ((BaseMod.IBlock)block).getParticleState(world, pos);
        }
        return block.func_176221_a(state, world, pos);
    }

    public static boolean renderAlternateBlock(BaseModClient client, IBlockAccess world, BlockPos pos, IBlockState state, BaseModClient.IRenderTarget target) {
        return ((BaseRenderingManager)client.renderingManager).renderAlternateBlock(world, pos, state, target);
    }

    public boolean renderAlternateBlock(IBlockAccess world, BlockPos pos, IBlockState state, BaseModClient.IRenderTarget target) {
        Block block = state.func_177230_c();
        if (!block.hasTileEntity(state)) {
            try {
                BufferBuilder tess = ((BaseWorldRenderTarget)target).getWorldRenderer();
                return this.blockRendererDispatcher.func_175018_a(state, pos, world, tess);
            }
            catch (Exception e) {
                return false;
            }
        }
        return false;
    }

    @SubscribeEvent
    public void onModelBakeEvent(ModelBakeEvent event) {
        if (this.debugModelRegistration) {
            System.out.printf("BaseModClient.ModelBakeEvent\n", new Object[0]);
        }
        this.getItemBakedModel().install(event);
        for (CustomBakedModel model : this.bakedModels) {
            if (this.debugModelRegistration) {
                System.out.printf("BaseModClient.onModelBakeEvent: Installing %s --> %s\n", model.location, model);
            }
            model.install(event);
        }
    }

    protected void enableCustomRendering() {
        Minecraft mc = Minecraft.func_71410_x();
        this.blockRendererDispatcher = mc.func_175602_ab();
    }

    protected class CustomItemBakedModel
    extends CustomBakedModel {
        protected ItemOverrideList itemOverrideList;

        public CustomItemBakedModel() {
            this.itemOverrideList = new CustomItemRenderOverrideList();
            this.location = BaseRenderingManager.this.client.modelResourceLocation("__custitem__", "");
        }

        public ItemOverrideList func_188617_f() {
            return this.itemOverrideList;
        }
    }

    protected class CustomItemRenderOverrideList
    extends ItemOverrideList {
        public CustomItemRenderOverrideList() {
            super((List)ImmutableList.of());
        }

        public IBakedModel handleItemState(IBakedModel originalModel, ItemStack stack, World world, EntityLivingBase entity) {
            Block block;
            BaseMod.ModelSpec spec;
            Item item = stack.func_77973_b();
            BaseModClient.ICustomRenderer rend = BaseRenderingManager.this.itemRenderers.get(item);
            if (rend == null && item instanceof BaseMod.IItem && (spec = ((BaseMod.IItem)item).getModelSpec(stack)) != null) {
                rend = BaseRenderingManager.this.getCustomRendererForSpec(1, spec);
            }
            if (rend == null && (block = Block.func_149634_a((Item)item)) != null) {
                rend = BaseRenderingManager.this.getCustomRendererForState(block.func_176223_P());
            }
            if (rend != null) {
                BaseBakedRenderTarget target = new BaseBakedRenderTarget();
                rend.renderItemStack(stack, target, itemTrans);
                return target.getBakedModel();
            }
            return null;
        }
    }

    protected class BlockParticleModel
    extends CustomBakedModel {
        protected IBlockState state;

        public BlockParticleModel(IBlockState state, ModelResourceLocation location) {
            this.state = state;
            this.location = location;
        }

        public ItemOverrideList func_188617_f() {
            return null;
        }

        @Override
        public TextureAtlasSprite func_177554_e() {
            String[] textures;
            Block block = this.state.func_177230_c();
            if (block instanceof BaseMod.IBlock && (textures = ((BaseMod.IBlock)block).getTextureNames()) != null && textures.length > 0) {
                return BaseRenderingManager.this.getIcon(0, textures[0]);
            }
            return null;
        }
    }

    protected abstract class CustomBakedModel
    implements IBakedModel {
        public ModelResourceLocation location;

        protected CustomBakedModel() {
        }

        public void install(ModelBakeEvent event) {
            if (BaseRenderingManager.this.debugModelRegistration) {
                System.out.printf("BaseModClient: Installing %s at %s\n", this, this.location);
            }
            event.getModelRegistry().func_82595_a((Object)this.location, (Object)this);
        }

        public List<BakedQuad> func_188616_a(IBlockState state, EnumFacing side, long rand) {
            return null;
        }

        public boolean func_177555_b() {
            return false;
        }

        public boolean func_177556_c() {
            return false;
        }

        public boolean func_188618_c() {
            return false;
        }

        public TextureAtlasSprite func_177554_e() {
            return null;
        }

        public ItemCameraTransforms func_177552_f() {
            return null;
        }
    }

    protected static class CustomBlockStateMapper
    extends DefaultStateMapper {
        protected CustomBlockStateMapper() {
        }

        public ModelResourceLocation func_178132_a(IBlockState state) {
            return super.func_178132_a(state);
        }
    }
}

