/*
 * Decompiled with CFR 0.152.
 */
package com.endertech.minecraft.mods.adpother.transformers;

import com.endertech.minecraft.forge.coremod.ForgeClassTransformer;
import com.endertech.minecraft.forge.coremod.InstructList;
import com.endertech.minecraft.forge.coremod.descriptors.Descriptor;
import com.endertech.minecraft.forge.coremod.descriptors.Types;
import com.endertech.minecraft.forge.coremod.signatures.FieldSignature;
import com.endertech.minecraft.forge.coremod.signatures.MethodSignature;
import com.endertech.minecraft.mods.adpother.transformers.Handlers;
import org.objectweb.asm.tree.MethodInsnNode;

public class TechReborn {
    private static final String TECHREBORN_TIER0 = "techreborn/tiles/tier0/";
    private static final String TECHREBORN_GENERATOR = "techreborn/tiles/generator/";

    public static class TileSolidFuelGenerator
    extends TileBase {
        @Override
        protected String getFuelFieldName() {
            return "fuelSlot";
        }

        @Override
        protected String getClassPath() {
            return TechReborn.TECHREBORN_GENERATOR;
        }
    }

    public static class TileIronAlloyFurnace
    extends TileBase {
        @Override
        protected String getFuelFieldName() {
            return "fuel";
        }

        @Override
        protected String getClassPath() {
            return TechReborn.TECHREBORN_TIER0;
        }
    }

    public static class TileIronFurnace
    extends TileBase {
        @Override
        protected String getFuelFieldName() {
            return "fuelslot";
        }

        @Override
        protected String getClassPath() {
            return TechReborn.TECHREBORN_TIER0;
        }
    }

    private static abstract class TileBase
    extends ForgeClassTransformer {
        private final String className = this.getClassPath() + ((Object)((Object)this)).getClass().getSimpleName();
        protected final MethodSignature target = MethodSignature.I_TICKABLE_UPDATE.with(this.className);
        protected final MethodSignature targetNode = MethodSignature.I_INVENTORY_DECR_STACK_SIZE.with(this.className);
        protected final FieldSignature fieldFuelSlot;
        protected final MethodSignature getStackInSlot;

        private TileBase() {
            this.fieldFuelSlot = FieldSignature.of((String)this.className, (String)this.getFuelFieldName(), (Descriptor)Types.INT.descriptor);
            this.getStackInSlot = MethodSignature.I_INVENTORY_GET_STACK_IN_SLOT.with(this.className);
        }

        protected abstract String getFuelFieldName();

        protected abstract String getClassPath();

        protected MethodSignature getTargetMethod() {
            return this.target;
        }

        protected boolean isProperInstruction(MethodInsnNode node) {
            return this.targetNode.complyWith(node);
        }

        protected boolean shouldSearchNextInstruction(MethodInsnNode lastProperNode) {
            return false;
        }

        public boolean isCompatibilityMode() {
            return true;
        }

        protected void injectInstructions(InstructList instructions) {
            instructions.dup().loadThis().swap().invokeStatic(this.getHandler()).insertAfter();
        }

        protected MethodSignature getHandler() {
            return Handlers.ON_FUEL_BURNED_BY_TILE;
        }
    }
}

