/*
 * Decompiled with CFR 0.152.
 */
package com.endertech.minecraft.mods.adpother.transformers;

import com.endertech.minecraft.forge.coremod.ForgeClassTransformer;
import com.endertech.minecraft.forge.coremod.InstructList;
import com.endertech.minecraft.forge.coremod.descriptors.Classes;
import com.endertech.minecraft.forge.coremod.descriptors.Descriptor;
import com.endertech.minecraft.forge.coremod.descriptors.MethodDescriptor;
import com.endertech.minecraft.forge.coremod.descriptors.Types;
import com.endertech.minecraft.forge.coremod.signatures.MethodSignature;
import com.endertech.minecraft.mods.adpother.transformers.Handlers;
import org.objectweb.asm.tree.MethodInsnNode;

public class FurnaceOverhaul {
    private static final String CLASS_NAME = "cazador.furnaceoverhaul.tile.TileEntityIronFurnace";

    public static class Burning
    extends ForgeClassTransformer {
        private final MethodSignature targetMethod;
        private boolean liquidFuel;
        private int matchesCount;
        private boolean shouldSearchNext;

        public Burning() {
            this.targetMethod = MethodSignature.of((String)FurnaceOverhaul.CLASS_NAME, (String)"burnFuel", (MethodDescriptor)MethodDescriptor.VOID.withParameters(new Descriptor[]{Classes.ITEM_STACK.descriptor, Types.BOOLEAN.descriptor}));
            this.liquidFuel = true;
            this.matchesCount = 0;
            this.shouldSearchNext = true;
        }

        protected MethodSignature getTargetMethod() {
            return this.targetMethod;
        }

        protected MethodSignature getHandler() {
            return this.liquidFuel ? Handlers.ON_FLUID_FUEL_STACK_BURNED_BY_TILE_AMOUNT : Handlers.ON_FUEL_BURNED_BY_TILE;
        }

        protected boolean isProperInstruction(MethodInsnNode instruct) {
            if (this.liquidFuel) {
                if (MethodSignature.FLUID_TANK_GET_FLUID.complyWith(instruct)) {
                    ++this.matchesCount;
                    return this.matchesCount == 3;
                }
            } else {
                return MethodSignature.ITEM_STACK_SHRINK.complyWith(instruct);
            }
            return false;
        }

        protected boolean shouldSearchNextInstruction(MethodInsnNode lastProperInstruct) {
            return this.shouldSearchNext;
        }

        protected void injectInstructions(InstructList instructions) {
            if (this.liquidFuel) {
                instructions.dup().loadThis().swap().pushInt(1).invokeStatic(this.getHandler()).insertAfter();
                this.liquidFuel = false;
            } else {
                instructions.loadThis().loadObjFrom(1, "fuel").invokeStatic(this.getHandler()).insertBefore();
                this.shouldSearchNext = false;
            }
        }

        public boolean isCompatibilityMode() {
            return true;
        }
    }

    public static class Smelting
    extends ForgeClassTransformer {
        private final MethodSignature targetMethod = MethodSignature.of((String)"cazador.furnaceoverhaul.tile.TileEntityIronFurnace", (String)"smeltItem", (MethodDescriptor)MethodDescriptor.VOID);

        protected MethodSignature getTargetMethod() {
            return this.targetMethod;
        }

        protected MethodSignature getHandler() {
            return Handlers.ON_FUEL_BURNED_BY_TILE;
        }

        protected boolean isProperInstruction(MethodInsnNode instruct) {
            return MethodSignature.ITEM_STACK_SHRINK.complyWith(instruct);
        }

        protected boolean shouldSearchNextInstruction(MethodInsnNode lastProperInstruct) {
            return false;
        }

        protected void injectInstructions(InstructList instructions) {
            instructions.swap().dup().loadThis().swap().invokeStatic(this.getHandler()).swap().insertBefore();
        }

        public boolean isCompatibilityMode() {
            return true;
        }
    }
}

