/*
 * Decompiled with CFR 0.152.
 */
package com.endertech.minecraft.mods.adpother.sources;

import com.endertech.common.Args;
import com.endertech.common.FloatBounds;
import com.endertech.minecraft.forge.configs.ForgeConfig;
import com.endertech.minecraft.forge.configs.UnitConfig;
import com.endertech.minecraft.forge.units.RelatedUnit;
import com.endertech.minecraft.forge.units.UnitId;
import com.endertech.minecraft.forge.world.ForgeWorld;
import com.endertech.minecraft.mods.adpother.Main;
import com.endertech.minecraft.mods.adpother.blocks.Pollutant;
import com.endertech.minecraft.mods.adpother.emissions.Emission;
import com.endertech.minecraft.mods.adpother.emissions.Emissions;
import com.endertech.minecraft.mods.adpother.pollution.ChunkPollution;
import com.endertech.minecraft.mods.adpother.pollution.WorldData;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class SourceBase
extends RelatedUnit {
    private final Map<Pollutant<?>, Float> emissionMap = new HashMap();
    private boolean enabled = true;

    public SourceBase(UnitConfig config, UnitId id, Emissions emissions) {
        super(config, id);
        if (config != null) {
            config.setCategoryComment(Emission.CATEGORY, "Defines the amount of emissions (in blocks with light density) formed by combustion of this fuel or random update tick of this emitter.\nSet the value to 0 for disabling emissions from this source.");
        }
        for (Pollutant pollutant : Main.getPollutants().getAll()) {
            float amount = 0.0f;
            for (Emission emission : emissions.get()) {
                if (pollutant != emission.getPollutant()) continue;
                amount = emission.getAmount();
                break;
            }
            if ((amount = ForgeConfig.getFloat((ForgeConfig)config, (String)Emission.CATEGORY, (String)pollutant.getId().getRegName(), (float)amount, (FloatBounds)new FloatBounds(Float.valueOf(0.0f), Float.valueOf(32.0f)), (String)"")) == 0.0f) continue;
            this.emissionMap.put(pollutant, Float.valueOf(amount));
        }
        this.saveConfig();
    }

    public float getEmissionOf(Pollutant<?> pollutant) {
        return this.emissionMap.getOrDefault(pollutant, Float.valueOf(0.0f)).floatValue();
    }

    public Set<Pollutant<?>> getPollutants() {
        return Collections.unmodifiableSet(this.emissionMap.keySet());
    }

    public void emitAt(World world, BlockPos pos) {
        this.emitAt(world, pos, 1.0f);
    }

    public void emitAt(World world, BlockPos pos, float factor) {
        if (this.isEnabled() && ForgeWorld.isServerSide((World)world)) {
            ChunkPollution pollution = WorldData.getChunkPollution(world, pos);
            pollution.increaseBy(this, factor, world, pos);
        }
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public String toString() {
        return ((Object)((Object)this)).getClass().getSimpleName() + Args.group((Object[])new Object[]{Args.get((String)"enabled", (Object)this.isEnabled()), Args.get((String)"id", (Object)this.getRelatedId()), Args.get((String)"emissionMap", this.emissionMap)});
    }
}

