/*
 * Decompiled with CFR 0.152.
 */
package com.endertech.minecraft.mods.adpother.pollution;

import com.endertech.common.CommonMath;
import com.endertech.minecraft.forge.api.ISmokeContainer;
import com.endertech.minecraft.forge.world.ForgeWorld;
import com.endertech.minecraft.mods.adpother.pollution.IFilter;
import net.minecraft.block.Block;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public interface IPurifier {
    public boolean hasProperInput(World var1, BlockPos var2);

    public boolean hasProperOutput(World var1, BlockPos var2);

    public BlockPos getOutputPos(World var1, BlockPos var2);

    public BlockPos getPumpPos(World var1, BlockPos var2);

    default public boolean isActive(World world, BlockPos filterPos) {
        BlockPos pumpPos = this.getPumpPos(world, filterPos);
        return this.hasActivePump(world, pumpPos) && this.hasProperInput(world, pumpPos) && this.hasActiveFilter(world, filterPos) && this.hasProperOutput(world, this.getOutputPos(world, filterPos));
    }

    default public boolean hasActiveFilter(World world, BlockPos filterPos) {
        Block block = world.func_180495_p(filterPos).func_177230_c();
        return block instanceof IFilter && block instanceof ISmokeContainer && ((ISmokeContainer)block).isActive(world, filterPos);
    }

    default public boolean hasActivePump(World world, BlockPos pumpPos) {
        return ForgeWorld.SmokeContainers.isActivePump((World)world, (BlockPos)pumpPos);
    }

    default public void spawnParticle(World world, BlockPos filterPos, EnumParticleTypes particleType) {
        BlockPos pos = this.getOutputPos(world, filterPos);
        world.func_175688_a(particleType, (double)pos.func_177958_n() + CommonMath.Random.between((double)0.4, (double)0.6), (double)pos.func_177956_o() + CommonMath.Random.between((double)0.0, (double)0.6), (double)pos.func_177952_p() + CommonMath.Random.between((double)0.4, (double)0.6), 0.0, 0.0, 0.0, new int[0]);
    }
}

