/*
 * Decompiled with CFR 0.152.
 */
package com.endertech.minecraft.mods.adpother.config;

import com.endertech.minecraft.forge.configs.ForgeConfig;
import com.endertech.minecraft.forge.math.Percentage;
import com.endertech.minecraft.forge.units.UnitId;
import com.endertech.minecraft.mods.adpother.config.AbstractParsableList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.common.Loader;

public class ImmuneEntities
extends AbstractParsableList {
    public static final String FORMAT_DESCRIPTION = "Format: entityId [, immunityPercentage%]\nExample: minecraft:zombie_pigman, 99%\nGives complete immunity if the percentage omitted.";
    protected final Map<ResourceLocation, Percentage> entities = new HashMap<ResourceLocation, Percentage>();
    protected final String comment;

    public ImmuneEntities(ForgeConfig config, String category, String comment) {
        super(config, category, "immuneEntities", new String[0]);
        this.comment = comment;
    }

    @Override
    protected String getComment() {
        return this.comment + "\n" + FORMAT_DESCRIPTION;
    }

    @Override
    protected void parseConfigValues() {
        this.entities.clear();
        for (String string : this.configValues) {
            List<String> split = this.splitArgs(string);
            UnitId id = UnitId.from((String)split.get(0));
            Percentage immunity = Percentage.HUNDRED;
            boolean error = id.isEmpty();
            if (split.size() > 1) {
                try {
                    immunity = Percentage.parse((String)split.get(1));
                }
                catch (Exception e) {
                    error = true;
                }
            }
            if (!error) {
                if (!Loader.isModLoaded((String)id.getModId())) continue;
                this.entities.put(id.toResLoc(), immunity);
                continue;
            }
            this.logParsingError(string);
        }
    }

    public boolean contain(Entity entity) {
        if (this.entities.isEmpty()) {
            return false;
        }
        ResourceLocation key = EntityList.func_191301_a((Entity)entity);
        return key != null && this.entities.containsKey(key);
    }

    public Percentage getImmunityFor(Entity entity) {
        Percentage immunity = Percentage.ZERO;
        if (this.entities.isEmpty()) {
            return immunity;
        }
        ResourceLocation key = EntityList.func_191301_a((Entity)entity);
        if (key != null) {
            immunity = this.entities.getOrDefault(key, immunity);
        }
        return immunity;
    }

    public boolean isImmune(Entity entity) {
        return this.getImmunityFor(entity).takeChance();
    }

    public ImmuneEntities loadEntities() {
        this.loadData();
        return this;
    }
}

