/*
 * Decompiled with CFR 0.152.
 */
package com.troblecodings.signals.parser;

import com.troblecodings.signals.parser.LogicalParserException;
import com.troblecodings.signals.parser.interm.EvaluationLevel;
import com.troblecodings.signals.parser.interm.IntermidiateNode;
import java.util.ArrayList;
import java.util.List;
import java.util.Stack;
import java.util.stream.Collectors;

public class IntermidiateLogic {
    private final Stack<List<IntermidiateNode>> stackNodes = new Stack();

    public IntermidiateLogic() {
        this.push();
    }

    public void push() {
        this.stackNodes.add(new ArrayList());
    }

    public IntermidiateNode pop() {
        if (this.stackNodes.isEmpty()) {
            throw new LogicalParserException("Stack empty! Maybe too many ')' at the end?");
        }
        List<IntermidiateNode> node = this.stackNodes.pop();
        for (EvaluationLevel level : EvaluationLevel.values()) {
            if (level.equals((Object)EvaluationLevel.PRELEVEL)) continue;
            ArrayList<IntermidiateNode> nextNode = new ArrayList<IntermidiateNode>();
            for (int i = 0; i < node.size(); ++i) {
                IntermidiateNode current = node.get(i);
                if (!current.getLevel().equals((Object)level)) {
                    nextNode.add(current);
                    continue;
                }
                int nextIndex = i + 1;
                if (nextIndex >= node.size()) {
                    throw new LogicalParserException("Expected more input at the end!");
                }
                IntermidiateNode next = node.get(nextIndex);
                if (current.next(next)) {
                    nextNode.add(current.getFinished());
                    ++i;
                    continue;
                }
                int prevIndex = nextNode.size() - 1;
                if (prevIndex < 0) {
                    throw new LogicalParserException("Expected more input at the begining!");
                }
                IntermidiateNode last = (IntermidiateNode)nextNode.get(prevIndex);
                if (!current.combine(last, next)) continue;
                nextNode.set(prevIndex, current.getFinished());
                ++i;
            }
            node = nextNode;
        }
        if (node.size() != 1) {
            throw new LogicalParserException(String.format("Could not merge all nodes! Elements: %n%s", node.stream().map(n -> n.toString()).collect(Collectors.joining(System.lineSeparator()))));
        }
        if (!this.stackNodes.isEmpty()) {
            ((List)this.stackNodes.lastElement()).add(node.get(0));
        }
        return node.get(0);
    }

    public void add(IntermidiateNode node) {
        ((List)this.stackNodes.lastElement()).add(node);
    }
}

