/*
 * Decompiled with CFR 0.152.
 */
package com.troblecodings.signals.models;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.mojang.realmsclient.util.Pair;
import com.troblecodings.signals.core.SignalAngel;
import com.troblecodings.signals.models.ModelInfoWrapper;
import com.troblecodings.signals.models.SignalModelLoaderInfo;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Predicate;
import javax.vecmath.AxisAngle4f;
import javax.vecmath.Matrix4f;
import javax.vecmath.Vector3f;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.block.model.MultipartBakedModel;
import net.minecraft.client.renderer.block.model.SimpleBakedModel;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.vertex.VertexFormat;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.model.IModel;
import net.minecraftforge.client.model.ModelLoaderRegistry;
import net.minecraftforge.common.model.IModelState;
import net.minecraftforge.common.model.TRSRTransformation;
import net.minecraftforge.common.property.IExtendedBlockState;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class SignalCustomModel
implements IModel {
    private final HashMap<Predicate<ModelInfoWrapper>, Pair<IModel, Vector3f>> modelCache = new HashMap();
    private List<ResourceLocation> textures = new ArrayList<ResourceLocation>();
    private IBakedModel cachedModel = null;
    private SignalAngel angel = SignalAngel.ANGEL0;
    private final Matrix4f rotation;

    public SignalCustomModel(List<SignalModelLoaderInfo> infos, SignalAngel facing) {
        infos.forEach(info -> this.register(info.name, info.state, info.x, info.y, info.z, info.retexture));
        this.textures = ImmutableList.copyOf(this.textures);
        this.angel = facing;
        Matrix4f mat = new Matrix4f();
        mat.setIdentity();
        mat.setRotation(new AxisAngle4f(0.0f, 1.0f, 0.0f, (float)this.angel.getRadians()));
        this.rotation = mat;
    }

    private Vector3f multiply(Vector3f vec, Matrix4f mat) {
        return new Vector3f(vec.getX() * mat.getM00() + vec.getY() * mat.getM01() + vec.getZ() * mat.getM02() + mat.getM03(), vec.getX() * mat.getM10() + vec.getY() * mat.getM11() + vec.getZ() * mat.getM12() + mat.getM13(), vec.getX() * mat.getM20() + vec.getY() * mat.getM21() + vec.getZ() * mat.getM22() + mat.getM23());
    }

    private BakedQuad transform(BakedQuad quad) {
        int[] data = quad.func_178209_a();
        VertexFormat format = quad.getFormat();
        for (int i = 0; i < data.length - 3; i += format.func_181719_f()) {
            Vector3f vector = new Vector3f(Float.intBitsToFloat(data[i]) - 0.5f, Float.intBitsToFloat(data[i + 1]), Float.intBitsToFloat(data[i + 2]) - 0.5f);
            Vector3f out = this.multiply(vector, this.rotation);
            data[i] = Float.floatToRawIntBits(out.x + 0.5f);
            data[i + 1] = Float.floatToRawIntBits(out.y);
            data[i + 2] = Float.floatToRawIntBits(out.z + 0.5f);
        }
        return quad;
    }

    private IBakedModel transform(IBakedModel model) {
        ImmutableList.Builder outgoing = ImmutableList.builder();
        for (BakedQuad quad : model.func_188616_a(null, null, 0L)) {
            outgoing.add((Object)this.transform(quad));
        }
        ImmutableMap.Builder faceOutgoing = ImmutableMap.builder();
        for (EnumFacing face : EnumFacing.field_82609_l) {
            ImmutableList.Builder current = ImmutableList.builder();
            for (BakedQuad quad : model.func_188616_a(null, face, 0L)) {
                current.add((Object)this.transform(quad));
            }
            faceOutgoing.put((Object)face, (Object)current.build());
        }
        return new SimpleBakedModel((List)outgoing.build(), (Map)faceOutgoing.build(), model.func_177555_b(), model.func_177556_c(), model.func_177554_e(), model.func_177552_f(), model.func_188617_f());
    }

    public IBakedModel bake(IModelState state, VertexFormat format, Function<ResourceLocation, TextureAtlasSprite> bakedTextureGetter) {
        if (this.cachedModel == null) {
            MultipartBakedModel.Builder build = new MultipartBakedModel.Builder();
            this.modelCache.forEach((pr, m) -> {
                IModel model = (IModel)m.first();
                Vector3f f = (Vector3f)m.second();
                TRSRTransformation baseState = new TRSRTransformation(f, null, null, null);
                build.func_188648_a(blockstate -> pr.test(new ModelInfoWrapper((IExtendedBlockState)blockstate)), this.transform(model.bake((IModelState)baseState, format, bakedTextureGetter)));
            });
            this.cachedModel = build.func_188647_a();
            return this.cachedModel;
        }
        return this.cachedModel;
    }

    public IModelState getDefaultState() {
        return TRSRTransformation.identity();
    }

    public Collection<ResourceLocation> getTextures() {
        return this.textures;
    }

    protected void register(String name, Predicate<ModelInfoWrapper> state, float x, float y, float z, Map<String, String> map) {
        IModel m = ModelLoaderRegistry.getModelOrLogError((ResourceLocation)new ResourceLocation("opensignals", "block/" + name), (String)("Couldn't find " + name));
        m = m.smoothLighting(false);
        if (map != null && !map.isEmpty()) {
            ImmutableMap.Builder build = ImmutableMap.builder();
            for (Map.Entry<String, String> entry : map.entrySet()) {
                build.put((Object)entry.getKey(), (Object)entry.getValue());
            }
            m = m.retexture(build.build());
        }
        m.getTextures().stream().filter(rs -> !this.textures.contains(rs)).forEach(this.textures::add);
        this.modelCache.put(state, (Pair<IModel, Vector3f>)Pair.of((Object)m, (Object)new Vector3f(x, y, z)));
    }
}

