/*
 * Decompiled with CFR 0.152.
 */
package com.troblecodings.signals.handler;

import com.troblecodings.signals.handler.SignalStateFileV2;
import com.troblecodings.signals.handler.SignalStatePosV2;
import java.nio.ByteBuffer;
import java.nio.file.Path;
import net.minecraft.util.math.BlockPos;

public class NameHandlerFileV2
extends SignalStateFileV2 {
    public NameHandlerFileV2(Path path) {
        super(path);
    }

    public synchronized SignalStatePosV2 createState(BlockPos pos, String name) {
        if (name.length() > 128) {
            throw new IllegalArgumentException("Max Name length is 128!");
        }
        return this.create(pos, name.getBytes());
    }

    public synchronized void writeString(SignalStatePosV2 pos, String name) {
        if (name.length() > 128) {
            throw new IllegalArgumentException("Max Name length is 128!");
        }
        this.write(pos, ByteBuffer.allocate(256).put(name.getBytes()));
    }

    public synchronized String getString(BlockPos pos) {
        return this.getString(this.find(pos));
    }

    public synchronized String getString(SignalStatePosV2 pos) {
        if (pos == null) {
            return "";
        }
        return new String(this.read(pos).array()).trim();
    }
}

