/*
 * Decompiled with CFR 0.152.
 */
package com.troblecodings.signals.handler;

import com.google.common.collect.ImmutableMap;
import com.troblecodings.core.WriteBuffer;
import com.troblecodings.core.interfaces.INetworkSync;
import com.troblecodings.signals.OpenSignalsMain;
import com.troblecodings.signals.blocks.Signal;
import com.troblecodings.signals.core.PathGetter;
import com.troblecodings.signals.core.StateInfo;
import com.troblecodings.signals.handler.NameHandlerFile;
import com.troblecodings.signals.handler.NameHandlerFileV2;
import com.troblecodings.signals.handler.SignalStateHandler;
import com.troblecodings.signals.handler.SignalStateInfo;
import com.troblecodings.signals.handler.SignalStatePosV2;
import com.troblecodings.signals.tileentitys.RedstoneIOTileEntity;
import com.troblecodings.signals.tileentitys.SignalTileEntity;
import io.netty.buffer.Unpooled;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.network.PacketBuffer;
import net.minecraft.network.play.client.CPacketCustomPayload;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraft.world.chunk.Chunk;
import net.minecraftforge.event.world.ChunkWatchEvent;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.event.FMLServerStoppingEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.PlayerEvent;
import net.minecraftforge.fml.common.network.FMLEventChannel;
import net.minecraftforge.fml.common.network.FMLNetworkEvent;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.network.internal.FMLProxyPacket;

public final class NameHandler
implements INetworkSync {
    private static ExecutorService writeService = Executors.newFixedThreadPool(5);
    private static final Map<StateInfo, String> ALL_NAMES = new HashMap<StateInfo, String>();
    private static final Map<World, NameHandlerFileV2> ALL_LEVEL_FILES = new HashMap<World, NameHandlerFileV2>();
    private static final Map<StateInfo, Integer> LOAD_COUNTER = new HashMap<StateInfo, Integer>();
    private static final String CHANNELNAME = "namehandlernet";
    private static FMLEventChannel channel;

    public static void init() {
        channel = NetworkRegistry.INSTANCE.newEventDrivenChannel(CHANNELNAME);
        channel.register((Object)new NameHandler());
    }

    @Mod.EventHandler
    public static void onServerStop(FMLServerStoppingEvent event) {
        writeService.shutdown();
        try {
            writeService.awaitTermination(10L, TimeUnit.MINUTES);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        writeService = Executors.newFixedThreadPool(5);
    }

    public static void registerToNetworkChannel(Object obj) {
        channel.register(obj);
    }

    public static void createName(StateInfo info, String name) {
        if (info.world.field_72995_K || name == null) {
            return;
        }
        new Thread(() -> {
            NameHandler.setNameForNonSignal(info, name);
            NameHandler.createToFile(info, name);
        }, "OSNameHandler:createName").start();
    }

    public static void setNameForSignal(StateInfo info, String name) {
        if (info.world.field_72995_K || name == null) {
            return;
        }
        NameHandler.setNameForNonSignal(info, name);
        Block block = info.world.func_180495_p(info.pos).func_177230_c();
        if (block instanceof Signal) {
            SignalStateHandler.setState(new SignalStateInfo(info.world, info.pos, (Signal)block), Signal.CUSTOMNAME, "true");
        }
    }

    public static void setNameForNonSignal(StateInfo info, String name) {
        if (info.world.field_72995_K || name == null) {
            return;
        }
        new Thread(() -> {
            Map<StateInfo, String> map = ALL_NAMES;
            synchronized (map) {
                ALL_NAMES.put(info, name);
            }
            NameHandler.sendToAll(info, name);
        }, "OSNameHandler:setName").start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getName(StateInfo info) {
        if (info.world.field_72995_K) {
            return "";
        }
        Map<StateInfo, String> map = ALL_NAMES;
        synchronized (map) {
            String name = ALL_NAMES.get(info);
            if (name == null) {
                return "";
            }
            return name;
        }
    }

    private static void sendToAll(StateInfo info, String name) {
        ByteBuffer buffer = NameHandler.packToBuffer(info.pos, name);
        info.world.field_73010_i.forEach(player -> NameHandler.sendTo(player, buffer));
    }

    private static ByteBuffer packToBuffer(BlockPos pos, String name) {
        byte[] bytes = name.getBytes();
        WriteBuffer buffer = new WriteBuffer();
        buffer.putBlockPos(pos);
        buffer.putByte((byte)bytes.length);
        for (byte b : bytes) {
            buffer.putByte(b);
        }
        return buffer.build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setRemoved(StateInfo info) {
        NameHandlerFileV2 file;
        Map<StateInfo, String> map = ALL_NAMES;
        synchronized (map) {
            ALL_NAMES.remove(info);
        }
        Object object = ALL_LEVEL_FILES;
        synchronized (object) {
            file = ALL_LEVEL_FILES.get(info.world);
        }
        object = file;
        synchronized (object) {
            file.deleteIndex(info.pos);
        }
    }

    public static void sendRemoved(StateInfo info) {
        WriteBuffer buffer = new WriteBuffer();
        buffer.putBlockPos(info.pos);
        buffer.putByte((byte)-1);
        info.world.field_73010_i.forEach(player -> NameHandler.sendTo(player, buffer.getBuildedBuffer()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void migrateWorldFilesToV2(World world) {
        NameHandlerFileV2 newFile;
        Path oldPath = Paths.get("osfiles/namefiles/" + ((WorldServer)world).func_73046_m().func_70005_c_().replace(":", "").replace("/", "").replace("\\", "") + "/" + ((WorldServer)world).field_73011_w.func_186058_p().func_186065_b().replace(":", ""), new String[0]);
        if (!Files.exists(oldPath, new LinkOption[0])) {
            return;
        }
        OpenSignalsMain.getLogger().info("Starting Migration from NameHandlerFileV1 to NameHandlerFileV2...");
        NameHandlerFile oldFile = new NameHandlerFile(oldPath);
        Map<World, NameHandlerFileV2> map = ALL_LEVEL_FILES;
        synchronized (map) {
            newFile = ALL_LEVEL_FILES.get(world);
        }
        oldFile.getAllEntries().forEach((pos, buffer) -> newFile.create((BlockPos)pos, buffer.array()));
        OpenSignalsMain.getLogger().info("Finished Migration from NameHandlerFileV1 to NameHandlerFileV2!");
        try {
            Files.list(oldPath).forEach(path -> {
                try {
                    Files.delete(path);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            });
            Files.delete(oldPath);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SubscribeEvent
    public static void onWorldLoad(WorldEvent.Load event) {
        World world = event.getWorld();
        if (world.field_72995_K) {
            return;
        }
        Path path = PathGetter.getNewPathForFiles(world, "namefiles");
        Map<World, NameHandlerFileV2> map = ALL_LEVEL_FILES;
        synchronized (map) {
            ALL_LEVEL_FILES.put(world, new NameHandlerFileV2(path));
        }
        NameHandler.migrateWorldFilesToV2(world);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SubscribeEvent
    public static void onWorldSave(WorldEvent.Save event) {
        ImmutableMap map;
        World world = event.getWorld();
        if (world.field_72995_K) {
            return;
        }
        Map<StateInfo, String> map2 = ALL_NAMES;
        synchronized (map2) {
            map = ImmutableMap.copyOf(ALL_NAMES);
        }
        writeService.execute(() -> NameHandler.lambda$onWorldSave$8((Map)map, world));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SubscribeEvent
    public static void onWorldUnload(WorldEvent.Unload unload) {
        if (unload.getWorld().field_72995_K) {
            return;
        }
        Map<World, NameHandlerFileV2> map = ALL_LEVEL_FILES;
        synchronized (map) {
            ALL_LEVEL_FILES.remove(unload.getWorld());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void createToFile(StateInfo info, String name) {
        NameHandlerFileV2 file;
        Map<World, NameHandlerFileV2> map = ALL_LEVEL_FILES;
        synchronized (map) {
            file = ALL_LEVEL_FILES.get(info.world);
        }
        if (file == null) {
            return;
        }
        SignalStatePosV2 posInFile = file.find(info.pos);
        NameHandlerFileV2 nameHandlerFileV2 = file;
        synchronized (nameHandlerFileV2) {
            if (posInFile == null) {
                posInFile = file.createState(info.pos, name);
                return;
            }
            file.writeString(posInFile, name);
        }
    }

    @SubscribeEvent
    public static void onChunkWatch(ChunkWatchEvent.Watch event) {
        Chunk chunk = event.getChunkInstance();
        World world = chunk.func_177412_p();
        if (world == null || world.field_72995_K) {
            return;
        }
        EntityPlayerMP player = event.getPlayer();
        ArrayList<StateInfo> states = new ArrayList<StateInfo>();
        ImmutableMap.copyOf((Map)chunk.func_177434_r()).forEach((pos, tile) -> {
            if (tile instanceof SignalTileEntity || tile instanceof RedstoneIOTileEntity) {
                StateInfo info = new StateInfo(world, (BlockPos)pos);
                states.add(info);
            }
        });
        NameHandler.loadNames(states, (EntityPlayer)player);
    }

    @SubscribeEvent
    public static void onChunkUnWatch(ChunkWatchEvent.UnWatch event) {
        Chunk chunk = event.getChunkInstance();
        World world = chunk.func_177412_p();
        ArrayList<StateInfo> states = new ArrayList<StateInfo>();
        ImmutableMap.copyOf((Map)chunk.func_177434_r()).forEach((pos, tile) -> {
            if (tile instanceof SignalTileEntity || tile instanceof RedstoneIOTileEntity) {
                states.add(new StateInfo(world, (BlockPos)pos));
            }
        });
        NameHandler.unloadNames(states);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SubscribeEvent
    public static void onPlayerJoin(PlayerEvent.PlayerLoggedInEvent event) {
        ImmutableMap names;
        EntityPlayer player = event.player;
        Map<StateInfo, String> map = ALL_NAMES;
        synchronized (map) {
            names = ImmutableMap.copyOf(ALL_NAMES);
        }
        names.forEach((info, name) -> NameHandler.sendTo(player, NameHandler.packToBuffer(info.pos, name)));
    }

    private static void loadNames(List<StateInfo> infos, @Nullable EntityPlayer player) {
        if (infos == null || infos.isEmpty()) {
            return;
        }
        new Thread(() -> infos.forEach(info -> {
            String name;
            NameHandlerFileV2 file;
            Map<StateInfo, String> count;
            boolean isLoaded = false;
            Map<StateInfo, Integer> map = LOAD_COUNTER;
            synchronized (map) {
                count = LOAD_COUNTER.get(info);
                if (count != null && (Integer)((Object)count) > 0) {
                    count = (Integer)((Object)count) + 1;
                    LOAD_COUNTER.put((StateInfo)info, (Integer)((Object)count));
                    isLoaded = true;
                } else {
                    LOAD_COUNTER.put((StateInfo)info, 1);
                }
            }
            if (isLoaded) {
                String name2;
                if (player == null) {
                    return;
                }
                count = ALL_NAMES;
                synchronized (count) {
                    name2 = ALL_NAMES.getOrDefault(info, "");
                }
                if (name2.isEmpty()) {
                    return;
                }
                NameHandler.sendTo(player, NameHandler.packToBuffer(info.pos, name2));
                return;
            }
            count = ALL_LEVEL_FILES;
            synchronized (count) {
                file = ALL_LEVEL_FILES.get(info.world);
            }
            Object object = file;
            synchronized (object) {
                name = file.getString(info.pos);
            }
            object = ALL_NAMES;
            synchronized (object) {
                ALL_NAMES.put((StateInfo)info, name);
            }
            NameHandler.sendToAll(info, name);
        }), "OSNameHandler:loadNames").start();
    }

    private static void unloadNames(List<StateInfo> infos) {
        if (infos == null || infos.isEmpty() || writeService.isShutdown()) {
            return;
        }
        writeService.execute(() -> infos.forEach(info -> {
            String name;
            Map<StateInfo, Integer> map = LOAD_COUNTER;
            synchronized (map) {
                Integer count = LOAD_COUNTER.get(info);
                if (count != null && count > 1) {
                    count = count - 1;
                    LOAD_COUNTER.put((StateInfo)info, count);
                    return;
                }
                LOAD_COUNTER.remove(info);
            }
            Map<StateInfo, String> map2 = ALL_NAMES;
            synchronized (map2) {
                name = ALL_NAMES.remove(info);
            }
            if (name == null) {
                return;
            }
            NameHandler.createToFile(info, name);
        }));
    }

    private static void sendTo(EntityPlayer player, ByteBuffer buf) {
        PacketBuffer buffer = new PacketBuffer(Unpooled.copiedBuffer((ByteBuffer)((ByteBuffer)buf.position(0))));
        if (player instanceof EntityPlayerMP) {
            EntityPlayerMP server = (EntityPlayerMP)player;
            channel.sendTo(new FMLProxyPacket(buffer, CHANNELNAME), server);
        } else {
            channel.sendToServer(new FMLProxyPacket(new CPacketCustomPayload(CHANNELNAME, buffer)));
        }
    }

    @SubscribeEvent
    public void clientEvent(FMLNetworkEvent.ClientCustomPacketEvent event) {
        this.deserializeServer(event.getPacket().payload().nioBuffer());
    }

    private static /* synthetic */ void lambda$onWorldSave$8(Map map, World world) {
        map.entrySet().stream().filter(entry -> ((StateInfo)entry.getKey()).world.equals(world)).forEach(entry -> NameHandler.createToFile((StateInfo)entry.getKey(), (String)entry.getValue()));
    }
}

