/*
 * Decompiled with CFR 0.152.
 */
package com.troblecodings.signals.guis;

import com.troblecodings.guilib.ecs.entitys.UIComponent;
import com.troblecodings.guilib.ecs.entitys.UIComponentEntity;
import com.troblecodings.guilib.ecs.entitys.UIEntity;
import com.troblecodings.guilib.ecs.entitys.render.UILines;
import com.troblecodings.guilib.ecs.entitys.transform.UIIndependentTranslate;
import com.troblecodings.guilib.ecs.entitys.transform.UIRotate;
import com.troblecodings.signals.core.TrainNumber;
import com.troblecodings.signals.enums.EnumGuiMode;
import com.troblecodings.signals.guis.UITrainNumber;
import com.troblecodings.signals.signalbox.MainSignalIdentifier;
import com.troblecodings.signals.signalbox.ModeSet;
import com.troblecodings.signals.signalbox.Point;
import com.troblecodings.signals.signalbox.SignalBoxNode;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Rotation;

public class UISignalBoxTile
extends UIComponentEntity {
    public static final ResourceLocation ICON = new ResourceLocation("opensignals", "gui/textures/symbols.png");
    public static final ResourceLocation ARROW_ICON = new ResourceLocation("opensignals", "gui/textures/connection.png");
    public static final ResourceLocation SIGNALS = new ResourceLocation("opensignals", "gui/textures/signals.png");
    private SignalBoxNode node;
    private final Map<ModeSet, UIEntity> setToEntity = new HashMap<ModeSet, UIEntity>();
    private final Map<ModeSet, MainSignalIdentifier.SignalState> greenSignals = new HashMap<ModeSet, MainSignalIdentifier.SignalState>();
    private final UITrainNumber uiTrainNumber = new UITrainNumber();

    public UISignalBoxTile(SignalBoxNode node) {
        super(new UIEntity());
        this.node = node;
        if (this.node != null) {
            this.node.forEach(this::localAdd);
        }
    }

    public void setGreenSignals(List<MainSignalIdentifier> list) {
        this.greenSignals.clear();
        list.forEach(identifier -> {
            this.greenSignals.put(identifier.getModeSet(), identifier.state);
            this.updateModeSet(identifier.getModeSet());
        });
    }

    public void updateModeSet(ModeSet mode) {
        this.localRemove(mode);
        this.localAdd(mode);
        if (this.hasParent()) {
            this.update();
        }
    }

    public void setNode(SignalBoxNode node) {
        if (this.node != null) {
            this.node.forEach(this::localRemove);
        }
        this.node = node;
        if (this.node != null) {
            this.node.forEach(this::localAdd);
        }
    }

    private void localAdd(ModeSet modeSet) {
        UIEntity entity = new UIEntity();
        if (!modeSet.rotation.equals((Object)Rotation.NONE)) {
            UIRotate rotation = new UIRotate();
            rotation.setRotateZ((float)modeSet.rotation.ordinal() * 90.0f);
            entity.add(rotation);
        }
        entity.add(new UIIndependentTranslate(0.0, 0.0, 1.0));
        MainSignalIdentifier.SignalState state = this.greenSignals.getOrDefault(modeSet, MainSignalIdentifier.SignalState.RED);
        if (modeSet.mode.equals((Object)EnumGuiMode.RS)) {
            ModeSet hpMode = new ModeSet(EnumGuiMode.HP, modeSet.rotation);
            MainSignalIdentifier.SignalState hpState = this.greenSignals.getOrDefault(hpMode, MainSignalIdentifier.SignalState.RED);
            if (this.setToEntity.containsKey(hpMode)) {
                if (hpState.equals((Object)MainSignalIdentifier.SignalState.RED)) {
                    switch (state) {
                        case SUBSIDIARY_RED: 
                        case GREEN: {
                            hpState = MainSignalIdentifier.SignalState.SUBSIDIARY_RED;
                            break;
                        }
                        case SUBSIDIARY_OFF: {
                            hpState = MainSignalIdentifier.SignalState.SUBSIDIARY_OFF;
                            break;
                        }
                        default: {
                            hpState = MainSignalIdentifier.SignalState.RED;
                        }
                    }
                }
                this.greenSignals.put(hpMode, hpState);
                this.localRemove(modeSet);
                this.updateModeSet(hpMode);
                return;
            }
        }
        entity.add((UIComponent)modeSet.mode.consumer.get(state));
        this.entity.add(entity);
        this.setToEntity.put(modeSet, entity);
        this.entity.setVisible(!this.setToEntity.isEmpty());
    }

    @Override
    public void update() {
        super.update();
        this.entity.setX(this.parent.getWidth() / 2.0);
        this.entity.setY(this.parent.getHeight() / 2.0);
        this.setToEntity.values().forEach(e -> {
            e.setHeight(this.entity.getHeight());
            e.setWidth(this.entity.getWidth());
            e.update();
        });
        this.entity.findRecursive(UIIndependentTranslate.class).forEach(translate -> {
            translate.setX(-this.entity.getX());
            translate.setY(-this.entity.getY());
        });
    }

    @Override
    public void updateEvent(UIEntity.UpdateEvent event) {
        super.updateEvent(event);
        this.update();
    }

    private void localRemove(ModeSet modeSet) {
        this.entity.remove(this.setToEntity.remove(modeSet));
        this.entity.setVisible(!this.setToEntity.isEmpty());
    }

    public void add(ModeSet modeSet) {
        this.node.add(modeSet);
        this.localAdd(modeSet);
        this.update();
    }

    public boolean has(ModeSet modeSet) {
        return this.node.has(modeSet);
    }

    public void remove(ModeSet modeSet) {
        this.node.remove(modeSet);
        this.localRemove(modeSet);
    }

    public boolean isValidEnd() {
        return this.node.isValidEnd();
    }

    public boolean isValidStart() {
        return this.node.isValidStart();
    }

    public Point getPoint() {
        return this.node.getPoint();
    }

    public SignalBoxNode getNode() {
        return this.node;
    }

    public void setColor(ModeSet mode, int color) {
        UIEntity entity = this.setToEntity.get(mode);
        if (entity != null) {
            entity.findRecursive(UILines.class).forEach(lines -> lines.setColor(color));
        }
    }

    public void updateTrainNumber() {
        this.getParent().remove(this.uiTrainNumber);
        TrainNumber number = this.node.getTrainNumber();
        this.uiTrainNumber.setTrainNumber(number);
        if (!number.trainNumber.isEmpty()) {
            this.getParent().add(this.uiTrainNumber);
        }
    }
}

