/*
 * Decompiled with CFR 0.152.
 */
package com.troblecodings.signals.guis;

import com.troblecodings.core.ReadBuffer;
import com.troblecodings.core.WriteBuffer;
import com.troblecodings.guilib.ecs.ContainerBase;
import com.troblecodings.guilib.ecs.GuiInfo;
import com.troblecodings.signals.OpenSignalsMain;
import com.troblecodings.signals.core.StateInfo;
import com.troblecodings.signals.handler.SignalBoxHandler;
import com.troblecodings.signals.signalbox.Point;
import com.troblecodings.signals.signalbox.SignalBoxGrid;
import com.troblecodings.signals.signalbox.SignalBoxTileEntity;
import com.troblecodings.signals.tileentitys.IChunkLoadable;
import com.troblecodings.signals.tileentitys.PathwayRequesterTileEntity;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import net.minecraft.util.math.BlockPos;

public class PathwayRequesterContainer
extends ContainerBase
implements IChunkLoadable {
    protected final List<Point> validStarts = new ArrayList<Point>();
    protected final List<Point> validEnds = new ArrayList<Point>();
    protected PathwayRequesterTileEntity tile;
    protected Point start = null;
    protected Point end = null;
    protected BlockPos linkedPos;

    public PathwayRequesterContainer(GuiInfo info) {
        super(info);
        this.tile = (PathwayRequesterTileEntity)info.getTile();
    }

    @Override
    public void sendAllDataToRemote() {
        WriteBuffer buffer = new WriteBuffer();
        BlockPos signalBoxPos = this.tile.getLinkedSignalBox();
        buffer.putBlockPos(signalBoxPos == null ? BlockPos.field_177992_a : signalBoxPos);
        Map.Entry<Point, Point> previousPathway = this.tile.getNextPathway();
        previousPathway.getKey().writeNetwork(buffer);
        previousPathway.getValue().writeNetwork(buffer);
        if (signalBoxPos != null) {
            AtomicReference<SignalBoxGrid> grid = new AtomicReference<SignalBoxGrid>();
            grid.set(SignalBoxHandler.getGrid(new StateInfo(this.info.world, signalBoxPos)));
            if (grid.get() == null) {
                this.loadChunkAndGetTile(SignalBoxTileEntity.class, this.info.world, signalBoxPos, (tile, _u) -> grid.set(tile.getSignalBoxGrid()));
            }
            List<Point> validStarts = ((SignalBoxGrid)grid.get()).getValidStarts();
            List<Point> validEnds = ((SignalBoxGrid)grid.get()).getValidEnds();
            buffer.putByte((byte)validStarts.size());
            validStarts.forEach(point -> point.writeNetwork(buffer));
            buffer.putByte((byte)validEnds.size());
            validEnds.forEach(point -> point.writeNetwork(buffer));
        }
        OpenSignalsMain.network.sendTo(this.info.player, buffer);
    }

    @Override
    public void deserializeClient(ReadBuffer buffer) {
        this.linkedPos = buffer.getBlockPos();
        if (this.linkedPos.equals((Object)BlockPos.field_177992_a)) {
            this.linkedPos = null;
        }
        this.start = Point.of(buffer);
        this.end = Point.of(buffer);
        this.validStarts.clear();
        this.validEnds.clear();
        if (this.linkedPos == null) {
            return;
        }
        int validStartsSize = buffer.getByteToUnsignedInt();
        for (int i = 0; i < validStartsSize; ++i) {
            this.validStarts.add(Point.of(buffer));
        }
        int validEndsSize = buffer.getByteToUnsignedInt();
        for (int i = 0; i < validEndsSize; ++i) {
            this.validEnds.add(Point.of(buffer));
        }
        this.update();
    }

    @Override
    public void deserializeServer(ReadBuffer buffer) {
        Point start = Point.of(buffer);
        Point end = Point.of(buffer);
        this.tile.setNextPathway(start, end);
    }
}

