/*
 * Decompiled with CFR 0.152.
 */
package com.troblecodings.signals.guis;

import com.troblecodings.core.I18Wrapper;
import com.troblecodings.core.NBTWrapper;
import com.troblecodings.core.WriteBuffer;
import com.troblecodings.guilib.ecs.ContainerBase;
import com.troblecodings.guilib.ecs.GuiBase;
import com.troblecodings.guilib.ecs.GuiElements;
import com.troblecodings.guilib.ecs.GuiInfo;
import com.troblecodings.guilib.ecs.entitys.UIBox;
import com.troblecodings.guilib.ecs.entitys.UIEntity;
import com.troblecodings.guilib.ecs.entitys.UIEnumerable;
import com.troblecodings.guilib.ecs.entitys.UITextInput;
import com.troblecodings.guilib.ecs.entitys.render.UILabel;
import com.troblecodings.guilib.ecs.entitys.render.UIToolTip;
import com.troblecodings.guilib.ecs.entitys.transform.UIScale;
import com.troblecodings.signals.OpenSignalsMain;
import com.troblecodings.signals.SEProperty;
import com.troblecodings.signals.blocks.Signal;
import com.troblecodings.signals.core.JsonEnum;
import com.troblecodings.signals.enums.ChangeableStage;
import com.troblecodings.signals.guis.ContainerPlacementtool;
import com.troblecodings.signals.guis.PreviewSideBar;
import com.troblecodings.signals.items.Placementtool;
import java.util.HashMap;
import java.util.List;
import java.util.function.IntConsumer;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class GuiPlacementtool
extends GuiBase {
    public static final int GUI_PLACEMENTTOOL = 0;
    private final UIEntity list = new UIEntity();
    private final PreviewSideBar previewSidebar = new PreviewSideBar(-9.0f);
    private Signal currentSelectedBlock;
    private final Placementtool tool;
    private final EntityPlayer player;
    private final ContainerPlacementtool container;
    private UIEnumerable enumerable;
    private boolean loaded = false;

    public GuiPlacementtool(GuiInfo info) {
        super(info);
        this.player = info.player;
        this.container = (ContainerPlacementtool)info.base;
        ItemStack stack = info.player.func_184614_ca();
        this.tool = (Placementtool)stack.func_77973_b();
        int usedBlock = NBTWrapper.getOrCreateWrapper(stack).getInteger("blocktypeid");
        this.currentSelectedBlock = this.tool.getObjFromID(usedBlock);
        this.initInternal();
    }

    @Override
    public ContainerBase getNewGuiContainer(GuiInfo info) {
        return new ContainerPlacementtool(info);
    }

    private void initInternal() {
        UIBox vbox = new UIBox(UIBox.VBOX, 5);
        this.list.add(vbox);
        this.list.setInherits(true);
        UIEntity lowerEntity = new UIEntity();
        lowerEntity.add(GuiElements.createSpacerH(10));
        this.enumerable = new UIEnumerable(this.tool.count(), this.tool.getName());
        UIEntity selectBlockEntity = GuiElements.createEnumElement(this.enumerable, this.tool, input -> {
            this.currentSelectedBlock = this.tool.getObjFromID(input);
            this.list.clearChildren();
            if (this.container.signalID != input) {
                this.previewSidebar.clear();
                this.sendSignalId(input);
            }
        });
        UIEntity leftSide = new UIEntity();
        leftSide.setInheritHeight(true);
        leftSide.setInheritWidth(true);
        leftSide.add(new UIBox(UIBox.VBOX, 5));
        leftSide.add(selectBlockEntity);
        leftSide.add(this.list);
        leftSide.add(GuiElements.createPageSelect(vbox));
        lowerEntity.add(new UIBox(UIBox.HBOX, 5));
        lowerEntity.add(leftSide);
        lowerEntity.add(this.previewSidebar.get());
        lowerEntity.setInheritHeight(true);
        lowerEntity.setInheritWidth(true);
        UILabel titlelabel = new UILabel(I18Wrapper.format("property.signal.name", new Object[0]));
        titlelabel.setCenterX(false);
        UIEntity titel = new UIEntity();
        titel.add(new UIScale(1.2f, 1.2f, 1.0f));
        titel.add(titlelabel);
        titel.setInheritHeight(true);
        titel.setInheritWidth(true);
        UIEntity topPart = new UIEntity();
        topPart.setInheritWidth(true);
        topPart.setHeight(20.0);
        topPart.add(new UIBox(UIBox.HBOX, 5));
        topPart.add(GuiElements.createSpacerH(10));
        topPart.add(titel);
        this.entity.add(topPart);
        this.entity.add(new UIBox(UIBox.VBOX, 5));
        this.entity.add(lowerEntity);
    }

    public void of(SEProperty property, IntConsumer consumer, int value) {
        if (property == null) {
            return;
        }
        this.previewSidebar.addToRenderList(property, value);
        if (property.isChangabelAtStage(ChangeableStage.GUISTAGE)) {
            if (property.getParent().equals(JsonEnum.BOOLEAN)) {
                this.list.add(GuiElements.createBoolElement(property, consumer, value));
                return;
            }
            this.list.add(GuiElements.createEnumElement(property, consumer, value));
        } else if (property.isChangabelAtStage(ChangeableStage.APISTAGE)) {
            this.list.add(GuiElements.createBoolElement(property, consumer, value));
        }
    }

    @Override
    public void updateFromContainer() {
        this.enumerable.setIndex(this.container.signalID);
        List<SEProperty> originalProperties = this.currentSelectedBlock.getProperties();
        originalProperties.forEach(property -> this.of((SEProperty)property, inp -> this.applyPropertyChanges((SEProperty)property, inp), this.container.properties.get(property)));
        UIEntity textfield = new UIEntity();
        textfield.setHeight(20.0);
        textfield.setInheritWidth(true);
        if (this.currentSelectedBlock.canHaveCustomname(new HashMap<SEProperty, String>())) {
            UITextInput name = new UITextInput(this.container.signalName);
            textfield.add(new UIToolTip(I18Wrapper.format("property.customname.desc", new Object[0])));
            name.setOnTextUpdate(this::sendName);
            textfield.add(name);
            this.list.add(textfield);
        }
        this.entity.update();
        this.loaded = true;
        this.previewSidebar.update(this.currentSelectedBlock);
    }

    private void applyPropertyChanges(SEProperty property, int valueId) {
        this.previewSidebar.addToRenderList(property, valueId);
        if (this.loaded) {
            int propertyId = this.currentSelectedBlock.getIDFromProperty(property);
            WriteBuffer buffer = new WriteBuffer();
            buffer.putByte((byte)propertyId);
            buffer.putByte((byte)valueId);
            OpenSignalsMain.network.sendTo(this.player, buffer);
            this.previewSidebar.update(this.currentSelectedBlock);
        }
    }

    private void sendSignalId(int id) {
        if (!this.loaded) {
            return;
        }
        WriteBuffer buffer = new WriteBuffer();
        buffer.putByte((byte)-1);
        buffer.putInt(id);
        OpenSignalsMain.network.sendTo(this.player, buffer);
    }

    private void sendName(String name) {
        if (!this.loaded) {
            return;
        }
        WriteBuffer buffer = new WriteBuffer();
        buffer.putByte((byte)-1);
        buffer.putInt(-1);
        buffer.putString(name);
        OpenSignalsMain.network.sendTo(this.player, buffer.build());
    }
}

