/*
 * Decompiled with CFR 0.152.
 */
package com.troblecodings.signals.core;

import com.google.common.collect.ImmutableList;
import com.troblecodings.core.NBTWrapper;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import net.minecraft.util.math.BlockPos;

public class LinkingUpdates {
    private final List<BlockPos> posToAdd = new ArrayList<BlockPos>();
    private final List<BlockPos> posToRemove = new ArrayList<BlockPos>();
    private static final String POS_ADD = "posAdd";
    private static final String POS_REMOVE = "posRemove";

    public void addPosToLink(BlockPos pos) {
        if (this.posToAdd.contains(pos)) {
            return;
        }
        this.posToAdd.add(pos);
        if (this.posToRemove.contains(pos)) {
            this.posToRemove.remove(pos);
        }
    }

    public void addPosToUnlink(BlockPos pos) {
        if (this.posToRemove.contains(pos)) {
            return;
        }
        this.posToRemove.add(pos);
        if (this.posToAdd.contains(pos)) {
            this.posToAdd.remove(pos);
        }
    }

    public List<BlockPos> getPosToAdd() {
        return ImmutableList.copyOf(this.posToAdd);
    }

    public List<BlockPos> getPosToRemove() {
        return ImmutableList.copyOf(this.posToRemove);
    }

    public void writeNBT(NBTWrapper wrapper) {
        wrapper.putList(POS_ADD, this.posToAdd.stream().map(pos -> NBTWrapper.getBlockPosWrapper(pos)).collect(Collectors.toList()));
        wrapper.putList(POS_REMOVE, this.posToRemove.stream().map(pos -> NBTWrapper.getBlockPosWrapper(pos)).collect(Collectors.toList()));
    }

    public void readNBT(NBTWrapper wrapper) {
        this.posToAdd.clear();
        this.posToRemove.clear();
        wrapper.getList(POS_ADD).forEach(tag -> this.posToAdd.add(tag.getAsPos()));
        wrapper.getList(POS_REMOVE).forEach(tag -> this.posToRemove.add(tag.getAsPos()));
    }

    public int hashCode() {
        return Objects.hash(this.posToAdd, this.posToRemove);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        LinkingUpdates other = (LinkingUpdates)obj;
        return Objects.equals(this.posToAdd, other.posToAdd) && Objects.equals(this.posToRemove, other.posToRemove);
    }

    public String toString() {
        return "LinkingUpdates [PosToAdd: " + this.posToAdd + ", PosToRemove: " + this.posToRemove + "]";
    }
}

