/*
 * Decompiled with CFR 0.152.
 */
package com.troblecodings.linkableapi;

import com.google.common.base.Predicate;
import com.troblecodings.linkableapi.ILinkableTile;
import com.troblecodings.linkableapi.TaggableFunction;
import java.util.List;
import java.util.function.BiPredicate;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class Linkingtool
extends Item {
    private final BiPredicate<World, BlockPos> predicate;
    private final Predicate<TileEntity> predicateSet;
    private final TaggableFunction tagFromFunction;

    public Linkingtool(CreativeTabs tab, BiPredicate<World, BlockPos> predicate) {
        this(tab, predicate, (Predicate<TileEntity>)((Predicate)_u -> true));
    }

    public Linkingtool(CreativeTabs tab, BiPredicate<World, BlockPos> predicate, Predicate<TileEntity> predicateSet) {
        this(tab, predicate, predicateSet, (_u1, _u2, _u3) -> {});
    }

    public Linkingtool(CreativeTabs tab, BiPredicate<World, BlockPos> predicate, Predicate<TileEntity> predicateSet, TaggableFunction function) {
        this.predicate = predicate;
        this.predicateSet = predicateSet;
        this.tagFromFunction = function;
        this.func_77637_a(tab);
        this.setNoRepair();
        this.func_77656_e(64);
        this.func_77625_d(1);
    }

    public EnumActionResult func_180614_a(EntityPlayer player, World worldIn, BlockPos pos, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        if (player == null) {
            return EnumActionResult.FAIL;
        }
        if (worldIn.field_72995_K) {
            return EnumActionResult.PASS;
        }
        TileEntity entity = worldIn.func_175625_s(pos);
        ItemStack stack = player.func_184586_b(hand);
        if (entity instanceof ILinkableTile && this.predicateSet.apply((Object)entity)) {
            ILinkableTile controller = (ILinkableTile)entity;
            if (!player.func_70093_af()) {
                NBTTagCompound comp = stack.func_77978_p();
                if (comp == null) {
                    this.message(player, "lt.notset", pos.toString());
                    return EnumActionResult.PASS;
                }
                BlockPos linkedPos = NBTUtil.func_186861_c((NBTTagCompound)comp);
                if (controller.link(linkedPos, comp)) {
                    this.message(player, "lt.linkedpos", pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
                    stack.func_77982_d(null);
                    this.message(player, "lt.reset", new Object[0]);
                    return EnumActionResult.FAIL;
                }
                this.message(player, "lt.notlinked", new Object[0]);
                this.message(player, "lt.notlinked.msg", new Object[0]);
                return EnumActionResult.FAIL;
            }
            if (controller.canBeLinked() && this.predicate.test(worldIn, pos)) {
                NBTTagCompound tag = stack.func_77978_p();
                if (tag != null) {
                    boolean containsPos;
                    boolean bl = containsPos = tag.func_74764_b("X") && tag.func_74764_b("Y") && tag.func_74764_b("Z");
                    if (containsPos) {
                        this.message(player, "lt.setpos.msg", new Object[0]);
                        return EnumActionResult.FAIL;
                    }
                }
                NBTTagCompound comp = NBTUtil.func_186859_a((BlockPos)pos);
                this.tagFromFunction.test(worldIn, pos, comp);
                stack.func_77982_d(comp);
                this.message(player, "lt.setpos", pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
                this.message(player, "lt.setpos.msg", new Object[0]);
                return EnumActionResult.SUCCESS;
            }
            if (controller.hasLink() && controller.unlink()) {
                this.message(player, "lt.unlink", new Object[0]);
                return EnumActionResult.SUCCESS;
            }
            return EnumActionResult.SUCCESS;
        }
        if (this.predicate.test(worldIn, pos)) {
            NBTTagCompound tag = stack.func_77978_p();
            if (tag != null) {
                boolean containsPos;
                boolean bl = containsPos = tag.func_74764_b("X") && tag.func_74764_b("Y") && tag.func_74764_b("Z");
                if (containsPos) {
                    this.message(player, "lt.setpos.msg", new Object[0]);
                    return EnumActionResult.FAIL;
                }
            }
            NBTTagCompound comp = NBTUtil.func_186859_a((BlockPos)pos);
            this.tagFromFunction.test(worldIn, pos, comp);
            stack.func_77982_d(comp);
            this.message(player, "lt.setpos", pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
            this.message(player, "lt.setpos.msg", new Object[0]);
            return EnumActionResult.SUCCESS;
        }
        if (player.func_70093_af() && stack.func_77978_p() != null) {
            stack.func_77982_d(null);
            this.message(player, "lt.reset", new Object[0]);
            return EnumActionResult.SUCCESS;
        }
        return EnumActionResult.FAIL;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, World worldIn, List<String> tooltip, ITooltipFlag flagIn) {
        NBTTagCompound tag = stack.func_77978_p();
        if (tag != null) {
            boolean containsPos;
            boolean bl = containsPos = tag.func_74764_b("X") && tag.func_74764_b("Y") && tag.func_74764_b("Z");
            if (containsPos) {
                BlockPos pos = NBTUtil.func_186861_c((NBTTagCompound)tag);
                tooltip.add(I18n.func_135052_a((String)"lt.linkedpos", (Object[])new Object[]{pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p()}));
                return;
            }
        }
        tooltip.add(I18n.func_135052_a((String)"lt.notlinked", (Object[])new Object[0]));
        tooltip.add(I18n.func_135052_a((String)"lt.notlinked.msg", (Object[])new Object[0]));
    }

    public void tooltip(List list, String text, Object ... obj) {
        list.add(this.getComponent(text, obj));
    }

    public void message(EntityPlayer player, String text, Object ... obj) {
        player.func_145747_a(this.getComponent(text, obj));
    }

    public ITextComponent getComponent(String text, Object ... obj) {
        return new TextComponentTranslation(text, obj);
    }
}

