/*
 * Decompiled with CFR 0.152.
 */
package com.troblecodings.guilib.ecs.entitys.render;

import com.troblecodings.guilib.ecs.entitys.BufferWrapper;
import com.troblecodings.guilib.ecs.entitys.DrawInfo;
import com.troblecodings.guilib.ecs.entitys.UIComponent;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class UIColor
extends UIComponent {
    private int color;
    private final int insets;

    public UIColor(int color) {
        this(color, 0);
    }

    public UIColor(int color, int insets) {
        this.color = color;
        this.insets = insets;
    }

    @Override
    public void draw(DrawInfo info) {
        if (this.visible) {
            info.disableTexture();
            info.applyColor();
            info.depthOff();
            info.blendOn();
            info.alphaOn();
            BufferWrapper wrapper = info.builder(7, DefaultVertexFormats.field_181706_f);
            wrapper.quad(-this.insets, (int)this.parent.getWidth() + this.insets, -this.insets, (int)this.parent.getHeight() + this.insets, this.color);
            info.end();
            info.alphaOff();
            info.blendOff();
        }
    }

    @Override
    public void update() {
    }

    public int getColor() {
        return this.color;
    }

    public void setColor(int color) {
        this.color = color;
    }

    public static int alpha(int color) {
        return color >>> 24;
    }

    public static int red(int color) {
        return color >> 16 & 0xFF;
    }

    public static int green(int color) {
        return color >> 8 & 0xFF;
    }

    public static int blue(int color) {
        return color & 0xFF;
    }
}

