/*
 * Decompiled with CFR 0.152.
 */
package com.troblecodings.guilib.ecs.entitys;

import com.troblecodings.guilib.ecs.entitys.DrawInfo;
import com.troblecodings.guilib.ecs.entitys.HBoxMode;
import com.troblecodings.guilib.ecs.entitys.UIComponent;
import com.troblecodings.guilib.ecs.entitys.UIEntity;
import com.troblecodings.guilib.ecs.entitys.VBoxMode;
import com.troblecodings.guilib.ecs.interfaces.IBoxMode;
import com.troblecodings.guilib.ecs.interfaces.UIPagable;
import java.util.ArrayList;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class UIBox
extends UIComponent
implements UIPagable {
    private int page = 0;
    private int maxPages = 0;
    public static final VBoxMode VBOX = new VBoxMode();
    public static final HBoxMode HBOX = new HBoxMode();
    private final IBoxMode mode;
    private final int gap;
    private final ArrayList<UIEntity> boundsUpdate = new ArrayList();
    private boolean pageable = true;

    public UIBox(IBoxMode mode, int gap) {
        this.mode = mode;
        this.gap = gap;
    }

    @Override
    public void draw(DrawInfo info) {
    }

    @Override
    public void update() {
        int parentBounds;
        int n = parentBounds = this.pageable ? this.mode.getBounds(this.parent) : Integer.MAX_VALUE;
        if (parentBounds < 1) {
            return;
        }
        this.updateBounds(parentBounds);
        this.updatePositions(parentBounds);
        this.parent.children.forEach(this.mode::post);
    }

    protected void updateBounds(int parentValue) {
        int y = 0;
        for (UIEntity entity : this.parent.children) {
            if (this.mode.inheritsBounds(entity)) {
                this.boundsUpdate.add(entity);
            } else {
                y += this.mode.getBounds(entity) + this.gap;
            }
            if (y <= parentValue) continue;
            if (!this.boundsUpdate.isEmpty()) {
                this.boundsUpdate.forEach(e -> this.mode.setBounds((UIEntity)e, this.mode.getMin((UIEntity)e)));
                this.boundsUpdate.clear();
            }
            y = 0;
        }
        if (this.boundsUpdate.isEmpty()) {
            return;
        }
        float rest = Math.max(parentValue - y, 0);
        int sizePer = Math.round(rest / (float)this.boundsUpdate.size()) - this.gap * 2;
        this.boundsUpdate.forEach(e -> this.mode.setBounds((UIEntity)e, sizePer));
        this.boundsUpdate.clear();
    }

    protected void updatePositions(int parentValue) {
        int cPage = 0;
        int y = 0;
        for (UIEntity entity : this.parent.children) {
            this.mode.setPos(entity, y);
            int oBounds = this.mode.getBounds(entity);
            if ((y += oBounds) > parentValue) {
                this.mode.setPos(entity, 0);
                y = oBounds;
                ++cPage;
            }
            y += this.gap;
            entity.setVisible(cPage == this.page);
        }
        this.maxPages = cPage + 1;
    }

    @Override
    public void onAdd(UIEntity entity) {
        super.onAdd(entity);
        this.update();
    }

    @Override
    public int getPage() {
        return this.page;
    }

    @Override
    public void setPage(int page) {
        this.page = page;
        this.update();
    }

    @Override
    public int getMaxPages() {
        return this.maxPages;
    }

    public boolean isPageable() {
        return this.pageable;
    }

    public void setPageable(boolean pageable) {
        this.pageable = pageable;
    }
}

