/*
 * Decompiled with CFR 0.152.
 */
package com.troblecodings.guilib.ecs.entitys;

import com.troblecodings.guilib.ecs.entitys.BufferWrapper;
import com.troblecodings.guilib.ecs.entitys.render.UIColor;
import java.nio.ByteBuffer;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.renderer.vertex.VertexFormat;
import net.minecraft.client.renderer.vertex.VertexFormatElement;
import net.minecraft.util.ResourceLocation;
import org.lwjgl.opengl.GL11;
import org.lwjgl.util.vector.Quaternion;

public class DrawInfo {
    public final int mouseX;
    public final int mouseY;
    public final float tick;

    public DrawInfo(int mouseX, int mouseY, float tick) {
        this.mouseX = mouseX;
        this.mouseY = mouseY;
        this.tick = tick;
    }

    public void applyColor() {
        this.color();
    }

    public void push() {
        GlStateManager.func_179094_E();
    }

    public void pop() {
        GlStateManager.func_179121_F();
    }

    public void translate(double x, double y, double z) {
        GlStateManager.func_179137_b((double)x, (double)y, (double)z);
    }

    public void scale(double x, double y, double z) {
        GlStateManager.func_179139_a((double)x, (double)y, (double)z);
    }

    public void rotate(Quaternion quaternion) {
        GlStateManager.func_187444_a((Quaternion)quaternion);
    }

    public void applyTexture(ResourceLocation location) {
        GlStateManager.func_179098_w();
        Minecraft.func_71410_x().func_110434_K().func_110577_a(location);
    }

    public void drawBuffer(BufferBuilder buffer) {
        if (buffer.func_178989_h() > 0) {
            VertexFormat vertexformat = buffer.func_178973_g();
            int i = vertexformat.func_177338_f();
            ByteBuffer bytebuffer = buffer.func_178966_f();
            List list = vertexformat.func_177343_g();
            for (int j = 0; j < list.size(); ++j) {
                VertexFormatElement vertexformatelement = (VertexFormatElement)list.get(j);
                bytebuffer.position(vertexformat.func_181720_d(j));
                vertexformatelement.func_177375_c().preDraw(vertexformat, j, i, bytebuffer);
            }
            GlStateManager.func_187439_f((int)buffer.func_178979_i(), (int)0, (int)buffer.func_178989_h());
            int j1 = list.size();
            for (int i1 = 0; i1 < j1; ++i1) {
                VertexFormatElement vertexformatelement1 = (VertexFormatElement)list.get(i1);
                vertexformatelement1.func_177375_c().postDraw(vertexformat, i1, i, bytebuffer);
            }
        }
    }

    public void disableTexture() {
        GlStateManager.func_179090_x();
    }

    public void color() {
        this.color(1.0, 1.0, 1.0, 1.0);
    }

    public void color(int color) {
        this.color(UIColor.red(color) / 255, UIColor.green(color) / 255, UIColor.blue(color) / 255, UIColor.alpha(color) / 255);
    }

    public void color(double r, double g, double b, double a) {
        GlStateManager.func_179131_c((float)((float)r), (float)((float)g), (float)((float)b), (float)((float)a));
    }

    public void blendOn() {
        GlStateManager.func_179147_l();
        GlStateManager.func_187428_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
    }

    public void blendOff() {
        GlStateManager.func_179084_k();
    }

    public void depthOn() {
        GlStateManager.func_179126_j();
    }

    public void depthOff() {
        GlStateManager.func_179097_i();
    }

    public void scissorOn(int x, int y, int width, int height) {
        GL11.glEnable((int)3089);
        GL11.glScissor((int)x, (int)y, (int)width, (int)height);
    }

    public void scissorOff() {
        GL11.glDisable((int)3089);
    }

    public void alphaOn() {
        GlStateManager.func_179141_d();
    }

    public void alphaOff() {
        GlStateManager.func_179118_c();
    }

    public void singleLine(int color, BufferWrapper wrapper, float xLeft, float xRight, float yTop, float yBottom, float width) {
        double deltaX = xLeft - xRight;
        double deltaY = yTop - yBottom;
        double hypot = Math.hypot(deltaX, deltaY);
        float normalX = Math.abs((float)(deltaX / hypot)) * (width / 2.0f);
        float normalY = (float)(deltaY / hypot) * (width / 2.0f);
        wrapper.pos(xLeft - normalY, yTop - normalX, 0.0).end();
        wrapper.pos(xLeft + normalY, yTop + normalX, 0.0).end();
        wrapper.pos(xRight - normalY, yBottom - normalX, 0.0).end();
        wrapper.pos(xRight - normalY, yBottom - normalX, 0.0).end();
        wrapper.pos(xLeft + normalY, yTop + normalX, 0.0).end();
        wrapper.pos(xRight + normalY, yBottom + normalX, 0.0).end();
    }

    public void lines(int color, float width, float[] lines) {
        this.color(color);
        BufferWrapper bufferbuilder = this.builder(4, DefaultVertexFormats.field_181705_e);
        for (int i = 0; i < lines.length; i += 4) {
            this.singleLine(color, bufferbuilder, lines[i], lines[i + 2], lines[i + 1], lines[i + 3], width);
        }
        this.end();
        this.color();
    }

    public BufferWrapper builder(int mode, VertexFormat format) {
        BufferBuilder builder = Tessellator.func_178181_a().func_178180_c();
        builder.func_181668_a(mode, format);
        return new BufferWrapper(builder);
    }

    public void end() {
        Tessellator.func_178181_a().func_78381_a();
    }
}

