/*
 * Decompiled with CFR 0.152.
 */
package com.troblecodings.guilib.ecs;

import com.troblecodings.guilib.ecs.ContainerBase;
import com.troblecodings.guilib.ecs.GuiBase;
import com.troblecodings.guilib.ecs.GuiInfo;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.IGuiHandler;
import org.apache.logging.log4j.Logger;

public final class GuiHandler
implements IGuiHandler {
    private final String modid;
    private final Logger logger;
    private final Map<Class<?>, Integer> guiIDS = new HashMap();
    private final List<Function<GuiInfo, ? extends GuiBase>> guiBases = new ArrayList<Function<GuiInfo, ? extends GuiBase>>();
    private final List<Function<GuiInfo, ? extends ContainerBase>> guiContainer = new ArrayList<Function<GuiInfo, ? extends ContainerBase>>();

    public GuiHandler(String modid, Logger logger) {
        this.modid = modid;
        this.logger = logger;
    }

    public <T> void addGui(Class<T> clazz, Function<GuiInfo, ? extends GuiBase> gui) {
        if (!this.guiIDS.containsKey(clazz)) {
            throw new IllegalArgumentException("Register server side before client!");
        }
        this.guiBases.add(gui);
    }

    public <T> void addServer(Class<T> clazz, Function<GuiInfo, ? extends ContainerBase> gui) {
        this.guiContainer.add(gui);
        this.guiIDS.put(clazz, this.guiIDS.size());
    }

    public <T> void invokeGui(Class<T> clazz, EntityPlayer mcPlayer, World world, BlockPos pos, String name) {
        mcPlayer.openGui((Object)this.modid, this.guiIDS.get(clazz).intValue(), world, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
    }

    public Object getServerGuiElement(int id, EntityPlayer player, World world, int x, int y, int z) {
        if (this.guiContainer.size() > id) {
            return this.guiContainer.get(id).apply(new GuiInfo(id, world, new BlockPos(x, y, z), player, player.field_71071_by));
        }
        return null;
    }

    public Object getClientGuiElement(int id, EntityPlayer player, World world, int x, int y, int z) {
        if (this.guiBases.size() > id) {
            return this.guiBases.get(id).apply(new GuiInfo(id, world, new BlockPos(x, y, z), player, player.field_71071_by));
        }
        return null;
    }
}

