/*
 * Decompiled with CFR 0.152.
 */
package com.troblecodings.guilib.ecs;

import com.troblecodings.core.I18Wrapper;
import com.troblecodings.guilib.ecs.entitys.DrawInfo;
import com.troblecodings.guilib.ecs.interfaces.IIntegerable;
import net.minecraft.client.gui.FontRenderer;

public final class DrawUtil {
    private DrawUtil() {
    }

    public static void drawCenteredString(DrawInfo info, FontRenderer fontRendererIn, String text, int x, int y, int color) {
        fontRendererIn.func_175063_a(text, (float)(x - fontRendererIn.func_78256_a(text) / 2), (float)y, color);
    }

    public static class IntegerHolder {
        private int obj;

        public IntegerHolder(int i) {
            this.setObj(i);
        }

        public int getObj() {
            return this.obj;
        }

        public void setObj(int obj) {
            this.obj = obj;
        }
    }

    public static class BoolIntegerables
    implements IIntegerable<String> {
        private final String name;

        public BoolIntegerables(String name) {
            this.name = name;
        }

        @Override
        public String getObjFromID(int obj) {
            return obj == 0 ? "true" : "false";
        }

        @Override
        public int count() {
            return 2;
        }

        public static BoolIntegerables of(String name) {
            return new BoolIntegerables(name);
        }

        @Override
        public String getName() {
            return this.name;
        }
    }

    public static class SizeIntegerables<T>
    implements IIntegerable<T> {
        private final int count;
        private final ObjGetter<T> getter;
        private final String name;

        public SizeIntegerables(String name, int count, ObjGetter<T> getter) {
            this.count = count;
            this.getter = getter;
            this.name = name;
        }

        @Override
        public T getObjFromID(int obj) {
            return this.getter.getObjFrom(obj);
        }

        @Override
        public int count() {
            return this.count;
        }

        public static <T> IIntegerable<T> of(String name, int count, ObjGetter<T> get) {
            return new SizeIntegerables<T>(name, count, get);
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public String getNamedObj(int obj) {
            return this.getLocalizedName() + ": " + this.getter.getObjFrom(obj);
        }
    }

    public static interface ObjGetter<D> {
        public D getObjFrom(int var1);
    }

    public static class NamedEnumIntegerable<T extends Enum<T>>
    extends EnumIntegerable<T> {
        private final String name;

        public NamedEnumIntegerable(String name, Class<T> t) {
            super(t);
            this.name = name;
        }

        @Override
        public String getName() {
            return this.name;
        }
    }

    public static class EnumIntegerable<T extends Enum<T>>
    implements IIntegerable<T> {
        private final Class<T> t;

        public EnumIntegerable(Class<T> t) {
            this.t = t;
        }

        @Override
        public T getObjFromID(int obj) {
            return (T)((Enum[])this.t.getEnumConstants())[obj];
        }

        @Override
        public int count() {
            return ((Enum[])this.t.getEnumConstants()).length;
        }

        @Override
        public String getName() {
            return this.t.getSimpleName().toLowerCase();
        }
    }

    public static class DisableIntegerable<T>
    implements IIntegerable<T> {
        private final IIntegerable<T> integerable;
        private final String name;

        public DisableIntegerable(IIntegerable<T> integerable) {
            this.integerable = integerable;
            this.name = this.integerable.getName();
        }

        public DisableIntegerable(IIntegerable<T> integerable, String customName) {
            this.integerable = integerable;
            this.name = customName;
        }

        @Override
        public T getObjFromID(int obj) {
            if (obj < 0 || this.count() <= obj) {
                return null;
            }
            return this.integerable.getObjFromID(obj);
        }

        @Override
        public int count() {
            return this.integerable.count();
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public String getNamedObj(int obj) {
            T current = this.getObjFromID(obj);
            if (current == null) {
                return this.getLocalizedName() + ": " + I18Wrapper.format("property.disabled.name", new Object[0]);
            }
            return this.integerable.getNamedObj(obj);
        }
    }
}

