/*
 * Decompiled with CFR 0.152.
 */
package com.troblecodings.core;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.util.math.BlockPos;

public class WriteBuffer {
    private final List<Byte> allBytes = new ArrayList<Byte>();
    private ByteBuffer buildedBuffer;

    public void putByte(Byte b) {
        this.allBytes.add(b);
    }

    public void putInt(int i) {
        for (byte b : ByteBuffer.allocate(4).putInt(i).array()) {
            this.putByte(b);
        }
    }

    public void putFloat(float f) {
        for (byte b : ByteBuffer.allocate(4).putFloat(f).array()) {
            this.putByte(b);
        }
    }

    public void putDouble(double d) {
        for (byte b : ByteBuffer.allocate(8).putDouble(d).array()) {
            this.putByte(b);
        }
    }

    public void putBlockPos(BlockPos pos) {
        for (byte b : ByteBuffer.allocate(12).putInt(pos.func_177958_n()).putInt(pos.func_177956_o()).putInt(pos.func_177952_p()).array()) {
            this.putByte(b);
        }
    }

    public void putBoolean(boolean bool) {
        this.putByte((byte)(bool ? 1 : 0));
    }

    public void putString(String str) {
        byte[] array = str.getBytes();
        this.putInt(array.length);
        for (byte b : array) {
            this.putByte(b);
        }
    }

    public <T extends Enum<T>> void putEnumValue(Enum<T> enumValue) {
        this.putInt(enumValue.ordinal());
    }

    public void resetBuilder() {
        this.allBytes.clear();
    }

    public ByteBuffer getBuildedBuffer() {
        if (this.buildedBuffer == null) {
            return this.build();
        }
        return this.buildedBuffer;
    }

    public ByteBuffer build() {
        this.buildedBuffer = ByteBuffer.allocate(this.allBytes.size());
        this.allBytes.forEach(this.buildedBuffer::put);
        this.resetBuilder();
        return this.buildedBuffer;
    }
}

