/*
 * Decompiled with CFR 0.152.
 */
package com.troblecodings.core;

import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import net.minecraft.util.math.BlockPos;

public class ReadBuffer {
    private final ByteBuffer readBuffer;

    public ReadBuffer(ByteBuffer buffer) {
        this.readBuffer = buffer;
    }

    public byte getByte() {
        return this.readBuffer.get();
    }

    public int getInt() {
        return this.readBuffer.getInt();
    }

    public float getFloat() {
        return this.readBuffer.getFloat();
    }

    public double getDouble() {
        return this.readBuffer.getDouble();
    }

    public long getLong() {
        return this.readBuffer.getLong();
    }

    public int getByteToUnsignedInt() {
        return Byte.toUnsignedInt(this.readBuffer.get());
    }

    public boolean getBoolean() {
        return this.getByte() == 1;
    }

    public BlockPos getBlockPos() {
        return new BlockPos(this.readBuffer.getInt(), this.readBuffer.getInt(), this.readBuffer.getInt());
    }

    public <T extends Enum<T>> T getEnumValue(Class<T> enumClass) {
        return (T)((Enum[])enumClass.getEnumConstants())[this.getInt()];
    }

    public String getString() {
        int size = this.getInt();
        byte[] array = new byte[size];
        for (int i = 0; i < size; ++i) {
            array[i] = this.getByte();
        }
        try {
            return new String(array, "UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            return "";
        }
    }
}

