/*
 * Decompiled with CFR 0.152.
 */
package com.troblecodings.core;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.util.math.BlockPos;

public class NBTWrapper {
    public NBTTagCompound tag;

    public NBTWrapper(NBTTagCompound tag) {
        this.tag = tag;
    }

    public NBTWrapper() {
        this(new NBTTagCompound());
    }

    public boolean contains(String key) {
        return this.tag.func_74764_b(key);
    }

    public void putBoolean(String key, boolean value) {
        this.tag.func_74757_a(key, value);
    }

    public void putInteger(String key, int value) {
        this.tag.func_74768_a(key, value);
    }

    public void putByte(String key, byte value) {
        this.tag.func_74774_a(key, value);
    }

    public void putString(String key, String value) {
        this.tag.func_74778_a(key, value);
    }

    public void putFloat(String key, float value) {
        this.tag.func_74776_a(key, value);
    }

    public void putList(String key, Iterable<NBTWrapper> value) {
        NBTTagList list = new NBTTagList();
        value.forEach(tagWrapper -> list.func_74742_a((NBTBase)tagWrapper.tag));
        this.tag.func_74782_a(key, (NBTBase)list);
    }

    public void putWrapper(String key, NBTWrapper value) {
        this.tag.func_74782_a(key, (NBTBase)value.tag);
    }

    public void putBlockPos(String key, BlockPos value) {
        this.putWrapper(key, NBTWrapper.getBlockPosWrapper(value));
    }

    public boolean getBoolean(String key) {
        return this.tag.func_74767_n(key);
    }

    public int getInteger(String key) {
        return this.tag.func_74762_e(key);
    }

    public byte getByte(String key) {
        return this.tag.func_74771_c(key);
    }

    public String getString(String key) {
        return this.tag.func_74779_i(key);
    }

    public float getFloat(String key) {
        return this.tag.func_74760_g(key);
    }

    public BlockPos getBlockPos(String key) {
        NBTWrapper wrapper = this.getWrapper(key);
        return wrapper.isTagNull() ? null : wrapper.getAsPos();
    }

    public List<NBTWrapper> getList(String key) {
        NBTTagList list = (NBTTagList)this.tag.func_74781_a(key);
        ArrayList<NBTWrapper> returnList = new ArrayList<NBTWrapper>();
        if (list == null) {
            return returnList;
        }
        list.forEach(tag -> returnList.add(new NBTWrapper((NBTTagCompound)tag)));
        return returnList;
    }

    public NBTWrapper getWrapper(String key) {
        return new NBTWrapper((NBTTagCompound)this.tag.func_74781_a(key));
    }

    public BlockPos getAsPos() {
        return NBTUtil.func_186861_c((NBTTagCompound)this.tag);
    }

    public NBTWrapper copy() {
        return new NBTWrapper(this.tag.func_74737_b());
    }

    public Set<String> keySet() {
        return this.tag.func_150296_c();
    }

    public void remove(String key) {
        this.tag.func_82580_o(key);
    }

    public boolean isTagNull() {
        return this.tag == null;
    }

    public static NBTWrapper getBlockPosWrapper(BlockPos pos) {
        return new NBTWrapper(NBTUtil.func_186859_a((BlockPos)pos));
    }

    public static NBTWrapper getOrCreateWrapper(ItemStack stack) {
        NBTTagCompound tag = stack.func_77978_p();
        if (tag != null) {
            return new NBTWrapper(tag);
        }
        NBTWrapper returnTag = new NBTWrapper();
        stack.func_77982_d(returnTag.tag);
        return returnTag;
    }

    public static NBTWrapper createForStack(ItemStack stack) {
        NBTWrapper wrapper = new NBTWrapper();
        stack.func_77982_d(wrapper.tag);
        return wrapper;
    }

    public String toString() {
        return this.tag.toString();
    }
}

