/*
 * Decompiled with CFR 0.152.
 */
package com.silvaniastudios.roads.network;

import com.silvaniastudios.roads.items.PaintGun;
import io.netty.buffer.ByteBuf;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumHand;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;

public class PaintGunUpdatePacket
implements IMessage {
    private int selection;
    private String selectedColour;
    private int pageId;
    private boolean isLarge;

    public PaintGunUpdatePacket() {
    }

    public PaintGunUpdatePacket(int selection, String selectedColour, int pageId, boolean isLarge) {
        this.selection = selection;
        this.selectedColour = selectedColour;
        this.pageId = pageId;
        this.isLarge = isLarge;
    }

    public void toBytes(ByteBuf buf) {
        buf.writeInt(this.selection);
        ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)this.selectedColour);
        buf.writeInt(this.pageId);
        buf.writeBoolean(this.isLarge);
    }

    public void fromBytes(ByteBuf buf) {
        this.selection = buf.readInt();
        this.selectedColour = ByteBufUtils.readUTF8String((ByteBuf)buf);
        this.pageId = buf.readInt();
        this.isLarge = buf.readBoolean();
    }

    public static class Handler
    implements IMessageHandler<PaintGunUpdatePacket, IMessage> {
        public IMessage onMessage(PaintGunUpdatePacket message, MessageContext ctx) {
            EntityPlayerMP player = ctx.getServerHandler().field_147369_b;
            int selection = message.selection;
            String selectedColour = message.selectedColour;
            int pageId = message.pageId;
            boolean isLarge = message.isLarge;
            player.func_71121_q().func_152344_a(() -> {
                ItemStack item = player.func_184586_b(EnumHand.MAIN_HAND);
                if (item.func_77973_b() instanceof PaintGun) {
                    NBTTagCompound nbt = item.func_77942_o() ? item.func_77978_p() : new NBTTagCompound();
                    nbt.func_74768_a("selectedId", selection);
                    nbt.func_74778_a("colour", selectedColour);
                    nbt.func_74768_a("pageId", pageId);
                    nbt.func_74757_a("isLarge", isLarge);
                    item.func_77982_d(nbt);
                }
            });
            return null;
        }
    }
}

