/*
 * Decompiled with CFR 0.152.
 */
package com.silvaniastudios.roads.items;

import com.silvaniastudios.roads.FurenikusRoads;
import com.silvaniastudios.roads.RoadsConfig;
import com.silvaniastudios.roads.blocks.RoadBlock;
import com.silvaniastudios.roads.blocks.paint.PaintBlockBase;
import com.silvaniastudios.roads.items.RoadItemBase;
import com.silvaniastudios.roads.registries.PaintCategoryList;
import com.silvaniastudios.roads.registries.PaintGunItemRegistry;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockSnow;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.EnumAction;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class PaintGun
extends RoadItemBase {
    public PaintBlockBase selection;
    public int selMeta;
    public int white_paint = 0;
    public int yellow_paint = 0;
    public int red_paint = 0;

    public PaintGun(String name) {
        super(name, 1);
    }

    public EnumAction func_77661_b(ItemStack stack) {
        return EnumAction.NONE;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<String> tooltip, ITooltipFlag flagIn) {
        tooltip.add(I18n.func_135052_a((String)"item.tooltip.paint_gun_1", (Object[])new Object[0]));
        tooltip.add(I18n.func_135052_a((String)"item.tooltip.paint_gun_2", (Object[])new Object[0]));
        if (stack.func_77942_o()) {
            if (GuiScreen.func_146272_n()) {
                NBTTagCompound nbt = stack.func_77978_p();
                int selectId = nbt.func_74762_e("selectedId");
                int pageId = nbt.func_74762_e("pageId");
                this.selection = PaintGun.getBlockFromSelection(selectId, pageId);
                this.selMeta = nbt.func_74762_e("selMeta");
                tooltip.add(I18n.func_135052_a((String)"item.tooltip.paint_gun.selection", (Object[])new Object[0]) + " " + new ItemStack((Block)this.selection, 1, this.selMeta).func_82833_r());
                tooltip.add(I18n.func_135052_a((String)"item.tooltip.paint_gun.colour", (Object[])new Object[0]) + " " + I18n.func_135052_a((String)("colour." + nbt.func_74779_i("colour")), (Object[])new Object[0]));
                tooltip.add(" ");
                tooltip.add(I18n.func_135052_a((String)"item.tooltip.paint_gun.white", (Object[])new Object[0]) + " " + nbt.func_74762_e("white_paint"));
                tooltip.add(I18n.func_135052_a((String)"item.tooltip.paint_gun.yellow", (Object[])new Object[0]) + " " + nbt.func_74762_e("yellow_paint"));
                tooltip.add(I18n.func_135052_a((String)"item.tooltip.paint_gun.red", (Object[])new Object[0]) + " " + nbt.func_74762_e("red_paint"));
            } else {
                tooltip.add(I18n.func_135052_a((String)"item.tooltip.more_info", (Object[])new Object[0]));
            }
        }
    }

    public static PaintBlockBase getBlockFromSelection(int sel, int page) {
        if (PaintGunItemRegistry.categoryList.size() >= page) {
            PaintCategoryList cat = PaintGunItemRegistry.categoryList.get(page);
            if (cat.size() >= sel) {
                return cat.getPaint(sel);
            }
            return cat.getPaint(0);
        }
        return PaintGunItemRegistry.categoryList.get(0).getPaint(0);
    }

    public void func_150895_a(CreativeTabs tab, NonNullList<ItemStack> items) {
        if (this.func_194125_a(tab)) {
            items.add((Object)new ItemStack((Item)this));
            ItemStack stackFilled = new ItemStack((Item)this);
            NBTTagCompound nbt = new NBTTagCompound();
            nbt.func_74768_a("selectedId", 1);
            nbt.func_74768_a("pageId", 1);
            nbt.func_74778_a("colour", "white");
            nbt.func_74768_a("white_paint", 32000);
            nbt.func_74768_a("yellow_paint", 32000);
            nbt.func_74768_a("red_paint", 32000);
            stackFilled.func_77982_d(nbt);
            items.add((Object)stackFilled);
        }
    }

    public EnumActionResult func_180614_a(EntityPlayer player, World world, BlockPos pos, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        NBTTagCompound nbt;
        ItemStack stack = player.func_184586_b(hand);
        if (stack.func_77973_b() != this) {
            return EnumActionResult.FAIL;
        }
        if (!stack.func_77942_o()) {
            nbt = new NBTTagCompound();
        } else {
            nbt = stack.func_77978_p();
            this.white_paint = nbt.func_74762_e("white_paint");
            this.yellow_paint = nbt.func_74762_e("yellow_paint");
            this.red_paint = nbt.func_74762_e("red_paint");
        }
        String colourId = nbt.func_74779_i("colour");
        if (colourId.equals("0")) {
            colourId = "white";
        }
        if (colourId.equals("1")) {
            colourId = "yellow";
        }
        if (colourId.equals("2")) {
            colourId = "red";
        }
        nbt.func_74778_a("colour", colourId);
        boolean creative = player.func_184812_l_();
        int cost = RoadsConfig.general.costToPaint;
        if (colourId.equals("yellow") && (this.yellow_paint >= cost || creative) && this.selectBlockToPlace(nbt, world, pos, facing, hitX, hitY, hitZ, player, hand, colourId) && !creative) {
            this.yellow_paint -= cost;
        }
        if (colourId.equals("red") && (this.red_paint >= cost || creative) && this.selectBlockToPlace(nbt, world, pos, facing, hitX, hitY, hitZ, player, hand, colourId) && !creative) {
            this.red_paint -= cost;
        }
        if (!(colourId.equals("yellow") || colourId.equals("red") || this.white_paint < cost && !creative || !this.selectBlockToPlace(nbt, world, pos, facing, hitX, hitY, hitZ, player, hand, colourId) || creative)) {
            this.white_paint -= cost;
        }
        nbt.func_74768_a("white_paint", this.white_paint);
        nbt.func_74768_a("yellow_paint", this.yellow_paint);
        nbt.func_74768_a("red_paint", this.red_paint);
        return EnumActionResult.PASS;
    }

    public ActionResult<ItemStack> func_77659_a(World worldIn, EntityPlayer player, EnumHand handIn) {
        RayTraceResult rtr = this.func_77621_a(worldIn, player, true);
        if (rtr != null) {
            BlockPos hitPos;
            Block block;
            if (rtr.field_72313_a == RayTraceResult.Type.BLOCK && ((block = worldIn.func_180495_p(hitPos = rtr.func_178782_a()).func_177230_c()) instanceof PaintBlockBase || block instanceof RoadBlock)) {
                return new ActionResult(EnumActionResult.PASS, (Object)player.func_184586_b(handIn));
            }
        } else {
            FurenikusRoads.proxy.openGui(0);
            return new ActionResult(EnumActionResult.PASS, (Object)player.func_184586_b(handIn));
        }
        if (player.func_70093_af()) {
            FurenikusRoads.proxy.openGui(0);
        }
        return new ActionResult(EnumActionResult.PASS, (Object)player.func_184586_b(handIn));
    }

    public boolean selectBlockToPlace(NBTTagCompound nbt, World world, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, EntityPlayer player, EnumHand hand, String col) {
        int selection = nbt.func_74762_e("selectedId");
        int pageId = nbt.func_74762_e("pageId");
        BlockPos placePos = pos.func_177972_a(facing);
        if (!world.func_180495_p(placePos).func_177230_c().func_176200_f((IBlockAccess)world, placePos)) {
            return false;
        }
        if (!(world.func_180495_p(placePos.func_177972_a(EnumFacing.DOWN)).func_177230_c() instanceof PaintBlockBase) && player.func_70093_af()) {
            return false;
        }
        PaintBlockBase block = PaintGunItemRegistry.getSelectedPaint(pageId, selection);
        int meta = PaintGunItemRegistry.getSelectedPaintMeta(pageId, selection);
        if (PaintGunItemRegistry.getCategory(pageId) != null && PaintGunItemRegistry.getCategory(pageId).getCategoryName().equalsIgnoreCase("text") && nbt.func_74767_n("isLarge")) {
            meta = 4;
        }
        if (block != null) {
            if (!col.equals("white")) {
                block = PaintGunItemRegistry.getAlternativeColour(block, col);
            }
            if (player.func_70093_af()) {
                for (int offsetCount = 0; world.func_180495_p(placePos).func_177230_c() instanceof PaintBlockBase && offsetCount < 3; ++offsetCount) {
                    placePos = placePos.func_177972_a(EnumFacing.UP);
                }
            }
            if (world.func_180495_p(placePos.func_177972_a(EnumFacing.DOWN)).func_177230_c() instanceof BlockSnow) {
                return this.placeBlock(world, placePos.func_177972_a(EnumFacing.DOWN), block.getStateForPlacement(world, placePos, facing, hitX, hitY, hitZ, meta, (EntityLivingBase)player, hand));
            }
            return this.placeBlock(world, placePos, block.getStateForPlacement(world, placePos, facing, hitX, hitY, hitZ, meta, (EntityLivingBase)player, hand));
        }
        return false;
    }

    public boolean placeBlock(World world, BlockPos pos, IBlockState state) {
        boolean b = world.func_175656_a(pos, state);
        world.func_184138_a(pos, state, state, 2);
        return b;
    }
}

