/*
 * Decompiled with CFR 0.152.
 */
package com.silvaniastudios.roads.client.model;

import com.silvaniastudios.roads.blocks.tileentities.roadfactory.RoadFactoryEntity;
import com.silvaniastudios.roads.client.model.RenderHelper;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraftforge.client.model.animation.FastTESR;
import net.minecraftforge.fluids.FluidStack;

public class RoadFactoryRenderer
extends FastTESR<RoadFactoryEntity> {
    private static float p = 0.0f;

    public void renderTileEntityFast(RoadFactoryEntity te, double x, double y, double z, float partialTicks, int destroyStage, float partial, BufferBuilder buffer) {
        FluidStack fluid = te.tarFluid.getFluid();
        int meta = te.func_145838_q().func_176201_c(te.getState());
        if (fluid != null && fluid.amount > 0) {
            RoadFactoryRenderer.renderTankFluid(buffer, x, y, z, fluid, meta, te.isFilling, te);
        }
        ItemStack out1 = te.inventory.getStackInSlot(4);
        ItemStack out2 = te.inventory.getStackInSlot(5);
        ItemStack out3 = te.inventory.getStackInSlot(6);
        ItemStack out4 = te.inventory.getStackInSlot(7);
        if (!out1.func_190926_b()) {
            RoadFactoryRenderer.renderBlock(buffer, x, y, z, meta, out1, 0);
        }
        if (!out2.func_190926_b()) {
            RoadFactoryRenderer.renderBlock(buffer, x, y, z, meta, out2, 1);
        }
        if (!out3.func_190926_b()) {
            RoadFactoryRenderer.renderBlock(buffer, x, y, z, meta, out3, 2);
        }
        if (!out4.func_190926_b()) {
            RoadFactoryRenderer.renderBlock(buffer, x, y, z, meta, out4, 3);
        }
    }

    private static void renderTankFluid(BufferBuilder buffer, double x, double y, double z, FluidStack fluid, int meta, boolean isFilling, RoadFactoryEntity te) {
        if (fluid != null) {
            TextureAtlasSprite sprite = Minecraft.func_71410_x().func_147117_R().func_110572_b(fluid.getFluid().getStill(fluid).toString());
            if (meta == 0) {
                RenderHelper.renderTankFluid(buffer, x, y, z, 1.5f, 0.25f, 12.0f, 2.5f, 11.75f, 2.5f, fluid.amount, 320000, sprite);
            }
            if (meta == 1) {
                RenderHelper.renderTankFluid(buffer, x, y, z, 1.5f, 0.25f, 1.5f, 2.5f, 11.75f, 2.5f, fluid.amount, 320000, sprite);
            }
            if (meta == 2) {
                RenderHelper.renderTankFluid(buffer, x, y, z, 12.0f, 0.25f, 1.5f, 2.5f, 11.75f, 2.5f, fluid.amount, 320000, sprite);
            }
            if (meta == 3) {
                RenderHelper.renderTankFluid(buffer, x, y, z, 12.0f, 0.25f, 12.0f, 2.5f, 11.75f, 2.5f, fluid.amount, 320000, sprite);
            }
            if (isFilling) {
                if (meta == 0) {
                    RenderHelper.renderTankFluid(buffer, x, y, z, 2.5f, 0.25f, 13.0f, 0.5f, 12.0f, 0.5f, fluid.amount, 320000, sprite);
                }
                if (meta == 1) {
                    RenderHelper.renderTankFluid(buffer, x, y, z, 2.5f, 0.25f, 2.5f, 0.5f, 12.0f, 0.5f, fluid.amount, 320000, sprite);
                }
                if (meta == 2) {
                    RenderHelper.renderTankFluid(buffer, x, y, z, 13.0f, 0.25f, 2.5f, 0.5f, 12.0f, 0.5f, fluid.amount, 320000, sprite);
                }
                if (meta == 3) {
                    RenderHelper.renderTankFluid(buffer, x, y, z, 13.0f, 0.25f, 13.0f, 0.5f, 12.0f, 0.5f, fluid.amount, 320000, sprite);
                }
            }
        }
    }

    private static void renderBlock(BufferBuilder buffer, double x, double y, double z, int meta, ItemStack stack, int slot) {
        if (stack.func_77973_b() instanceof ItemBlock) {
            float offset = 3.25f * p * (float)slot;
            ItemBlock ib = (ItemBlock)stack.func_77973_b();
            IBlockState state = ib.func_179223_d().func_176203_a(stack.func_77952_i());
            IBakedModel model = Minecraft.func_71410_x().func_175602_ab().func_175023_a().func_178125_b(state);
            TextureAtlasSprite sprite = model.func_177554_e();
            if (meta == 0) {
                RenderHelper.renderCube(buffer, x, y, z, 12.125f * p, 4.25f * p, 2.375f * p + offset, 1.5f * p, 1.5f * p, 1.5f * p, sprite);
            }
            if (meta == 1) {
                RenderHelper.renderCube(buffer, x, y, z, 12.125f * p - offset, 4.25f * p, 12.125f * p, 1.5f * p, 1.5f * p, 1.5f * p, sprite);
            }
            if (meta == 2) {
                RenderHelper.renderCube(buffer, x, y, z, 2.375f * p, 4.25f * p, 12.125f * p - offset, 1.5f * p, 1.5f * p, 1.5f * p, sprite);
            }
            if (meta == 3) {
                RenderHelper.renderCube(buffer, x, y, z, 2.375f * p + offset, 4.25f * p, 2.375f * p, 1.5f * p, 1.5f * p, 1.5f * p, sprite);
            }
        }
    }
}

