/*
 * Decompiled with CFR 0.152.
 */
package com.silvaniastudios.roads.blocks.tileentities.tarmaccutter;

import com.silvaniastudios.roads.RoadsConfig;
import com.silvaniastudios.roads.blocks.tileentities.FREnergyStorage;
import com.silvaniastudios.roads.blocks.tileentities.tarmaccutter.TarmacCutterContainer;
import com.silvaniastudios.roads.blocks.tileentities.tarmaccutter.TarmacCutterEntity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.energy.CapabilityEnergy;

public class TarmacCutterElectricEntity
extends TarmacCutterEntity
implements ITickable,
ICapabilityProvider {
    public boolean isProcessing = false;
    int consumedEnergy = 0;
    public FREnergyStorage energy;

    public TarmacCutterElectricEntity() {
        this.energy = new FREnergyStorage(RoadsConfig.machine.electricTarmacCutterEnergyStorage, RoadsConfig.machine.electricTarmacCutterEnergyTransferRate){};
    }

    @Override
    public Container createContainer(EntityPlayer player) {
        return new TarmacCutterContainer(player.field_71071_by, this, true);
    }

    @Override
    public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
        if (capability == CapabilityEnergy.ENERGY) {
            return this.getCapability(capability, facing) != null;
        }
        return super.hasCapability(capability, facing);
    }

    @Override
    public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
        if (capability == CapabilityEnergy.ENERGY) {
            return (T)CapabilityEnergy.ENERGY.cast((Object)this.energy);
        }
        return super.getCapability(capability, facing);
    }

    @Override
    public void func_73660_a() {
        if (this.energy.getEnergyStored() > RoadsConfig.machine.electricTarmacCutterEnergyConsumption) {
            int ept = RoadsConfig.machine.electricTarmacCutterEnergyConsumption / RoadsConfig.machine.electricTarmacCutterTickRate;
            if (this.timerCount < RoadsConfig.machine.electricTarmacCutterTickRate) {
                if (this.shouldTick()) {
                    this.isProcessing = true;
                    ++this.timerCount;
                    this.energy.extractEnergy(ept, false);
                    this.consumedEnergy += ept;
                } else {
                    this.isProcessing = false;
                    this.timerCount = 0;
                }
            } else {
                if (this.consumedEnergy < RoadsConfig.machine.electricTarmacCutterEnergyConsumption) {
                    this.energy.extractEnergy(RoadsConfig.machine.electricTarmacCutterEnergyConsumption - this.consumedEnergy, false);
                }
                this.consumedEnergy = 0;
                this.process();
                if (!this.field_145850_b.field_72995_K) {
                    this.sendUpdates();
                }
                this.timerCount = 0;
            }
        }
    }

    @Override
    public void readNBT(NBTTagCompound nbt) {
        if (nbt.func_74764_b("items")) {
            this.inventory.deserializeNBT((NBTTagCompound)nbt.func_74781_a("items"));
        }
        if (nbt.func_74764_b("energy")) {
            this.energy.deserializeNBT((NBTTagCompound)nbt.func_74781_a("energy"));
        }
    }

    @Override
    public NBTTagCompound writeNBT(NBTTagCompound nbt) {
        nbt.func_74782_a("items", (NBTBase)this.inventory.serializeNBT());
        nbt.func_74782_a("energy", (NBTBase)this.energy.serializeNBT());
        return nbt;
    }
}

