/*
 * Decompiled with CFR 0.152.
 */
package com.silvaniastudios.roads.blocks.tileentities.distiller;

import com.silvaniastudios.roads.FurenikusRoads;
import com.silvaniastudios.roads.RoadsConfig;
import com.silvaniastudios.roads.blocks.tileentities.RoadTileEntity;
import com.silvaniastudios.roads.blocks.tileentities.distiller.TarDistillerBlock;
import com.silvaniastudios.roads.blocks.tileentities.distiller.TarDistillerContainer;
import com.silvaniastudios.roads.blocks.tileentities.distiller.TarDistillerStackHandler;
import com.silvaniastudios.roads.blocks.tileentities.recipes.RecipeRegistry;
import com.silvaniastudios.roads.blocks.tileentities.recipes.TarDistillerRecipes;
import com.silvaniastudios.roads.blocks.tileentities.roadfactory.RoadFactoryBlock;
import com.silvaniastudios.roads.blocks.tileentities.roadfactory.RoadFactoryEntity;
import com.silvaniastudios.roads.fluids.FRFluids;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.inventory.Container;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.ItemStackHandler;

public class TarDistillerEntity
extends RoadTileEntity
implements ITickable,
ICapabilityProvider {
    public int last_fuel_cap = 20000;
    public int timerCount = 0;
    public static final int TANK_CAP = 320000;
    public ItemStackHandler inventory = new ItemStackHandler(10){

        public boolean isItemValid(int slot, @Nonnull ItemStack stack) {
            return true;
        }

        protected void onContentsChanged(int slot) {
            TarDistillerEntity.this.func_70296_d();
        }
    };
    public TarDistillerStackHandler interactable_inv = new TarDistillerStackHandler(this.inventory, this.hasCapability(CapabilityEnergy.ENERGY, null));
    public FluidTank fluidInput = new FluidTank(320000){

        public boolean canFillFluidType(FluidStack fluid) {
            return true;
        }
    };
    public FluidTank fluidOutput1 = new FluidTank(320000){

        public boolean canFillFluidType(FluidStack fluid) {
            return fluid.getFluid() == FRFluids.tar;
        }
    };
    public FluidTank fluidOutput2 = new FluidTank(320000){

        public boolean canFillFluidType(FluidStack fluid) {
            return this.canFill();
        }
    };
    int lastFluidInput = 0;
    int lastFluidOutput1 = 0;
    int lastFluidOutput2 = 0;

    public Container createContainer(EntityPlayer player) {
        return new TarDistillerContainer(player.field_71071_by, this, false);
    }

    public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return this.getCapability(capability, facing) != null;
        }
        if (capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
            return this.getCapability(capability, facing) != null;
        }
        return super.hasCapability(capability, facing);
    }

    public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            if (facing != null) {
                return (T)CapabilityItemHandler.ITEM_HANDLER_CAPABILITY.cast((Object)this.interactable_inv);
            }
            return (T)CapabilityItemHandler.ITEM_HANDLER_CAPABILITY.cast((Object)this.inventory);
        }
        if (capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
            EnumFacing sideLeft = EnumFacing.WEST;
            EnumFacing sideRight = EnumFacing.EAST;
            EnumFacing sideUp = EnumFacing.UP;
            EnumFacing sideDown = EnumFacing.DOWN;
            IBlockState state = this.field_145850_b.func_180495_p(this.field_174879_c);
            if (state.func_177230_c() instanceof TarDistillerBlock) {
                TarDistillerBlock block = (TarDistillerBlock)state.func_177230_c();
                int meta = block.func_176201_c(state);
                if (meta == 1) {
                    sideLeft = EnumFacing.NORTH;
                    sideRight = EnumFacing.SOUTH;
                }
                if (meta == 2) {
                    sideLeft = EnumFacing.EAST;
                    sideRight = EnumFacing.WEST;
                }
                if (meta == 3) {
                    sideLeft = EnumFacing.SOUTH;
                    sideRight = EnumFacing.NORTH;
                }
                if (this.fluidOutput1.getFluidAmount() > 0 && (facing == sideRight || facing == sideDown)) {
                    return (T)CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY.cast((Object)this.fluidOutput1);
                }
                if (facing == sideRight || facing == sideDown) {
                    return (T)CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY.cast((Object)this.fluidOutput2);
                }
                if (facing == sideLeft || facing == sideUp) {
                    return (T)CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY.cast((Object)this.fluidInput);
                }
            }
        }
        return (T)super.getCapability(capability, facing);
    }

    public void func_73660_a() {
        if (this.fuel_remaining > 0) {
            --this.fuel_remaining;
        } else if (this.fuel_remaining <= 0) {
            if (this.inventory.getStackInSlot(3).func_77973_b() == Items.field_151129_at) {
                this.fuel_remaining = 20000;
                this.inventory.setStackInSlot(3, new ItemStack(Items.field_151133_ar));
                this.sendUpdates();
            } else {
                this.timerCount = 0;
                return;
            }
        }
        if (this.fuel_remaining > 0) {
            this.transferTar();
        }
        if (this.timerCount < RoadsConfig.machine.tarDistillerTickRate) {
            this.timerCount = this.shouldTick() ? ++this.timerCount : 0;
        } else {
            if (this.fuel_remaining > 0) {
                this.process();
            }
            this.timerCount = 0;
        }
        if (!(this.field_145850_b.field_72995_K || this.lastFluidInput == this.fluidInput.getFluidAmount() && this.lastFluidOutput1 == this.fluidOutput1.getFluidAmount() && this.lastFluidOutput2 == this.fluidOutput2.getFluidAmount())) {
            this.lastFluidInput = this.fluidInput.getFluidAmount();
            this.lastFluidOutput1 = this.fluidOutput1.getFluidAmount();
            this.lastFluidOutput2 = this.fluidOutput2.getFluidAmount();
            this.sendUpdates();
        }
    }

    public void process() {
        FurenikusRoads.debug(2, "Tar Distiller at" + this.formatPosition(this.field_174879_c) + "processing");
        if (!this.field_145850_b.field_72995_K) {
            boolean hasChanges = false;
            ItemStack fluid_in = this.inventory.getStackInSlot(4);
            FluidStack fluidStack = null;
            if (fluid_in.func_77977_a().compareTo("item.forge.bucketFilled") == 0) {
                fluidStack = FluidUtil.getFluidContained((ItemStack)fluid_in);
            } else if (fluid_in.func_77973_b() == Items.field_151131_as) {
                fluidStack = new FluidStack(FluidRegistry.WATER, 1000);
            }
            if (fluidStack != null) {
                if (this.fluidInput.getFluid() != null) {
                    if (this.fluidInput.getFluid().getFluid() == fluidStack.getFluid() && fluidStack.amount <= this.fluidInput.getFluidAmount() + fluidStack.amount) {
                        this.fluidInput.fill(fluidStack, true);
                    }
                } else {
                    this.fluidInput.fill(fluidStack, true);
                }
            }
            ItemStack fluid_out_1 = this.inventory.getStackInSlot(5);
            ItemStack fluid_out_1_bucket = this.inventory.getStackInSlot(8);
            if (fluid_out_1_bucket.func_77973_b() == Items.field_151133_ar && this.fluidOutput1 != null && fluid_out_1.func_190926_b() && this.fluidOutput1.getFluidAmount() >= 1000) {
                Fluid fluid = this.fluidOutput1.getFluid().getFluid();
                ItemStack bucket = FluidUtil.getFilledBucket((FluidStack)this.fluidOutput1.getFluid());
                this.fluidOutput1.drain(new FluidStack(fluid, 1000), true);
                this.inventory.setStackInSlot(5, bucket);
                fluid_out_1_bucket.func_190920_e(fluid_out_1_bucket.func_190916_E() - 1);
                hasChanges = true;
            }
            ItemStack fluid_out_2 = this.inventory.getStackInSlot(6);
            ItemStack fluid_out_2_bucket = this.inventory.getStackInSlot(8);
            if (fluid_out_2_bucket.func_77973_b() == Items.field_151133_ar && this.fluidOutput2 != null && fluid_out_2.func_190926_b() && this.fluidOutput2.getFluidAmount() >= 1000) {
                Fluid fluid = this.fluidOutput2.getFluid().getFluid();
                ItemStack bucket = FluidUtil.getFilledBucket((FluidStack)this.fluidOutput2.getFluid());
                this.fluidOutput2.drain(new FluidStack(fluid, 1000), true);
                this.inventory.setStackInSlot(6, bucket);
                fluid_out_2_bucket.func_190920_e(fluid_out_2_bucket.func_190916_E() - 1);
                hasChanges = true;
            }
            if (hasChanges) {
                this.sendUpdates();
            }
            for (int i = 0; i < RecipeRegistry.tarDistillerRecipes.size(); ++i) {
                TarDistillerRecipes recipe = RecipeRegistry.tarDistillerRecipes.get(i);
                if (!recipe.canFullyCraft(this.inventory, this.fluidInput, this.fluidOutput1, this.fluidOutput2)) continue;
                recipe.processCrafting(this.inventory, this.fluidInput, this.fluidOutput1, this.fluidOutput2);
                this.sendUpdates();
                return;
            }
        }
    }

    public boolean transferTar() {
        IBlockState blockRight;
        Block blockHere = this.field_145850_b.func_180495_p(this.field_174879_c).func_177230_c();
        EnumFacing getRight = EnumFacing.EAST;
        if (blockHere.func_176201_c(this.getState()) == 0) {
            getRight = EnumFacing.EAST;
        }
        if (blockHere.func_176201_c(this.getState()) == 1) {
            getRight = EnumFacing.SOUTH;
        }
        if (blockHere.func_176201_c(this.getState()) == 2) {
            getRight = EnumFacing.WEST;
        }
        if (blockHere.func_176201_c(this.getState()) == 3) {
            getRight = EnumFacing.NORTH;
        }
        if ((blockRight = this.field_145850_b.func_180495_p(this.field_174879_c.func_177972_a(getRight))).func_177230_c() instanceof RoadFactoryBlock && this.field_145850_b.func_175625_s(this.field_174879_c.func_177972_a(getRight)) != null) {
            RoadFactoryEntity rfEntity = (RoadFactoryEntity)this.field_145850_b.func_175625_s(this.field_174879_c.func_177972_a(getRight));
            int transfer = RoadsConfig.machine.tarTransferRate;
            if (this.fluidOutput1.getFluidAmount() >= transfer) {
                if (rfEntity.tarFluid.getFluidAmount() + transfer <= rfEntity.tarFluid.getCapacity()) {
                    FluidStack fluid = this.fluidOutput1.drain(new FluidStack((Fluid)FRFluids.tar, transfer), true);
                    rfEntity.tarFluid.fill(fluid, true);
                    rfEntity.sendUpdates();
                    return true;
                }
            } else if (this.fluidOutput1.getFluidAmount() > 0 && rfEntity.tarFluid.getFluidAmount() + this.fluidOutput1.getFluidAmount() <= rfEntity.tarFluid.getCapacity()) {
                FluidStack fluid = this.fluidOutput1.drain(new FluidStack((Fluid)FRFluids.tar, this.fluidOutput1.getFluidAmount()), true);
                rfEntity.tarFluid.fill(fluid, true);
                rfEntity.sendUpdates();
                return true;
            }
        }
        return false;
    }

    public boolean shouldTick() {
        for (int i = 0; i < RecipeRegistry.tarDistillerRecipes.size(); ++i) {
            TarDistillerRecipes recipe = RecipeRegistry.tarDistillerRecipes.get(i);
            if (!recipe.canFullyCraft(this.inventory, this.fluidInput, this.fluidOutput1, this.fluidOutput2)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void readNBT(NBTTagCompound nbt) {
        if (nbt.func_74764_b("items")) {
            this.inventory.deserializeNBT((NBTTagCompound)nbt.func_74781_a("items"));
        }
        if (nbt.func_74764_b("fluid_in_1")) {
            this.fluidInput.readFromNBT((NBTTagCompound)nbt.func_74781_a("fluid_in_1"));
        }
        if (nbt.func_74764_b("fluid_out_1")) {
            this.fluidOutput1.readFromNBT((NBTTagCompound)nbt.func_74781_a("fluid_out_1"));
        }
        if (nbt.func_74764_b("fluid_out_2")) {
            this.fluidOutput2.readFromNBT((NBTTagCompound)nbt.func_74781_a("fluid_out_2"));
        }
        this.fuel_remaining = nbt.func_74762_e("fuel");
    }

    @Override
    public NBTTagCompound writeNBT(NBTTagCompound nbt) {
        nbt.func_74782_a("items", (NBTBase)this.inventory.serializeNBT());
        nbt.func_74782_a("fluid_in_1", (NBTBase)this.fluidInput.writeToNBT(new NBTTagCompound()));
        nbt.func_74782_a("fluid_out_1", (NBTBase)this.fluidOutput1.writeToNBT(new NBTTagCompound()));
        nbt.func_74782_a("fluid_out_2", (NBTBase)this.fluidOutput2.writeToNBT(new NBTTagCompound()));
        nbt.func_74768_a("fuel", this.fuel_remaining);
        return nbt;
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound nbt) {
        super.func_189515_b(nbt);
        return this.writeNBT(nbt);
    }

    @Override
    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.readNBT(nbt);
    }
}

