/*
 * Decompiled with CFR 0.152.
 */
package com.silvaniastudios.roads.blocks.paint.customs;

import com.silvaniastudios.roads.FurenikusRoads;
import com.silvaniastudios.roads.blocks.PaintColour;
import com.silvaniastudios.roads.blocks.enums.EnumFourLengthConnectable;
import com.silvaniastudios.roads.blocks.paint.customs.CustomPaintBlock;
import com.silvaniastudios.roads.blocks.paint.properties.PaintGrid;
import net.minecraft.block.Block;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class Custom1x4PaintBlock
extends CustomPaintBlock {
    public static final PropertyEnum<EnumFourLengthConnectable> CONNECT = PropertyEnum.func_177709_a((String)"position_rotation", EnumFourLengthConnectable.class);
    private boolean horizontal = false;

    public Custom1x4PaintBlock(String name, String localName, PaintGrid[] grids, String category, PaintColour colour, boolean horizontal) {
        super(name, localName, CustomPaintBlock.EnumPaintType.MULTI_4x1, grids, category, new int[]{0}, colour);
        this.horizontal = horizontal;
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a(CONNECT, (Comparable)((Object)EnumFourLengthConnectable.NORTH_TOP)));
    }

    public Custom1x4PaintBlock(String name, PaintGrid[] grids, String category, PaintColour colour, boolean icon) {
        super(name, CustomPaintBlock.EnumPaintType.MULTI_4x1, grids, category, new int[]{0}, colour, icon ? FurenikusRoads.tab_paint_icons : FurenikusRoads.tab_paint_junction);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a(CONNECT, (Comparable)((Object)EnumFourLengthConnectable.NORTH_TOP)));
    }

    @Override
    public IBlockState getStateForPlacement(World world, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer, EnumHand hand) {
        EnumFacing placerFacing = placer.func_174811_aO();
        int placeMeta = 0;
        IBlockState northBlock = world.func_180495_p(pos.func_177972_a(EnumFacing.NORTH));
        IBlockState eastBlock = world.func_180495_p(pos.func_177972_a(EnumFacing.EAST));
        IBlockState southBlock = world.func_180495_p(pos.func_177972_a(EnumFacing.SOUTH));
        IBlockState westBlock = world.func_180495_p(pos.func_177972_a(EnumFacing.WEST));
        if (placerFacing.equals((Object)EnumFacing.NORTH)) {
            placeMeta = 3;
        }
        if (placerFacing.equals((Object)EnumFacing.EAST)) {
            placeMeta = 7;
        }
        if (placerFacing.equals((Object)EnumFacing.SOUTH)) {
            placeMeta = 11;
        }
        if (placerFacing.equals((Object)EnumFacing.WEST)) {
            placeMeta = 15;
        }
        if (this.horizontal) {
            southBlock = westBlock;
            westBlock = northBlock;
            northBlock = eastBlock;
            eastBlock = world.func_180495_p(pos.func_177972_a(EnumFacing.SOUTH));
        }
        if (placerFacing.equals((Object)EnumFacing.NORTH) || placerFacing.equals((Object)EnumFacing.SOUTH)) {
            if (southBlock.func_177230_c().getRegistryName().equals((Object)this.getRegistryName())) {
                int southMeta = this.func_176201_c(southBlock);
                if (southMeta < 11 && southMeta > 7) {
                    placeMeta = southMeta + 1;
                }
                if (southMeta < 4 && southMeta > 0) {
                    placeMeta = southMeta - 1;
                }
            }
            if (northBlock.func_177230_c().getRegistryName().equals((Object)this.getRegistryName())) {
                int northMeta = this.func_176201_c(northBlock);
                if (northMeta < 3) {
                    placeMeta = northMeta + 1;
                }
                if (northMeta < 12 && northMeta > 8) {
                    placeMeta = northMeta - 1;
                }
            }
        }
        if (placerFacing.equals((Object)EnumFacing.EAST) || placerFacing.equals((Object)EnumFacing.WEST)) {
            if (westBlock.func_177230_c().getRegistryName().equals((Object)this.getRegistryName())) {
                int westMeta = this.func_176201_c(westBlock);
                if (westMeta < 15 && westMeta > 11) {
                    placeMeta = westMeta + 1;
                }
                if (westMeta < 8 && westMeta > 4) {
                    placeMeta = westMeta - 1;
                }
            }
            if (eastBlock.func_177230_c().getRegistryName().equals((Object)this.getRegistryName())) {
                int eastMeta = this.func_176201_c(eastBlock);
                if (eastMeta < 7 && eastMeta > 3) {
                    placeMeta = eastMeta + 1;
                }
                if (eastMeta < 16 && eastMeta > 12) {
                    placeMeta = eastMeta - 1;
                }
            }
        }
        return this.func_176223_P().func_177226_a(CONNECT, (Comparable)((Object)EnumFourLengthConnectable.byMetadata(placeMeta)));
    }

    @Override
    public int func_176201_c(IBlockState state) {
        return ((EnumFourLengthConnectable)((Object)state.func_177229_b(CONNECT))).getIndex();
    }

    @Override
    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a(CONNECT, (Comparable)((Object)EnumFourLengthConnectable.byMetadata(meta)));
    }

    @Override
    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{CONNECT});
    }
}

