/*
 * Decompiled with CFR 0.152.
 */
package com.silvaniastudios.roads.blocks.paint;

import com.silvaniastudios.roads.FurenikusRoads;
import com.silvaniastudios.roads.blocks.PaintColour;
import com.silvaniastudios.roads.blocks.enums.EnumFourLengthConnectable;
import com.silvaniastudios.roads.blocks.enums.IMetaBlockName;
import com.silvaniastudios.roads.blocks.paint.ChevronPaintBlock;
import com.silvaniastudios.roads.blocks.paint.PaintBlockBase;
import com.silvaniastudios.roads.blocks.paint.uniques.ChevronIconPaintBlock;
import net.minecraft.block.Block;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class JunctionFilterLinePaintBlock
extends PaintBlockBase
implements IMetaBlockName {
    public static final PropertyEnum<EnumFourLengthConnectable> TYPE_ROT = PropertyEnum.func_177709_a((String)"position_rotation", EnumFourLengthConnectable.class);
    public static final PropertyEnum<EnumChevronConnections> CONNECT = PropertyEnum.func_177709_a((String)"connect", EnumChevronConnections.class);
    boolean leftSide = false;

    public JunctionFilterLinePaintBlock(String name, boolean leftSide, String category, int[] coreMetas, boolean dynamic, PaintColour colour) {
        super(name, category, coreMetas, dynamic, colour);
        this.leftSide = leftSide;
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a(TYPE_ROT, (Comparable)((Object)EnumFourLengthConnectable.NORTH_TOP)).func_177226_a(CONNECT, (Comparable)((Object)EnumChevronConnections.NONE)));
        this.func_149647_a(FurenikusRoads.tab_paint_junction);
    }

    public IBlockState getStateForPlacement(World world, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer, EnumHand hand) {
        EnumFacing placerFacing = placer.func_174811_aO();
        int placeMeta = 0;
        IBlockState northBlock = world.func_180495_p(pos.func_177972_a(EnumFacing.NORTH));
        IBlockState eastBlock = world.func_180495_p(pos.func_177972_a(EnumFacing.EAST));
        IBlockState southBlock = world.func_180495_p(pos.func_177972_a(EnumFacing.SOUTH));
        IBlockState westBlock = world.func_180495_p(pos.func_177972_a(EnumFacing.WEST));
        int northMeta = -1;
        int eastMeta = -1;
        int southMeta = -1;
        int westMeta = -1;
        if (northBlock.func_177230_c() instanceof JunctionFilterLinePaintBlock) {
            northMeta = this.func_176201_c(northBlock);
        }
        if (eastBlock.func_177230_c() instanceof JunctionFilterLinePaintBlock) {
            eastMeta = this.func_176201_c(eastBlock);
        }
        if (southBlock.func_177230_c() instanceof JunctionFilterLinePaintBlock) {
            southMeta = this.func_176201_c(southBlock);
        }
        if (westBlock.func_177230_c() instanceof JunctionFilterLinePaintBlock) {
            westMeta = this.func_176201_c(westBlock);
        }
        if (placerFacing.equals((Object)EnumFacing.NORTH)) {
            placeMeta = 3;
            if (this.leftSide ? eastBlock.func_177230_c() instanceof JunctionFilterLinePaintBlock && eastMeta == 0 : westBlock.func_177230_c() instanceof JunctionFilterLinePaintBlock && westMeta == 0) {
                return this.func_176223_P().func_177226_a(TYPE_ROT, (Comparable)((Object)EnumFourLengthConnectable.byMetadata(8)));
            }
            if (southBlock.func_177230_c() instanceof JunctionFilterLinePaintBlock) {
                if (southMeta == 8) {
                    return this.func_176223_P().func_177226_a(TYPE_ROT, (Comparable)((Object)EnumFourLengthConnectable.byMetadata(3)));
                }
                if (southMeta < 11 && southMeta > 7) {
                    return this.func_176223_P().func_177226_a(TYPE_ROT, (Comparable)((Object)EnumFourLengthConnectable.byMetadata(southMeta + 1)));
                }
                if (southMeta < 4 && southMeta > 0) {
                    return this.func_176223_P().func_177226_a(TYPE_ROT, (Comparable)((Object)EnumFourLengthConnectable.byMetadata(southMeta - 1)));
                }
            }
            if (northBlock.func_177230_c() instanceof JunctionFilterLinePaintBlock) {
                if (northMeta == 3) {
                    return this.func_176223_P().func_177226_a(TYPE_ROT, (Comparable)((Object)EnumFourLengthConnectable.byMetadata(8)));
                }
                if (northMeta < 3) {
                    return this.func_176223_P().func_177226_a(TYPE_ROT, (Comparable)((Object)EnumFourLengthConnectable.byMetadata(northMeta + 1)));
                }
                if (northMeta < 12 && northMeta > 8) {
                    return this.func_176223_P().func_177226_a(TYPE_ROT, (Comparable)((Object)EnumFourLengthConnectable.byMetadata(northMeta - 1)));
                }
            }
        }
        if (placerFacing.equals((Object)EnumFacing.SOUTH)) {
            placeMeta = 11;
            if (this.leftSide ? westBlock.func_177230_c() instanceof JunctionFilterLinePaintBlock && westMeta == 8 : eastBlock.func_177230_c() instanceof JunctionFilterLinePaintBlock && eastMeta == 8) {
                return this.func_176223_P().func_177226_a(TYPE_ROT, (Comparable)((Object)EnumFourLengthConnectable.byMetadata(0)));
            }
            if (northBlock.func_177230_c() instanceof JunctionFilterLinePaintBlock) {
                if (northMeta == 0) {
                    return this.func_176223_P().func_177226_a(TYPE_ROT, (Comparable)((Object)EnumFourLengthConnectable.byMetadata(11)));
                }
                if (northMeta < 3) {
                    return this.func_176223_P().func_177226_a(TYPE_ROT, (Comparable)((Object)EnumFourLengthConnectable.byMetadata(northMeta + 1)));
                }
                if (northMeta < 12 && northMeta > 8) {
                    return this.func_176223_P().func_177226_a(TYPE_ROT, (Comparable)((Object)EnumFourLengthConnectable.byMetadata(northMeta - 1)));
                }
            }
            if (southBlock.func_177230_c() instanceof JunctionFilterLinePaintBlock) {
                if (southMeta == 11) {
                    return this.func_176223_P().func_177226_a(TYPE_ROT, (Comparable)((Object)EnumFourLengthConnectable.byMetadata(0)));
                }
                if (southMeta < 11 && southMeta > 7) {
                    return this.func_176223_P().func_177226_a(TYPE_ROT, (Comparable)((Object)EnumFourLengthConnectable.byMetadata(southMeta + 1)));
                }
                if (southMeta < 4 && southMeta > 0) {
                    return this.func_176223_P().func_177226_a(TYPE_ROT, (Comparable)((Object)EnumFourLengthConnectable.byMetadata(southMeta - 1)));
                }
            }
        }
        if (placerFacing.equals((Object)EnumFacing.EAST)) {
            placeMeta = 7;
            if (this.leftSide ? southBlock.func_177230_c() instanceof JunctionFilterLinePaintBlock && southMeta == 4 : northBlock.func_177230_c() instanceof JunctionFilterLinePaintBlock && northMeta == 4) {
                return this.func_176223_P().func_177226_a(TYPE_ROT, (Comparable)((Object)EnumFourLengthConnectable.byMetadata(12)));
            }
            if (westBlock.func_177230_c() instanceof JunctionFilterLinePaintBlock) {
                if (westMeta == 12) {
                    return this.func_176223_P().func_177226_a(TYPE_ROT, (Comparable)((Object)EnumFourLengthConnectable.byMetadata(7)));
                }
                if (westMeta > 11 && westMeta < 15) {
                    return this.func_176223_P().func_177226_a(TYPE_ROT, (Comparable)((Object)EnumFourLengthConnectable.byMetadata(westMeta + 1)));
                }
                if (westMeta > 4 && westMeta < 8) {
                    return this.func_176223_P().func_177226_a(TYPE_ROT, (Comparable)((Object)EnumFourLengthConnectable.byMetadata(westMeta - 1)));
                }
            }
            if (eastBlock.func_177230_c() instanceof JunctionFilterLinePaintBlock) {
                if (eastMeta == 7) {
                    return this.func_176223_P().func_177226_a(TYPE_ROT, (Comparable)((Object)EnumFourLengthConnectable.byMetadata(12)));
                }
                if (eastMeta > 3 && eastMeta < 7) {
                    return this.func_176223_P().func_177226_a(TYPE_ROT, (Comparable)((Object)EnumFourLengthConnectable.byMetadata(eastMeta + 1)));
                }
                if (eastMeta > 12) {
                    return this.func_176223_P().func_177226_a(TYPE_ROT, (Comparable)((Object)EnumFourLengthConnectable.byMetadata(eastMeta - 1)));
                }
            }
        }
        if (placerFacing.equals((Object)EnumFacing.WEST)) {
            placeMeta = 15;
            if (this.leftSide ? northBlock.func_177230_c() instanceof JunctionFilterLinePaintBlock && northMeta == 12 : southBlock.func_177230_c() instanceof JunctionFilterLinePaintBlock && southMeta == 12) {
                return this.func_176223_P().func_177226_a(TYPE_ROT, (Comparable)((Object)EnumFourLengthConnectable.byMetadata(4)));
            }
            if (eastBlock.func_177230_c() instanceof JunctionFilterLinePaintBlock) {
                if (eastMeta == 4) {
                    return this.func_176223_P().func_177226_a(TYPE_ROT, (Comparable)((Object)EnumFourLengthConnectable.byMetadata(15)));
                }
                if (eastMeta > 3 && eastMeta < 7) {
                    return this.func_176223_P().func_177226_a(TYPE_ROT, (Comparable)((Object)EnumFourLengthConnectable.byMetadata(eastMeta + 1)));
                }
                if (eastMeta > 12) {
                    return this.func_176223_P().func_177226_a(TYPE_ROT, (Comparable)((Object)EnumFourLengthConnectable.byMetadata(eastMeta - 1)));
                }
            }
            if (westBlock.func_177230_c() instanceof JunctionFilterLinePaintBlock) {
                if (westMeta == 15) {
                    return this.func_176223_P().func_177226_a(TYPE_ROT, (Comparable)((Object)EnumFourLengthConnectable.byMetadata(4)));
                }
                if (westMeta > 11 && westMeta < 15) {
                    return this.func_176223_P().func_177226_a(TYPE_ROT, (Comparable)((Object)EnumFourLengthConnectable.byMetadata(westMeta + 1)));
                }
                if (westMeta > 4 && westMeta < 8) {
                    return this.func_176223_P().func_177226_a(TYPE_ROT, (Comparable)((Object)EnumFourLengthConnectable.byMetadata(westMeta - 1)));
                }
            }
        }
        return this.func_176223_P().func_177226_a(TYPE_ROT, (Comparable)((Object)EnumFourLengthConnectable.byMetadata(placeMeta)));
    }

    public int func_176201_c(IBlockState state) {
        return ((EnumFourLengthConnectable)((Object)state.func_177229_b(TYPE_ROT))).getIndex();
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a(TYPE_ROT, (Comparable)((Object)EnumFourLengthConnectable.byMetadata(meta)));
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{TYPE_ROT, CONNECT});
    }

    public IBlockState func_176221_a(IBlockState state, IBlockAccess worldIn, BlockPos pos) {
        return state.func_177226_a(CONNECT, (Comparable)((Object)this.connectToChevron(worldIn, pos)));
    }

    @SideOnly(value=Side.CLIENT)
    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.CUTOUT_MIPPED;
    }

    private boolean isMidChevron(IBlockAccess world, BlockPos pos, EnumFacing facing) {
        Block block = world.func_180495_p(pos.func_177972_a(facing)).func_177230_c();
        return block.func_149739_a().contains("_chevron_mid");
    }

    private EnumChevronConnections connectToChevron(IBlockAccess world, BlockPos pos) {
        boolean blockWest;
        IBlockState state = world.func_180495_p(pos);
        int meta = this.func_176201_c(state);
        IBlockState stateNorth = world.func_180495_p(pos);
        IBlockState stateEast = world.func_180495_p(pos);
        IBlockState stateSouth = world.func_180495_p(pos);
        IBlockState stateWest = world.func_180495_p(pos);
        boolean blockNorth = world.func_180495_p(pos.func_177972_a(EnumFacing.NORTH)).func_177230_c() instanceof ChevronPaintBlock || this.isMidChevron(world, pos, EnumFacing.NORTH);
        boolean blockEast = world.func_180495_p(pos.func_177972_a(EnumFacing.EAST)).func_177230_c() instanceof ChevronPaintBlock || this.isMidChevron(world, pos, EnumFacing.EAST);
        boolean blockSouth = world.func_180495_p(pos.func_177972_a(EnumFacing.SOUTH)).func_177230_c() instanceof ChevronPaintBlock || this.isMidChevron(world, pos, EnumFacing.SOUTH);
        boolean bl = blockWest = world.func_180495_p(pos.func_177972_a(EnumFacing.WEST)).func_177230_c() instanceof ChevronPaintBlock || this.isMidChevron(world, pos, EnumFacing.WEST);
        if (blockNorth) {
            stateNorth = world.func_180495_p(pos.func_177972_a(EnumFacing.NORTH));
        }
        if (blockEast) {
            stateEast = world.func_180495_p(pos.func_177972_a(EnumFacing.EAST));
        }
        if (blockSouth) {
            stateSouth = world.func_180495_p(pos.func_177972_a(EnumFacing.SOUTH));
        }
        if (blockWest) {
            stateWest = world.func_180495_p(pos.func_177972_a(EnumFacing.WEST));
        }
        boolean blockSide = false;
        IBlockState stateSide = null;
        if (meta < 4) {
            if (this.leftSide) {
                blockSide = blockEast;
                stateSide = stateEast;
            } else {
                blockSide = blockWest;
                stateSide = stateWest;
            }
        }
        if (meta > 3 && meta < 8) {
            if (this.leftSide) {
                blockSide = blockSouth;
                stateSide = stateSouth;
            } else {
                blockSide = blockNorth;
                stateSide = stateNorth;
            }
        }
        if (meta > 7 && meta < 12) {
            if (this.leftSide) {
                blockSide = blockWest;
                stateSide = stateWest;
            } else {
                blockSide = blockEast;
                stateSide = stateEast;
            }
        }
        if (meta > 11) {
            if (this.leftSide) {
                blockSide = blockNorth;
                stateSide = stateNorth;
            } else {
                blockSide = blockSouth;
                stateSide = stateSouth;
            }
        }
        if (!blockSide) {
            boolean blockAbove = world.func_180495_p(pos.func_177972_a(EnumFacing.UP)).func_177230_c() instanceof ChevronPaintBlock;
            boolean blockBelow = world.func_180495_p(pos.func_177972_a(EnumFacing.DOWN)).func_177230_c() instanceof ChevronPaintBlock;
            if (blockAbove) {
                stateSide = world.func_180495_p(pos.func_177972_a(EnumFacing.UP));
                blockSide = true;
            } else if (blockBelow) {
                stateSide = world.func_180495_p(pos.func_177972_a(EnumFacing.DOWN));
                blockSide = true;
            }
        }
        if (blockSide) {
            ChevronIconPaintBlock mipb;
            int mipbMeta;
            ChevronPaintBlock.EnumJunctionConnections cnct = null;
            cnct = stateSide.func_177230_c() instanceof ChevronIconPaintBlock ? ((mipbMeta = (mipb = (ChevronIconPaintBlock)stateSide.func_177230_c()).func_176201_c(stateSide)) < 4 ? ChevronPaintBlock.EnumJunctionConnections.CHEVRON_B : (mipbMeta < 8 ? ChevronPaintBlock.EnumJunctionConnections.CHEVRON_A : (mipbMeta < 12 ? ChevronPaintBlock.EnumJunctionConnections.CHEVRON_THIN_B : ChevronPaintBlock.EnumJunctionConnections.CHEVRON_THIN_A))) : (ChevronPaintBlock.EnumJunctionConnections)((Object)stateSide.func_177228_b().get(ChevronPaintBlock.TYPE));
            if (cnct == null) {
                return EnumChevronConnections.TOP_CHEVRON_A;
            }
            if (cnct.equals((Object)ChevronPaintBlock.EnumJunctionConnections.CHEVRON_A)) {
                if (meta == 0 || meta == 4 || meta == 8 || meta == 12) {
                    return EnumChevronConnections.TOP_CHEVRON_A;
                }
                if (meta == 1 || meta == 5 || meta == 9 || meta == 13) {
                    return EnumChevronConnections.TOP_MID_CHEVRON_A;
                }
                if (meta == 2 || meta == 6 || meta == 10 || meta == 14) {
                    return EnumChevronConnections.BOTTOM_MID_CHEVRON_A;
                }
                if (meta == 3 || meta == 7 || meta == 11 || meta == 15) {
                    return EnumChevronConnections.BOTTOM_CHEVRON_A;
                }
            }
            if (cnct.equals((Object)ChevronPaintBlock.EnumJunctionConnections.CHEVRON_B)) {
                if (meta == 0 || meta == 4 || meta == 8 || meta == 12) {
                    return EnumChevronConnections.TOP_CHEVRON_B;
                }
                if (meta == 1 || meta == 5 || meta == 9 || meta == 13) {
                    return EnumChevronConnections.TOP_MID_CHEVRON_B;
                }
                if (meta == 2 || meta == 6 || meta == 10 || meta == 14) {
                    return EnumChevronConnections.BOTTOM_MID_CHEVRON_B;
                }
                if (meta == 3 || meta == 7 || meta == 11 || meta == 15) {
                    return EnumChevronConnections.BOTTOM_CHEVRON_B;
                }
            }
            if (cnct.equals((Object)ChevronPaintBlock.EnumJunctionConnections.CHEVRON_THIN_A)) {
                if (meta == 0 || meta == 4 || meta == 8 || meta == 12) {
                    return EnumChevronConnections.TOP_CHEVRON_THIN_A;
                }
                if (meta == 1 || meta == 5 || meta == 9 || meta == 13) {
                    return EnumChevronConnections.TOP_MID_CHEVRON_THIN_A;
                }
                if (meta == 2 || meta == 6 || meta == 10 || meta == 14) {
                    return EnumChevronConnections.BOTTOM_MID_CHEVRON_THIN_A;
                }
                if (meta == 3 || meta == 7 || meta == 11 || meta == 15) {
                    return EnumChevronConnections.BOTTOM_CHEVRON_THIN_A;
                }
            }
            if (cnct.equals((Object)ChevronPaintBlock.EnumJunctionConnections.CHEVRON_THIN_B)) {
                if (meta == 0 || meta == 4 || meta == 8 || meta == 12) {
                    return EnumChevronConnections.TOP_CHEVRON_THIN_B;
                }
                if (meta == 1 || meta == 5 || meta == 9 || meta == 13) {
                    return EnumChevronConnections.TOP_MID_CHEVRON_THIN_B;
                }
                if (meta == 2 || meta == 6 || meta == 10 || meta == 14) {
                    return EnumChevronConnections.BOTTOM_MID_CHEVRON_THIN_B;
                }
                if (meta == 3 || meta == 7 || meta == 11 || meta == 15) {
                    return EnumChevronConnections.BOTTOM_CHEVRON_THIN_B;
                }
            }
        }
        return EnumChevronConnections.NONE;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void initModel() {
        ModelLoader.setCustomModelResourceLocation((Item)Item.func_150898_a((Block)this), (int)0, (ModelResourceLocation)new ModelResourceLocation(this.getRegistryName(), "inventory"));
    }

    @Override
    public String getSpecialName(ItemStack stack) {
        return stack.func_77952_i() + "";
    }

    public static enum EnumChevronConnections implements IStringSerializable
    {
        NONE(0, "none"),
        TOP_CHEVRON_A(1, "top_chevron_a"),
        TOP_CHEVRON_B(2, "top_chevron_b"),
        TOP_CHEVRON_THIN_A(3, "top_chevron_thin_a"),
        TOP_CHEVRON_THIN_B(4, "top_chevron_thin_b"),
        TOP_MID_CHEVRON_A(5, "top_mid_chevron_a"),
        TOP_MID_CHEVRON_B(6, "top_mid_chevron_b"),
        TOP_MID_CHEVRON_THIN_A(7, "top_mid_chevron_thin_a"),
        TOP_MID_CHEVRON_THIN_B(8, "top_mid_chevron_thin_b"),
        BOTTOM_MID_CHEVRON_A(9, "bottom_mid_chevron_a"),
        BOTTOM_MID_CHEVRON_B(10, "bottom_mid_chevron_b"),
        BOTTOM_MID_CHEVRON_THIN_A(11, "bottom_mid_chevron_thin_a"),
        BOTTOM_MID_CHEVRON_THIN_B(12, "bottom_mid_chevron_thin_b"),
        BOTTOM_CHEVRON_A(13, "bottom_chevron_a"),
        BOTTOM_CHEVRON_B(14, "bottom_chevron_b"),
        BOTTOM_CHEVRON_THIN_A(15, "bottom_chevron_thin_a"),
        BOTTOM_CHEVRON_THIN_B(16, "bottom_chevron_thin_b");

        private static final EnumChevronConnections[] ID_LOOKUP;
        private final int id;
        private final String name;

        private EnumChevronConnections(int id, String name) {
            this.id = id;
            this.name = name;
        }

        public String func_176610_l() {
            return this.name;
        }

        public int getId() {
            return this.id;
        }

        public static EnumChevronConnections byId(int id) {
            if (id < 0 || id >= ID_LOOKUP.length) {
                id = 0;
            }
            return ID_LOOKUP[id];
        }

        static {
            ID_LOOKUP = new EnumChevronConnections[EnumChevronConnections.values().length];
            EnumChevronConnections[] enumChevronConnectionsArray = EnumChevronConnections.values();
            int n = enumChevronConnectionsArray.length;
            for (int i = 0; i < n; ++i) {
                EnumChevronConnections type;
                EnumChevronConnections.ID_LOOKUP[type.getId()] = type = enumChevronConnectionsArray[i];
            }
        }
    }
}

