/*
 * Decompiled with CFR 0.152.
 */
package forge.com.gitlab.cdagaming.craftpresence.utils.gui.integrations;

import com.gitlab.cdagaming.craftpresence.core.config.element.ColorData;
import forge.com.gitlab.cdagaming.craftpresence.CraftPresence;
import forge.com.gitlab.cdagaming.craftpresence.utils.CommandUtils;
import forge.com.gitlab.cdagaming.craftpresence.utils.gui.GuiUtils;
import forge.com.gitlab.cdagaming.craftpresence.utils.gui.RenderUtils;
import forge.com.gitlab.cdagaming.craftpresence.utils.gui.controls.ExtendedButtonControl;
import forge.com.gitlab.cdagaming.craftpresence.utils.gui.controls.ExtendedTextControl;
import forge.com.gitlab.cdagaming.craftpresence.utils.gui.controls.ScrollableListControl;
import forge.com.gitlab.cdagaming.craftpresence.utils.gui.widgets.DynamicWidget;
import io.github.cdagaming.unicore.impl.Tuple;
import io.github.cdagaming.unicore.utils.MathUtils;
import io.github.cdagaming.unicore.utils.StringUtils;
import java.awt.Color;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.util.ResourceLocation;
import org.lwjgl.input.Keyboard;
import org.lwjgl.input.Mouse;

public class ExtendedScreen
extends GuiScreen {
    private static int lastIndex = 0;
    public final GuiScreen parentScreen;
    public final GuiScreen currentScreen;
    private final List<Gui> extendedControls = StringUtils.newArrayList();
    private final List<DynamicWidget> extendedWidgets = StringUtils.newArrayList();
    private final List<ScrollableListControl> extendedLists = StringUtils.newArrayList();
    private Phase currentPhase = Phase.PREINIT;
    private boolean debugMode = false;
    private boolean verboseMode = false;
    private int screenX = 0;
    private int screenY = 0;
    private int lastMouseX = 0;
    private int lastMouseY = 0;
    private int lastMouseScroll = 0;
    private int contentHeight;
    private boolean canClose;
    private boolean isOverScreen;

    public ExtendedScreen(GuiScreen parentScreen) {
        this.setGameInstance(CraftPresence.instance);
        this.currentScreen = this;
        this.parentScreen = parentScreen;
        this.canClose = true;
        this.setContentHeight(0);
        this.setDebugMode(CommandUtils.isDebugMode());
        this.setVerboseMode(CommandUtils.isVerboseMode());
    }

    public ExtendedScreen() {
        this(null);
        this.canClose = false;
    }

    public ExtendedScreen(GuiScreen parentScreen, boolean debugMode) {
        this(parentScreen);
        this.setDebugMode(debugMode);
    }

    public ExtendedScreen(boolean debugMode) {
        this();
        this.setDebugMode(debugMode);
    }

    public ExtendedScreen(GuiScreen parentScreen, boolean debugMode, boolean verboseMode) {
        this(parentScreen, debugMode);
        this.setVerboseMode(verboseMode);
    }

    public ExtendedScreen(boolean debugMode, boolean verboseMode) {
        this(debugMode);
        this.setVerboseMode(verboseMode);
    }

    public static int getNextIndex() {
        return lastIndex++;
    }

    public static void resetIndex() {
        lastIndex = 0;
    }

    public static void copyToClipboard(String input) {
        ExtendedScreen.func_146275_d((String)StringUtils.normalize(input));
    }

    public void func_73866_w_() {
        super.func_73866_w_();
        this.clearData();
        Keyboard.enableRepeatEvents((boolean)true);
        this.currentPhase = Phase.INIT;
        this.initializeUi();
        this.currentPhase = Phase.READY;
    }

    public void clearData() {
        if (this.currentPhase != Phase.PREINIT) {
            this.currentPhase = Phase.PREINIT;
            this.setContentHeight(0);
            this.field_146292_n.clear();
            this.extendedControls.clear();
            this.extendedWidgets.clear();
            this.extendedLists.clear();
        }
    }

    public void initializeUi() {
        if (this.currentPhase == Phase.PREINIT) {
            this.func_73866_w_();
            return;
        }
        if (this.currentPhase == Phase.INIT) {
            this.resetMouseScroll();
            for (Gui extendedControl : this.getControls()) {
                if (!(extendedControl instanceof ExtendedScreen)) continue;
                ((ExtendedScreen)extendedControl).initializeUi();
            }
            this.refreshContentHeight();
        }
    }

    public void reloadUi() {
        this.func_175273_b(this.getGameInstance(), this.getScreenWidth(), this.getScreenHeight());
    }

    public void func_175273_b(@Nonnull Minecraft mcIn, int w, int h) {
        if (this.isLoaded()) {
            for (Gui extendedControl : this.getControls()) {
                if (!(extendedControl instanceof ExtendedScreen)) continue;
                ((ExtendedScreen)extendedControl).func_175273_b(mcIn, w, h);
            }
        }
        super.func_175273_b(mcIn, w, h);
    }

    @Nonnull
    protected <T extends GuiButton> T func_189646_b(@Nonnull T buttonIn) {
        return this.addControl(buttonIn);
    }

    @Nonnull
    public <T extends Gui> T addControl(@Nonnull T buttonIn) {
        if (buttonIn instanceof DynamicWidget && !this.extendedWidgets.contains(buttonIn)) {
            this.addWidget((DynamicWidget)buttonIn);
        }
        if (buttonIn instanceof GuiButton && !this.field_146292_n.contains(buttonIn)) {
            this.field_146292_n.add((GuiButton)buttonIn);
        }
        if (!this.extendedControls.contains(buttonIn)) {
            this.extendedControls.add(buttonIn);
        }
        return buttonIn;
    }

    @Nonnull
    public <T extends ScrollableListControl> T addList(@Nonnull T buttonIn) {
        if (!this.extendedLists.contains(buttonIn)) {
            this.extendedLists.add(buttonIn);
        }
        return buttonIn;
    }

    @Nonnull
    public <T extends DynamicWidget> T addWidget(@Nonnull T buttonIn) {
        if (!this.extendedWidgets.contains(buttonIn)) {
            buttonIn.setControlPosY(this.getTop() + buttonIn.getTop());
            this.extendedWidgets.add(buttonIn);
        }
        return buttonIn;
    }

    public void renderCriticalData() {
        this.drawBackground(this.getLeft(), this.getRight(), this.getTop(), this.getBottom(), this.getOffset(), this.getTintFactor(), this.getScreenBackground());
    }

    public void drawBackground(double left, double right, double top, double bottom, double offset, float tintFactor, double u, double v, ColorData data) {
        tintFactor = MathUtils.clamp(tintFactor, 0.0f, 1.0f);
        Color startColor = StringUtils.offsetColor(data.getStartColor(), tintFactor);
        Color endColor = StringUtils.offsetColor(data.getEndColor(), tintFactor);
        if (StringUtils.isNullOrEmpty(data.getTexLocation())) {
            RenderUtils.drawGradient(left, right, top, bottom, 300.0, startColor, endColor);
        } else {
            Tuple<Boolean, String, ResourceLocation> textureData = RenderUtils.getTextureData(data.getTexLocation());
            boolean usingExternalTexture = textureData.getFirst();
            ResourceLocation texLocation = textureData.getThird();
            this.drawTexture(left, right, top, bottom, usingExternalTexture, offset, u, v, startColor, endColor, texLocation);
        }
    }

    public void drawBackground(double left, double right, double top, double bottom, double offset, float tintFactor, ColorData data) {
        this.drawBackground(left, right, top, bottom, offset, tintFactor, left, top, data);
    }

    public void drawTexture(double left, double right, double top, double bottom, boolean usingExternalTexture, double offset, double u, double v, Object startColorObj, Object endColorObj, ResourceLocation texLocation) {
        RenderUtils.drawTexture(this.getGameInstance(), left, right, top, bottom, 0.0, usingExternalTexture, right - left, bottom - top, u, v + offset, 32.0, 32.0, startColorObj, endColorObj, texLocation);
    }

    public boolean hasWorld() {
        return this.getGameInstance().field_71441_e != null;
    }

    public ColorData getRawBackground() {
        return this.hasWorld() ? CraftPresence.CONFIG.accessibilitySettings.altGuiBackground : CraftPresence.CONFIG.accessibilitySettings.guiBackground;
    }

    public float getTintFactor() {
        return 1.0f;
    }

    public ColorData getScreenBackground() {
        ColorData data = this.getRawBackground();
        if (!this.hasWorld()) {
            data.getStart().alpha = 255;
            data.getEnd().alpha = 255;
        }
        return data;
    }

    public double getOffset() {
        return 0.0;
    }

    public void preRender() {
        for (DynamicWidget widget : this.getWidgets()) {
            widget.preDraw(this);
        }
    }

    public void renderExtra() {
        for (DynamicWidget widget : this.getWidgets()) {
            widget.draw(this);
        }
    }

    public void postRender() {
        for (DynamicWidget widget : this.getWidgets()) {
            widget.postDraw(this);
        }
    }

    public void func_146270_b(int tint) {
        this.renderCriticalData();
    }

    public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
        if (this.isLoaded()) {
            this.preRender();
            RenderUtils.enableScissor(this.getGameInstance(), this.getLeft(), this.getTop(), this.getRight(), this.getBottom());
            this.func_146276_q_();
            for (ScrollableListControl listControl : this.getLists()) {
                if (!listControl.func_148125_i()) continue;
                listControl.func_148128_a(mouseX, mouseY, partialTicks);
            }
            super.func_73863_a(mouseX, mouseY, partialTicks);
            for (Gui extendedControl : this.getControls()) {
                if (!(extendedControl instanceof ExtendedTextControl)) continue;
                ExtendedTextControl textField = (ExtendedTextControl)extendedControl;
                textField.func_146194_f();
            }
            this.renderExtra();
            RenderUtils.disableScissor(this.getGameInstance());
            this.lastMouseX = mouseX;
            this.lastMouseY = mouseY;
            this.isOverScreen = RenderUtils.isMouseOver((double)mouseX, (double)mouseY, this);
            for (Gui extendedControl : this.getControls()) {
                if (!(extendedControl instanceof ExtendedScreen)) continue;
                ((ExtendedScreen)extendedControl).func_73863_a(mouseX, mouseY, partialTicks);
            }
            this.postRender();
        }
    }

    public void func_146274_d() {
        if (this.isLoaded()) {
            this.setMouseScroll(Mouse.getEventDWheel());
            for (ScrollableListControl listControl : this.getLists()) {
                listControl.func_178039_p();
            }
            int dw = this.getMouseScroll();
            if (dw != 0) {
                this.mouseScrolled(this.getMouseX(), this.getMouseY(), (int)((double)dw / 60.0));
            }
            super.func_146274_d();
        }
    }

    public void mouseScrolled(int mouseX, int mouseY, int wheelY) {
        if (this.isLoaded()) {
            for (Gui extendedControl : this.getControls()) {
                if (!(extendedControl instanceof ExtendedScreen)) continue;
                ((ExtendedScreen)extendedControl).mouseScrolled(mouseX, mouseY, wheelY);
            }
        }
    }

    protected void func_146284_a(@Nonnull GuiButton button) {
        if (this.isOverScreen()) {
            if (button instanceof ExtendedButtonControl) {
                ((ExtendedButtonControl)button).onClick();
            }
            super.func_146284_a(button);
        }
    }

    protected void func_73869_a(char typedChar, int keyCode) {
        if (this.isLoaded()) {
            if (keyCode == 1 && this.canClose) {
                this.openScreen(this.parentScreen);
                return;
            }
            for (Gui extendedControl : this.getControls()) {
                if (extendedControl instanceof ExtendedTextControl) {
                    ExtendedTextControl textField = (ExtendedTextControl)extendedControl;
                    textField.func_146201_a(typedChar, keyCode);
                }
                if (!(extendedControl instanceof ExtendedScreen)) continue;
                ((ExtendedScreen)extendedControl).func_73869_a(typedChar, keyCode);
            }
        }
    }

    protected void func_73864_a(int mouseX, int mouseY, int mouseButton) {
        if (this.isLoaded()) {
            for (Gui extendedControl : this.getControls()) {
                if (extendedControl instanceof ExtendedTextControl) {
                    ExtendedTextControl textField = (ExtendedTextControl)extendedControl;
                    textField.func_146192_a(mouseX, mouseY, mouseButton);
                }
                if (!(extendedControl instanceof ExtendedScreen)) continue;
                ((ExtendedScreen)extendedControl).func_73864_a(mouseX, mouseY, mouseButton);
            }
            super.func_73864_a(mouseX, mouseY, mouseButton);
        }
    }

    protected void func_146273_a(int mouseX, int mouseY, int mouseButton, long timeSinceLastClick) {
        if (this.isLoaded()) {
            for (Gui extendedControl : this.getControls()) {
                if (!(extendedControl instanceof ExtendedScreen)) continue;
                ((ExtendedScreen)extendedControl).func_146273_a(mouseX, mouseY, mouseButton, timeSinceLastClick);
            }
            super.func_146273_a(mouseX, mouseY, mouseButton, timeSinceLastClick);
        }
    }

    protected void func_146286_b(int mouseX, int mouseY, int state) {
        if (this.isLoaded()) {
            for (Gui extendedControl : this.getControls()) {
                if (!(extendedControl instanceof ExtendedScreen)) continue;
                ((ExtendedScreen)extendedControl).func_146286_b(mouseX, mouseY, state);
            }
            super.func_146286_b(mouseX, mouseY, state);
        }
    }

    public void func_73876_c() {
        if (this.isLoaded()) {
            for (Gui extendedControl : this.getControls()) {
                if (extendedControl instanceof ExtendedTextControl) {
                    ExtendedTextControl textField = (ExtendedTextControl)extendedControl;
                    textField.func_146178_a();
                }
                if (!(extendedControl instanceof ExtendedScreen)) continue;
                ((ExtendedScreen)extendedControl).func_73876_c();
            }
            super.func_73876_c();
        }
    }

    public void func_146281_b() {
        if (this.isLoaded()) {
            for (Gui extendedControl : this.getControls()) {
                if (!(extendedControl instanceof ExtendedScreen)) continue;
                ((ExtendedScreen)extendedControl).func_146281_b();
            }
            this.clearData();
            ExtendedScreen.resetIndex();
            Keyboard.enableRepeatEvents((boolean)false);
        }
    }

    public Minecraft getGameInstance() {
        return this.field_146297_k;
    }

    public void setGameInstance(Minecraft instance) {
        this.field_146297_k = instance;
    }

    public void openScreen(GuiScreen targetScreen) {
        RenderUtils.openScreen(this.getGameInstance(), targetScreen);
    }

    public int computeGuiScale() {
        return RenderUtils.computeGuiScale(this.getGameInstance());
    }

    public int getButtonY(int order) {
        return 40 + 25 * (order - 1);
    }

    public int getButtonY(int order, int offset, boolean appendByOrder) {
        return this.getButtonY(order) + offset * (appendByOrder ? order : 1);
    }

    public int getButtonY(int order, int offset) {
        return this.getButtonY(order, offset, false);
    }

    public Tuple<Boolean, ColorData, ColorData> createDefaultTooltip() {
        return new Tuple<Boolean, ColorData, ColorData>(CraftPresence.CONFIG.accessibilitySettings.renderTooltips, CraftPresence.CONFIG.accessibilitySettings.tooltipBackground, CraftPresence.CONFIG.accessibilitySettings.tooltipBorder);
    }

    public void drawMultiLineString(List<String> textToInput, int posX, int posY, int maxWidth, int maxHeight, int maxTextWidth, boolean isCentered, boolean isTooltip, Tuple<Boolean, ColorData, ColorData> colorInfo) {
        RenderUtils.drawMultiLineString(this.getGameInstance(), textToInput, posX, posY, maxWidth, maxHeight, maxTextWidth, this.getFontRenderer(), isCentered, isTooltip, colorInfo);
    }

    public void drawMultiLineString(List<String> textToInput, int posX, int posY, int maxWidth, int maxHeight, int maxTextWidth) {
        this.drawMultiLineString(textToInput, posX, posY, maxWidth, maxHeight, maxTextWidth, false, true, this.createDefaultTooltip());
    }

    public void drawMultiLineString(List<String> textToInput, int posX, int posY) {
        this.drawMultiLineString(textToInput, posX, posY, this.getScreenWidth(), this.getScreenHeight(), this.getWrapWidth());
    }

    public void drawMultiLineString(List<String> textToInput) {
        this.drawMultiLineString(textToInput, this.getMouseX(), this.getMouseY());
    }

    public void renderScrollingString(String message, float centerX, float minX, float minY, float maxX, float maxY, int color) {
        RenderUtils.renderScrollingString(this.getGameInstance(), this.getFontRenderer(), message, centerX, minX, minY, maxX, maxY, color);
    }

    public void renderScrollingString(String message, int centerX, int minX, int minY, int maxX, int maxY, int color) {
        RenderUtils.renderScrollingString(this.getGameInstance(), this.getFontRenderer(), message, centerX, minX, minY, maxX, maxY, color);
    }

    public void renderScrollingString(String message, float minX, float minY, float maxX, float maxY, int color) {
        this.renderScrollingString(message, maxX - (maxX - minX) / 2.0f, minX, minY, maxX, maxY, color);
    }

    public void renderScrollingString(String message, int minX, int minY, int maxX, int maxY, int color) {
        this.renderScrollingString(message, maxX - (maxX - minX) / 2, minX, minY, maxX, maxY, color);
    }

    public void renderCenteredString(String text, float xPos, float yPos, int color) {
        RenderUtils.renderCenteredString(this.getFontRenderer(), text, xPos, yPos, color);
    }

    public void renderCenteredString(String text, int xPos, int yPos, int color) {
        RenderUtils.renderCenteredString(this.getFontRenderer(), text, xPos, yPos, color);
    }

    public void renderCenteredString(String text, float yPos, int color) {
        this.renderCenteredString(text, (float)this.getScreenWidth() / 2.0f, yPos, color);
    }

    public void renderCenteredString(String text, int yPos, int color) {
        this.renderCenteredString(text, this.getScreenWidth() / 2, yPos, color);
    }

    public void renderString(String text, float xPos, float yPos, int color) {
        RenderUtils.renderString(this.getFontRenderer(), text, xPos, yPos, color);
    }

    public void renderString(String text, int xPos, int yPos, int color) {
        this.renderString(text, (float)xPos, (float)yPos, color);
    }

    public int getStringWidth(String string) {
        return RenderUtils.getStringWidth(this.getFontRenderer(), string);
    }

    public List<String> createRenderLines(List<String> original, int wrapWidth) {
        List<String> data = StringUtils.newArrayList();
        for (String line : original) {
            data.addAll(RenderUtils.listFormattedStringToWidth(this.getFontRenderer(), line, wrapWidth));
        }
        return data;
    }

    public List<String> createRenderLines(String original, int wrapWidth) {
        return this.createRenderLines(StringUtils.splitTextByNewLine(original, true), wrapWidth);
    }

    public int getWrapWidth() {
        return -1;
    }

    public int getMouseX() {
        return this.lastMouseX;
    }

    public int getMouseY() {
        return this.lastMouseY;
    }

    public int getScreenX() {
        return this.screenX;
    }

    public void setScreenX(int screenX) {
        this.screenX = screenX;
    }

    public int getScreenY() {
        return this.screenY;
    }

    public void setScreenY(int screenY) {
        this.screenY = screenY;
    }

    public boolean isOverScreen() {
        return this.isOverScreen;
    }

    public int getMouseScroll() {
        return this.lastMouseScroll;
    }

    public void setMouseScroll(int mouseScroll) {
        this.lastMouseScroll = mouseScroll;
    }

    public void resetMouseScroll() {
        this.setMouseScroll(0);
    }

    public int getMaxWidth() {
        return this.getScreenWidth();
    }

    public int getScreenWidth() {
        return this.field_146294_l;
    }

    public void setScreenWidth(int screenWidth) {
        this.field_146294_l = screenWidth;
    }

    public int getContentHeight() {
        return this.contentHeight;
    }

    public void setContentHeight(int contentHeight) {
        this.contentHeight = contentHeight;
    }

    public void refreshContentHeight() {
        this.setContentHeight(0);
        for (DynamicWidget widget : this.getWidgets()) {
            int widgetHeight = widget.getBottom();
            if (widgetHeight <= this.getContentHeight()) continue;
            this.setContentHeight(widgetHeight);
        }
    }

    public int getScreenHeight() {
        return this.field_146295_m;
    }

    public void setScreenHeight(int screenHeight) {
        this.field_146295_m = screenHeight;
    }

    public FontRenderer getFontRenderer() {
        return this.getGameInstance().field_71466_p != null ? this.getGameInstance().field_71466_p : GuiUtils.getDefaultFontRenderer();
    }

    public int getFontHeight() {
        return RenderUtils.getFontHeight(this.getFontRenderer());
    }

    public int getLeft() {
        return this.getScreenX();
    }

    public int getRight() {
        return this.getScreenX() + this.getScreenWidth();
    }

    public int getBottom() {
        return this.getScreenY() + this.getScreenHeight();
    }

    public int getTop() {
        return this.getScreenY();
    }

    public boolean isDebugMode() {
        return this.debugMode;
    }

    public void setDebugMode(boolean isDebugMode) {
        this.debugMode = isDebugMode;
    }

    public boolean isVerboseMode() {
        return this.verboseMode;
    }

    public void setVerboseMode(boolean isVerboseMode) {
        this.verboseMode = isVerboseMode;
    }

    public List<Gui> getControls() {
        return StringUtils.newArrayList(this.extendedControls);
    }

    public List<DynamicWidget> getWidgets() {
        return StringUtils.newArrayList(this.extendedWidgets);
    }

    public List<ScrollableListControl> getLists() {
        return StringUtils.newArrayList(this.extendedLists);
    }

    public boolean isLoaded() {
        return this.currentPhase == Phase.READY;
    }

    public static enum Phase {
        PREINIT,
        INIT,
        READY;

    }
}

