/*
 * Decompiled with CFR 0.152.
 */
package com.feed_the_beast.mods.ftbultimine;

import java.util.HashSet;
import java.util.Set;
import java.util.function.Supplier;
import net.minecraft.block.Block;
import net.minecraft.block.BlockSapling;
import net.minecraft.block.IGrowable;
import net.minecraft.item.Item;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.registry.RegistryNamespaced;
import net.minecraftforge.common.config.Config;

@Config(modid="ftbultimine")
public class FTBUltimineConfig {
    @Config.RangeInt(min=1, max=512)
    public static int maxBlocks = 64;
    @Config.RangeInt(min=0, max=2)
    @Config.Comment(value={"0 - Drop at position where mined block was", "1 - drop at player position", "2 - place directly in inventory"})
    public static int dropItems = 0;
    public static String[] breakBlacklist = new String[0];
    public static String[] breakWhitelist = new String[0];
    public static String[] toolBlacklist = new String[0];
    @Config.RangeDouble(min=0.0, max=1000.0)
    public static double exhaustionPerBlock = 4.0;
    public static boolean allowHand = true;
    public static boolean mergeStone = true;
    @Config.RangeDouble(min=0.0, max=1.0)
    public static double twerkChance = 0.0;
    @Config.RangeInt(min=1, max=20)
    public static int twerkRadius = 4;
    public static boolean twerkPlants = false;
    public static String[] twerkBlacklist = new String[]{"minecraft:grass", "minecraft:tallgrass"};
    public static String[] twerkWhitelist = new String[0];
    @Config.Comment(value={"Required for some modpacks"})
    public static int renderTextManually = -1;
    private static final CachedList<Block> cachedBreakBlacklist = new CachedList(() -> breakBlacklist, Block.field_149771_c);
    private static final CachedList<Block> cachedBreakWhitelist = new CachedList(() -> breakWhitelist, Block.field_149771_c);
    private static final CachedList<Item> cachedToolBlacklist = new CachedList(() -> toolBlacklist, Item.field_150901_e);
    private static final CachedList<Block> cachedTwerkBlacklist = new CachedList(() -> twerkBlacklist, Block.field_149771_c);
    private static final CachedList<Block> cachedTwerkWhitelist = new CachedList(() -> twerkWhitelist, Block.field_149771_c);

    public static boolean breakWhitelist(Block block) {
        return (cachedBreakWhitelist.get().isEmpty() || cachedBreakWhitelist.get().contains(block)) && !cachedBreakBlacklist.get().contains(block);
    }

    public static boolean toolBlacklist(Item item) {
        return cachedToolBlacklist.get().contains(item);
    }

    public static boolean twerkWhitelist(Block block) {
        if (block instanceof IGrowable && !cachedTwerkBlacklist.get().contains(block)) {
            return twerkPlants || block instanceof BlockSapling || cachedTwerkWhitelist.get().contains(block);
        }
        return false;
    }

    private static class CachedList<T> {
        private final Supplier<String[]> supplier;
        private String[] cached = null;
        private final HashSet<T> set = new HashSet();
        private final RegistryNamespaced<ResourceLocation, T> registry;

        public CachedList(Supplier<String[]> s, RegistryNamespaced<ResourceLocation, T> r) {
            this.supplier = s;
            this.registry = r;
        }

        public Set<T> get() {
            String[] s = this.supplier.get();
            if (this.cached != s) {
                this.cached = s;
                this.set.clear();
                Object def = this.registry.func_82594_a((Object)new ResourceLocation("default:default"));
                for (String s1 : s) {
                    Object b = this.registry.func_82594_a((Object)new ResourceLocation(s1.trim()));
                    if (b == null || b == def) continue;
                    this.set.add(b);
                }
            }
            return this.set;
        }
    }
}

